/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class XmlHandler
extends DefaultHandler {
    private Bon b = new Bon();
    private Produs last;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            String name = attributes.getValue("label");
            double price = Utils.parseDouble(attributes.getValue("price"));
            double quantity = Utils.parseDouble(attributes.getValue("quantity"));
            String tva = attributes.getValue("vat");
            char c1 = 'A';
            if (Validators.correctString(tva)) {
                c1 = tva.charAt(0);
            }
            Produs p = new Produs(name, price, quantity, c1);
            this.b.add(p);
            this.last = p;
        } else if (qName.equalsIgnoreCase("payment")) {
            double amount = 0.0;
            String Amount = attributes.getValue("amount");
            if (Validators.correctDouble(Amount)) {
                amount = Utils.parseDouble(Amount);
            }
            String type = attributes.getValue("type");
            Payment.TYPE payment_type = null;
            if (type.equalsIgnoreCase("card")) {
                payment_type = Payment.TYPE.CC;
            }
            if (type.equalsIgnoreCase("ticket")) {
                payment_type = Payment.TYPE.COUPON;
            }
            if (type.equalsIgnoreCase("cash")) {
                payment_type = Payment.TYPE.CASH;
            }
            if (type.equalsIgnoreCase("check")) {
                payment_type = Payment.TYPE.CHECK;
            }
            if (type.equalsIgnoreCase("credit")) {
                payment_type = Payment.TYPE.CARD;
            }
            Payment payment = new Payment(amount, payment_type);
            this.b.addPayment(payment);
        } else if (qName.equalsIgnoreCase("ad")) {
            String text = attributes.getValue("text");
            if (!Validators.correctString(text)) {
                text = " ";
            }
            this.b.add(text);
        } else if (qName.equalsIgnoreCase("discount")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            this.last.setAdaos(-percent);
        } else if (qName.equalsIgnoreCase("adaos")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            this.last.setAdaos(percent);
        }
    }

    public EcrReceipt getReceipt() {
        return this.b;
    }
}

