/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ZipUtils;

public class Logger
extends EcrLogger {
    private String dir;
    private Date date;
    private StringBuffer buffer = new StringBuffer();
    public static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private boolean systemout = false;

    public Logger(String dir) {
        this.dir = dir;
        new Thread(){

            @Override
            public void run() {
                SerialUtils.sleep(5000L);
                Logger.this.archiveLogs();
            }
        }.start();
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void log(String s) {
        this.buffer.append(s);
        this.buffer.append("\n");
        if (this.systemout) {
            System.out.println(s);
        }
    }

    public void flush() {
        try {
            File f = new File(this.dir + File.separator + Formatters.DATE_FORMAT.format(this.date));
            f.mkdirs();
            FileUtils.writeTextToFile(f.getAbsolutePath() + File.separator + formatter.format(this.date) + ".log", this.buffer.toString());
        }
        catch (IOException e) {
            ro.atreides.utils.Logger.logException(this, (Exception)e);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    private void archiveLogs() {
        final Pattern p = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}$");
        final String s = Formatters.DATE_FORMAT.format(new Date());
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && p.matcher(pathname.getName()).matches() && !pathname.getName().equals(s);
            }
        };
        File f = new File(this.dir);
        if (f.exists() && f.isDirectory()) {
            File[] toarchive = f.listFiles(filter);
            for (int i = 0; i < toarchive.length; ++i) {
                File file = toarchive[i];
                try {
                    ZipUtils.zipCreateRecursive(file.getAbsolutePath(), file.getAbsolutePath() + ".zip");
                }
                catch (IOException e) {
                    FileUtils.removeFileRecurse(new File(file.getAbsolutePath() + ".zip"));
                }
                FileUtils.removeFileRecurse(file);
            }
        }
    }
}

