/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import purejavacomm.SerialPort;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.SerialEcr;
import ro.atreides.ecr.SerialReader;
import ro.atreides.ecr.SerialUtils;
import ro.atreides.ecr.SerialWriter;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.DriverInterface;
import ro.atreides.ecr.optimus.nativeImpl.Logger;
import ro.atreides.ecr.optimus.nativeImpl.Message;
import ro.atreides.ecr.optimus.nativeImpl.MessageFactory;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.ecr.optimus.nativeImpl.Reader;
import ro.atreides.ecr.optimus.nativeImpl.Types;
import ro.atreides.utils.FloatUtils;

public class MG1200Impl
extends SerialEcr {
    private static final int TIMEOUT = 3000;
    private MessageFactory factory = new MessageFactory();

    public MG1200Impl(String id, Vector portFilters) {
        super("driver" + File.separator + "optimus" + id + File.separator);
        super.setFilters(portFilters);
        this.logger = new Logger("driver" + File.separator + "optimus" + id + File.separator + "logs");
        this.setDriverInterface(new DriverInterface());
    }

    @Override
    public SerialReader buildReader(SerialPort port, InputStream in) {
        port.setRTS(true);
        return new Reader(in, port);
    }

    @Override
    public SerialWriter buildWriter(SerialPort serialPort, OutputStream out) {
        serialPort.setRTS(true);
        return new SerialWriter(out){

            @Override
            public void log(String s) {
            }
        };
    }

    @Override
    protected Integer[] buildSpeeds() {
        return new Integer[]{9600, 38400, 19200, 9600, 4800, 2400, 1200};
    }

    private Message read() throws EcrClosedException {
        Message m = (Message)super.read(3000);
        this.log("<< " + m);
        return m;
    }

    private void write(byte b) throws EcrClosedException {
        super.write(new byte[]{b});
        switch (b) {
            case 4: {
                this.log(">> END");
                break;
            }
            case 6: {
                this.log(">> ACK");
                break;
            }
            case 5: {
                this.log(">> ENQUIRE");
                break;
            }
            default: {
                this.log(">> " + BinaryUtils.toHexString(b));
            }
        }
    }

    @Override
    protected void write(byte[] b) throws EcrClosedException {
        super.write(b);
        this.log(">> " + new String(b) + " " + BinaryUtils.toHexString(b));
    }

    @Override
    public boolean detectDevice(SerialReader reader, SerialWriter writer) {
        try {
            byte[] b = new byte[]{5};
            ro.atreides.utils.Logger.logVerbose(this, "writing : " + BinaryUtils.toHexString(b));
            writer.writetoport(b);
            Message m = (Message)reader.read(3000);
            ro.atreides.utils.Logger.logVerbose(this, "reading : " + m);
            if (m.getType() == Types.ACK) {
                reader.setLogger(this.logger);
                writer.setLogger(this.logger);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void newReceipt(EcrReceipt receipt) throws EcrClosedException {
        try {
            ((Logger)this.logger).setDate(new Date());
            this.logger.log(receipt.toString());
            Bon b = (Bon)receipt;
            Vector products = b.get();
            this.clearReader();
            this.write((byte)5);
            this.read();
            this.write(MessageFactory.START);
            this.read();
            this.write(this.factory.buildAnulare());
            Message m = this.read();
            if (m.getType() == Types.ERROR) {
                this.write((byte)4);
                this.read();
                this.write((byte)6);
                m = this.read();
                this.write((byte)6);
                this.read();
                this.write((byte)4);
            } else if (m.getType() == Types.ACK) {
                this.write((byte)4);
                this.read();
            }
            this.write((byte)5);
            this.read();
            this.write(MessageFactory.START);
            this.read();
            double total = 0.0;
            block11: for (int i = 0; i < products.size(); ++i) {
                double valoareRounded;
                double valoareInitiala;
                double qtyRounded;
                double qtyInitial;
                double pretRounded;
                Produs p = (Produs)products.get(i);
                double priceInitial = p.getPrice();
                if (priceInitial != (pretRounded = FloatUtils.roundDoubleUp(priceInitial, 3))) {
                    this.log("!!ROUNDED PRICE : " + priceInitial + " to : " + pretRounded);
                }
                if ((qtyInitial = p.getQuantity()) != (qtyRounded = FloatUtils.roundDoubleUp(qtyInitial, 3))) {
                    this.log("!!ROUNDED QTY : " + qtyInitial + " to : " + qtyRounded);
                }
                if ((valoareInitiala = pretRounded * qtyRounded) != (valoareRounded = FloatUtils.roundDoubleUp(valoareInitiala, 2))) {
                    this.log("!!ROUNDED VALUE : " + valoareInitiala + " to : " + valoareRounded);
                }
                this.write(this.factory.buildSale(p.getName(), pretRounded, qtyRounded, p.getCodTva(), valoareRounded));
                m = this.read();
                Types type = m.getType();
                switch (type) {
                    case ACK: {
                        total += valoareRounded;
                        break;
                    }
                    case ERROR: {
                        this.write((byte)4);
                        m = this.read();
                        this.write((byte)6);
                        this.read();
                        this.write((byte)6);
                        this.read();
                        this.write((byte)4);
                        this.write((byte)5);
                        this.read();
                        this.write(MessageFactory.START);
                        this.read();
                        this.write(this.factory.buildAnulare());
                        m = this.read();
                        if (m.getType() != Types.ERROR) return;
                        this.write((byte)4);
                        m = this.read();
                        if (m.getType() != Types.ENQUIRE) return;
                        this.write((byte)6);
                        this.read();
                        this.write((byte)6);
                        this.read();
                        this.write((byte)4);
                        int r = ((DriverInterface)this.getDriverInterface()).raportZ(b);
                        if (r != 0) return;
                        this.clearReader();
                        SerialUtils.sleep(1000L);
                        this.write((byte)4);
                        this.read();
                        this.write((byte)5);
                        this.read();
                        this.write(MessageFactory.START);
                        this.read();
                        --i;
                        continue block11;
                    }
                    case NOTHING: {
                        int r = this.getDriverInterface().deviceRemoved(this.notifications);
                        if (r != 0) break;
                    }
                }
                if (p.getAdaos() == 0.0) continue;
                if (p.getAdaos() > 0.0) {
                    this.write(this.factory.buildAdaos(p.getAdaos()));
                    this.read();
                } else if (p.getAdaos() < 0.0) {
                    this.write(this.factory.buildDiscount(-p.getAdaos()));
                    this.read();
                }
                total += valoareRounded * (p.getAdaos() / 100.0);
            }
            if (b.getAdaosTotal() != 0.0) {
                if (b.getAdaosTotal() > 0.0) {
                    this.write(this.factory.buildAdaosTotal(b.getAdaosTotal()));
                } else {
                    this.write(this.factory.buildDiscountTotal(-b.getAdaosTotal()));
                }
                m = this.read();
                if (m.getType() == Types.ERROR) {
                    this.write((byte)4);
                    m = this.read();
                    if (m.getType() != Types.ENQUIRE) return;
                    this.write((byte)6);
                    m = this.read();
                    this.write((byte)6);
                    m = this.read();
                    this.write((byte)4);
                    this.write((byte)5);
                    this.read();
                    this.write(MessageFactory.START);
                    this.read();
                    this.write(this.factory.buildAnulare());
                    this.read();
                    this.write((byte)4);
                    this.read();
                    return;
                }
                total += total * (b.getAdaosTotal() / 100.0);
            }
            Vector comments = b.getComments();
            for (int i = 0; i < comments.size(); ++i) {
                String c = (String)comments.get(i);
                this.write(this.factory.buildComment(c));
                this.read();
            }
            this.write(this.factory.buildTotal(total, b.getPayments()));
            m = this.read();
            if (m.getType() == Types.ERROR) {
                this.write((byte)4);
                m = this.read();
                if (m.getType() != Types.ENQUIRE) return;
                this.write((byte)6);
                m = this.read();
                this.write((byte)6);
                m = this.read();
                this.write((byte)4);
                this.write((byte)5);
                this.read();
                this.write(MessageFactory.START);
                this.read();
                this.write(this.factory.buildAnulare());
                this.read();
                this.write((byte)4);
                this.read();
                return;
            }
            this.write((byte)4);
            this.read();
            return;
        }
        finally {
            this.logger.log("\n\n");
            ((Logger)this.logger).flush();
            SerialUtils.sleep(3000L);
        }
    }
}

