/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.io.IOException;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.MessageFactory;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.FloatUtils;

public class TestSimple {
    private MessageFactory factory = new MessageFactory();
    private SerialPort port;

    public boolean init(String name, int speed) {
        try {
            CommPortIdentifier id = CommPortIdentifier.getPortIdentifier((String)name);
            this.port = (SerialPort)id.open("driver", 0);
            this.port.setSerialPortParams(speed, 8, 1, 0);
            this.port.setRTS(true);
            return true;
        }
        catch (NoSuchPortException e) {
            e.printStackTrace();
        }
        catch (PortInUseException e) {
            e.printStackTrace();
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void write(byte[] b) throws IOException {
        this.port.getOutputStream().write(b);
        this.port.getOutputStream().flush();
        System.out.println(">> " + BinaryUtils.toHexString(b));
    }

    public void write(byte b) throws IOException {
        this.write(new byte[]{b});
    }

    public byte[] read() throws IOException {
        byte[] buff = new byte[100];
        int n = this.port.getInputStream().read(buff);
        System.out.println("<< " + BinaryUtils.toHexString(buff, 0, n) + " " + new String(buff, 0, n));
        return buff;
    }

    public synchronized void sell(Bon b) throws IOException {
        Vector products = b.get();
        this.write((byte)4);
        this.read();
        this.write((byte)5);
        this.read();
        this.write(MessageFactory.START);
        this.read();
        double total = 0.0;
        for (int i = 0; i < products.size(); ++i) {
            Produs p = (Produs)products.get(i);
            double val = FloatUtils.roundDoubleUp(p.getPrice() * p.getQuantity(), 2);
            this.write(this.factory.buildSale(p.getName(), p.getPrice(), p.getQuantity(), 'A', val));
            this.read();
            total += val;
        }
        this.write(this.factory.buildTotal(total, total, 0.0, 0.0, 0.0, 0.0));
        this.read();
        this.write((byte)4);
        this.read();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        TestSimple t = new TestSimple();
        t.init("/dev/ttyS0", 9600);
        Bon b = new Bon(0);
        b.add(new Produs("COLA", 1.0, 1.0, 'A'));
        b.add(new Produs("COLA", 1.0, 1.0, 'A'));
        t.sell(b);
    }
}

