/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.partner;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean showDecimalSimbol;
    private String decimalSimbol;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        String property = conf.getProperty("showDecimalSimbol", "false");
        this.showDecimalSimbol = Boolean.parseBoolean(property);
        this.decimalSimbol = conf.getProperty("decimalSimbol", ".");
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        Iterator iter = sales.iterator();
        double discount = 0.0;
        while (iter.hasNext()) {
            EcrSale sale = (EcrSale)iter.next();
            int cod = sale.getCod();
            String codS = Utils.getStringMaxSize(10, "" + cod, Character.valueOf('6'), true);
            String price = this.getValue(sale.getPpuOriginal());
            double nrPortii = sale.getQuantity();
            String s = "";
            String newProduct = sale.getProduct();
            newProduct = newProduct.trim();
            Vector chars = Utils.splitString(newProduct, '\n');
            for (int i = 0; i < chars.size(); ++i) {
                String o = (String)chars.elementAt(i);
                s = s + o;
            }
            String saleCommand = "S;" + codS + ";" + s + ";" + price + ";" + Utils.getString3DecimalsNoTrunc(nrPortii) + ";" + sale.getDepartament() + ";" + Generic.getGrupa(sale) + ";" + sale.getCodTva() + ";;";
            items = items + saleCommand;
            items = items + "\n";
            discount += sale.getQuantity() * sale.getDiscount();
        }
        if ((discount = FloatUtils.roundDoubleUp(discount, this.onlineDecimalPlaces)) > 0.0) {
            String d = this.getValue(discount);
            String discountCommand = "D;4;" + d + ";";
            items = items + discountCommand;
            items = items + "\n";
        }
        if (plati == null || plati.size() == 0) {
            items = items + "T;1;;;\n";
        } else {
            for (EcrPlata plata : plati) {
                items = items + "T;" + plata.getEcrMapping() + ";" + this.getValue(plata.getSuma()) + ";;\n";
            }
        }
        this.pt.addToQueue(items);
    }

    private String getValue(double toConvert) {
        if (!this.showDecimalSimbol) {
            String result = Utils.getString2DecimalsNoTrunc(toConvert);
            result = result.replaceAll("\\.", "");
            result = result.replaceAll(",", "");
            return result;
        }
        String result = Utils.getString2DecimalsNoTrunc(toConvert);
        result = result.replaceAll("\\.", this.decimalSimbol);
        result = result.replaceAll(",", this.decimalSimbol);
        return result;
    }

    @Override
    public void introduNumerar(double suma) {
        String s = "I;1;" + Utils.getString2Decimals(suma) + ";";
        this.pt.addToQueue(s);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void forceTotal() {
    }
}

