/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.rompos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private static final char START_PAYMENT = '\u0007';
    private static final char CASH_DEFAULT = 'C';

    @Override
    public void buildConfiguration(Properties conf) throws RuntimeException {
        super.buildConfiguration(conf);
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String productsFile = "";
        for (EcrSale ecrSale : sales) {
            String numeProdus = ecrSale.getProduct();
            numeProdus = numeProdus.replaceAll("\t", "");
            numeProdus = numeProdus.trim();
            String codTva = ecrSale.getCodTva();
            codTva = codTva.replaceAll("\t", "");
            codTva = codTva.trim();
            String line = numeProdus + "\t";
            line = line + Utils.getString3DecimalsNoTrunc(ecrSale.getQuantity()) + "\t";
            long price = (long)(ecrSale.getPpuDupaDiscount() * 10000.0);
            line = line + price + "\t";
            line = line + codTva + "\t";
            line = line + "\n\r";
            productsFile = productsFile + line;
        }
        if (plati != null && plati.size() != 0) {
            productsFile = productsFile + '\u0007';
            productsFile = productsFile + "\t";
            for (EcrPlata plata : plati) {
                String p = plata.getEcrMapping();
                p = p.replaceAll("\t", "");
                p = p.trim();
                long totalPrice = (long)(total * 10000.0);
                productsFile = productsFile + p + "\t" + totalPrice + "\t";
            }
        }
        if (comments.size() > 0) {
            String commentsFile = "";
            for (int i = 0; i < comments.size(); ++i) {
                String s = (String)comments.elementAt(i);
                if (!Validators.correctString(s)) continue;
                s = Utils.getStringMaxSize(40, s, null, false);
                commentsFile = commentsFile + s + "\r\n";
            }
            this.printComments(commentsFile);
        }
        this.pt.addToQueue(productsFile);
    }

    @Override
    public void forceTotal() {
    }

    public void printComments(String comments) {
        try {
            FileWriter fw = new FileWriter(this.onlineDirectory + File.separator + "DESCRIERE.TXT");
            fw.write(comments);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void printX() {
        try {
            FileWriter fw = new FileWriter(this.onlineDirectory + File.separator + "RAPX.TXT");
            fw.write("\t");
            fw.close();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void printZ() {
        try {
            FileWriter fw = new FileWriter(this.onlineDirectory + File.separator + "RAPZ.TXT");
            fw.write("\t");
            fw.close();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

