/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.sapel;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean subtotalRequired;
    private boolean showDecimalSimbol;
    private String decimalSimbol = ".";

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.subtotalRequired = Boolean.parseBoolean(conf.getProperty("subtotalRequired", "false"));
        this.showDecimalSimbol = Boolean.parseBoolean(conf.getProperty("showDecimalSimbol", "false"));
        this.decimalSimbol = conf.getProperty("decimalSimbol", ".");
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        Iterator iter = sales.iterator();
        while (iter.hasNext()) {
            String line = "";
            EcrSale newsaleentry = (EcrSale)iter.next();
            line = line + Utils.getStringMaxSize(20, newsaleentry.getProduct(), Character.valueOf(' '), false) + ",";
            double quantity = newsaleentry.getQuantity();
            line = line + Utils.getStringMaxSize(8, Utils.getString3DecimalsNoTrunc(quantity), Character.valueOf('0'), true) + ",";
            long l = FloatUtils.convertToLong(newsaleentry.getPpuDupaDiscount(), this.onlineDecimalPlaces);
            String price = "" + l;
            line = line + Utils.getStringMaxSize(8, price, Character.valueOf('0'), true) + ",";
            String dep = "" + newsaleentry.getDepartament();
            dep = Utils.getStringMaxSize(2, dep, new Character('0'), true);
            line = line + dep;
            items = items + line + "\r\n";
        }
        if (this.subtotalRequired) {
            items = items + "+\r\n";
        }
        if (plati == null || plati.size() == 0) {
            if (cashDefault == null) {
                items = items + "<\r\n";
            } else {
                String sumaPlata = Utils.getString2DecimalsNoTrunc(total);
                if (this.decimalSimbol.contains(",")) {
                    sumaPlata = Utils.switchDecimalSimbols(sumaPlata);
                }
                if (!this.showDecimalSimbol) {
                    sumaPlata = Utils.stripDots(sumaPlata, this.decimalSimbol.charAt(0));
                }
                items = items + cashDefault.getEcrMapping() + "" + sumaPlata + "\r\n";
            }
        } else {
            for (EcrPlata plata : plati) {
                String sumaPlata = Utils.getString2DecimalsNoTrunc(plata.getSuma());
                if (this.decimalSimbol.contains(",")) {
                    sumaPlata = Utils.switchDecimalSimbols(sumaPlata);
                }
                if (!this.showDecimalSimbol) {
                    sumaPlata = Utils.stripDots(sumaPlata, this.decimalSimbol.charAt(0));
                }
                items = items + plata.getEcrMapping() + "" + sumaPlata + "\r\n";
            }
        }
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }
}

