/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.webxml;

import java.util.Properties;
import java.util.Vector;
import org.mortbay.jetty.Server;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private static Vector<String> xmlElements = new Vector();
    private boolean discountGlobal;
    private static Object lock = new Object();

    @Override
    public void buildConfiguration(Properties conf) throws RuntimeException {
        super.buildConfiguration(conf);
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
    }

    @Override
    public void stopECR() {
    }

    @Override
    public void startECR() {
        try {
            try {
                Logger.logInfo(this, "starting webecr servlets");
                if (this.webserver != null) {
                    Server s = (Server)this.webserver.prepareWebServer(this.webServerPort);
                    s.addWebApplication("/webecr", "./webapps/webecr/");
                }
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
        }
        catch (IllegalArgumentException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
    }

    @Override
    public void processXml(String fileName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAndRemoveAllBons() {
        Object object = lock;
        synchronized (object) {
            String allDoc = "<?xml version='1.0' encoding='utf-8'?>\n\n<document>\n\n";
            for (String xmlElement : xmlElements) {
                allDoc = allDoc + xmlElement;
            }
            allDoc = allDoc + "\n\n</document>";
            xmlElements.clear();
            return allDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        Object object = lock;
        synchronized (object) {
            String result = "<receipt bonId=\"" + orderIdentifier + "\" idOrder=\"" + idOrder + "\">\n\n";
            double totalFaraReducere = 0.0;
            double totalReducere = 0.0;
            for (EcrSale sale : sales) {
                String name = sale.getProduct();
                double nrPortii = sale.getQuantity();
                double ppu = sale.getPpuDupaDiscount();
                String line = "<product label=\"" + name + "\"" + " price=\"" + Utils.getString2Decimals(ppu) + "\"" + " quantity=\"" + nrPortii + "\"" + " vat=\"" + sale.getCodTva() + "\"" + " priceOriginal=\"" + Utils.getString2DecimalsNoTrunc(sale.getPpuOriginal()) + "\"" + "/>\n";
                totalFaraReducere += sale.getPpuOriginal() * nrPortii;
                totalReducere += (sale.getPpuOriginal() - sale.getPpuDupaDiscount()) * nrPortii;
                result = result + line;
            }
            result = result + "\n\n";
            for (Object comment : comments) {
                String com = (String)comment;
                String line = "<ad text=\"" + com + "\"/>\n";
                result = result + line;
            }
            result = result + "\n\n";
            for (EcrPlata plata : plati) {
                String line = "<payment type=\"" + plata.getTipPlata() + "\" amount=\"" + plata.getSuma() + "\"/>\n";
                result = result + line;
            }
            result = result + "</receipt>\n\n";
            xmlElements.add(result);
        }
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNonPrintedBons() {
        Object object = lock;
        synchronized (object) {
            xmlElements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNoOfBonsToPrint() {
        Object object = lock;
        synchronized (object) {
            return xmlElements.size();
        }
    }
}

