/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.xkube;

import java.io.File;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private String tvaDefault = "1";
    private int nonFiscalIndex = 1;
    private String onlineNfDestinationMask;

    @Override
    public void printZ() {
        String items = "15";
        this.pt.addToQueue(items);
    }

    @Override
    public void printX() {
        String items = "30";
        this.pt.addToQueue(items);
    }

    @Override
    public void introduNumerar(double suma) {
        long printPrice = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            printPrice *= 10L;
        }
        long l = 0L;
        String explicatii = "";
        String tip = "";
        if (suma < 0.0) {
            l = (long)(-suma * (double)printPrice);
            tip = "1";
            explicatii = "PLATI";
        } else {
            explicatii = "SOLD INITIAL";
            tip = "2";
            l = (long)(suma * (double)printPrice);
        }
        explicatii = Utils.getStringMaxSize(32, explicatii, null, false);
        String items = "25;" + tip + ";" + l + ";" + explicatii;
        this.pt.addToQueue(items);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.onlineNfDestinationMask = conf.getProperty("nonfiscalReceiptDestinationMask", "xkube/Online_nf_%%nrbon%%.txt");
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = "";
        long printPrice = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            printPrice *= 10L;
        }
        for (EcrSale newsaleentry : sales) {
            String product = newsaleentry.getProduct();
            double nrPortii = FloatUtils.roundDouble(newsaleentry.getQuantity(), 2);
            double orig = FloatUtils.roundDouble(newsaleentry.getPpuOriginal(), 2);
            double cuReducere = FloatUtils.roundDouble(newsaleentry.getPpuDupaDiscount(), 2);
            double d1 = FloatUtils.roundDouble((double)printPrice * orig, 2);
            long p = (long)d1;
            long q = (long)(1000.0 * nrPortii);
            String codTva = "" + this.tvaDefault;
            if (Validators.correctString(newsaleentry.getCodTva())) {
                codTva = newsaleentry.getCodTva();
            }
            String prodLabel = Utils.getStringMaxSize(32, product, Character.valueOf(' '), false);
            String deptLabel = Utils.getStringMaxSize(2, newsaleentry.getDepartament(), Character.valueOf('0'), true);
            String commandText = "1;" + prodLabel + ";1;" + deptLabel + ";" + codTva + ";" + p + ";" + q + ";0;1";
            items = items + commandText;
            items = items + "\n";
            if (orig == cuReducere) continue;
            String tip = "";
            double origD = FloatUtils.roundDouble((double)printPrice * orig * nrPortii, 2);
            long origL = (long)origD;
            double cuRed = FloatUtils.roundDouble((double)printPrice * cuReducere * nrPortii, 2);
            long cuReducereL = (long)cuRed;
            long val = 0L;
            if (orig > cuReducere) {
                tip = "1";
                val = origL - cuReducereL;
            } else {
                tip = "0";
                val = cuReducereL - origL;
            }
            String line = "7;" + tip + ";0;1;0;" + val + ";1";
            items = items + line + "\n";
        }
        if (plati == null || plati.size() == 0) {
            long totalL = (long)(total * (double)printPrice);
            items = items + "5;" + totalL + ";1;1;0\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                double p = FloatUtils.roundDouble(plata.getSuma(), 2);
                String s = "";
                double newPrice = FloatUtils.roundDouble(p * (double)printPrice, 2);
                long l = (long)newPrice;
                s = l + "";
                items = items + "5;" + s + ";" + plata.getEcrMapping() + ";1;0;\n";
                totalPlatit += plata.getSuma();
            }
            double diff = total - totalPlatit;
            if (Utils.isValueGreaterThanZero(diff)) {
                String s = "";
                double v = FloatUtils.roundDouble(diff * (double)printPrice, 2);
                long l = (long)v;
                s = l + "";
                items = items + "5;" + s + ";" + cashDefault.getEcrMapping() + ";1;0;\n";
            }
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            if (!Validators.correctString(o = o.toUpperCase())) {
                o = "*";
            }
            int chunck = 20;
            int index = 0;
            while (index < o.length()) {
                int end = index;
                end = index + chunck > o.length() ? o.length() : index + chunck;
                String s = o.substring(index, end);
                s = Utils.getStringMaxSize(20, s, Character.valueOf(' '), false);
                String line = "12;1;" + s + ";";
                items = items + line + "\n";
                index = end;
            }
        }
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void printNonFiscalBon(String inputFile) {
        File f = new File(inputFile);
        String outputFile = this.onlineNfDestinationMask.replaceAll("%%nrbon", "" + this.nonFiscalIndex);
        File outF = new File(outputFile);
        int tries = 10;
        boolean done = false;
        while (!done && tries > 0) {
            done = f.renameTo(outF);
            --tries;
            if (done) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {}
        }
        if (!done) {
            Logger.logError((Object)this, "EROARE LA MUTARE FISIER !");
        }
    }
}

