/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.database;

import ro.atreides.utils.Utils;

public class ProductData
implements Cloneable {
    private String name;
    private String price;
    private String quantityString;
    private String productCode;
    private String departement;
    private String group;
    private String tvaGroup;
    private double quantity;
    private double pret;
    private int productId;

    public ProductData(String code, String name, String price, String quantityString, String departament, String group, String tvaGroup, double quantity) {
        this.productCode = code;
        this.setName(name);
        this.price = price;
        this.quantityString = quantityString;
        this.departement = departament;
        this.group = group;
        this.tvaGroup = tvaGroup;
        this.quantity = quantity;
    }

    public ProductData() {
    }

    public void setPriceAsFloat(double price) {
        this.pret = price;
        String s = Utils.getString2DecimalsNoTrunc(price);
        this.setPrice(s);
    }

    public void setQuantityAsInt(int quantity) {
        this.setQuantityString(quantity + ".000");
    }

    public void setGroupAsInt(int group) {
        this.group = Integer.toString(group);
    }

    public void setTvaGroupAsInt(int tvaGroup) {
        this.tvaGroup = Integer.toString(tvaGroup);
    }

    public void setDepartamentAsInt(int departament) {
        this.departement = Integer.toString(departament);
    }

    public double getPret() {
        return this.pret;
    }

    public void setPret(double pret) {
        this.pret = pret;
    }

    public String toString() {
        return "Name : " + this.name + " price " + this.price + " quantity " + this.quantityString + " code " + this.productCode + " departament " + this.departement + " group " + this.group + " tvaGroup " + this.tvaGroup + " productId " + this.productId;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return this.name;
    }

    public void setName(String name) {
        int length;
        if (name != null && (length = name.length()) > 22) {
            name = name.substring(0, 22);
        }
        this.name = name;
    }

    public String getPrice() {
        return this.price;
    }

    public String getQuantityString() {
        return this.quantityString;
    }

    public String getDepartement() {
        return this.departement;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTvaGroup() {
        return this.tvaGroup;
    }

    public void setTvaGroup(String tvaGroup) {
        this.tvaGroup = tvaGroup;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setQuantityString(String quantityString) {
        this.quantityString = quantityString;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductData)) {
            return false;
        }
        ProductData p = (ProductData)obj;
        return p.getProductId() == this.getProductId();
    }

    public ProductData clone() {
        ProductData result = null;
        try {
            result = (ProductData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

