/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr_online_native.newecr.base.PortSettings;
import ro.atreides.utils.Logger;

public abstract class ECR {
    protected PortSettings portSettings = new PortSettings();
    protected SerialPort serialPort;
    protected InputStream input;
    protected OutputStream output;

    public ECR(String portName, int speed) throws PortInUseException, IOException, UnsupportedCommOperationException, NoSuchPortException {
        this.portSettings.setName(portName);
        this.portSettings.setSpeed(speed);
        this.initialize();
    }

    private void initialize() throws PortInUseException, IOException, UnsupportedCommOperationException, NoSuchPortException {
        String portName = this.portSettings.getName();
        Logger.logInfo(this, "requesting port: " + this.portSettings.getName() + ", speed = " + this.portSettings.getSpeed());
        if (portName == null) {
            throw new NullPointerException();
        }
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != this.portSettings.getPortType() || !portId.getName().equals(portName)) continue;
            Logger.logInfo(this, "Found port: " + portName);
            this.serialPort = (SerialPort)portId.open("CasaDeMarkatReader", 2000);
            this.serialPort.setRTS(this.portSettings.isRTS());
            this.input = this.serialPort.getInputStream();
            this.output = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(this.portSettings.getSpeed(), this.portSettings.getDataBits(), this.portSettings.getStopBits(), this.portSettings.getPariry());
            Logger.logInfo(this, "Initializare port corecta");
            return;
        }
        Logger.logError((Object)this, "port indisponibil");
        throw new NoSuchPortException();
    }

    public void start() {
        this.startThread(this.input, this.output, this.serialPort);
    }

    public void closeAll() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
        }
        this.input = null;
        try {
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
        }
        this.output = null;
        try {
            if (this.serialPort != null) {
                this.serialPort.close();
            }
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
        }
        this.serialPort = null;
    }

    public void stop() {
        this.closeAll();
    }

    protected abstract void startThread(InputStream var1, OutputStream var2, SerialPort var3);
}

