/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.MailUtils;
import ro.atreides.utils.ZipUtils;

public class Backup {
    public static void backupLogs() {
        try {
            Backup.mkBackupDir();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String getDate() {
        return Formatters.currentDateAndTimeForFileSystem.format(new Date());
    }

    private static void mkBackupDir() {
        new File("backup").mkdirs();
    }

    private static void mkBackupZip() throws IOException {
        ZipUtils.zipCreateRecursive("backup", "logs.zip");
        new File("logs.zip").deleteOnExit();
    }

    private static void deleteBackupZip() {
        new File("logs.zip").delete();
    }

    public static void sendLogs() {
        try {
            Backup.backupLogs();
            Backup.mkBackupZip();
            MailUtils.sendMailGoogleSMTP(Config.getGmailUsername(), Config.getGmailPassword(), "ecr_online_logs@atreides.ro", Config.getMailTo(), "loguri ecr_online", "", new String[]{"logs.zip"});
            Backup.deleteBackupZip();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.logError((Object)new Backup(), e);
        }
    }
}

