/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import ro.atreides.ecr_online_native.newecr.gui.Payment;
import ro.atreides.ecr_online_native.newecr.gui.Produs;
import ro.atreides.ecr_online_native.newecr.gui.XmlData;
import ro.atreides.ecr_online_native.newecr.online_event.PaymentType;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class Bon
implements XmlData,
Serializable {
    private Vector produse = new Vector();
    private Vector payments = new Vector();
    private double total = -1.0;
    private int nrBon = -1;
    private int nrZ = -1;
    private boolean closed;

    public double getValoareProduse() {
        double total = 0.0;
        for (int i = 0; i < this.produse.size(); ++i) {
            Produs produs = (Produs)this.produse.elementAt(i);
            total += produs.getValue();
        }
        return total;
    }

    public void addProdus(Produs produs) {
        if (produs != null) {
            this.produse.add(produs);
            Logger.logDebug(this, "ADAUG PRODUS: " + produs.toString());
        }
    }

    public boolean removeLastProduct() {
        if (this.produse.size() > 0) {
            this.produse.remove(this.produse.size() - 1);
            return true;
        }
        return false;
    }

    public void addPayment(PaymentType type, double currentTotal, double restPlata, double totalBon, int nrBon, int nrZ) {
        Object last;
        if (this.isClosed()) {
            return;
        }
        if (currentTotal >= restPlata) {
            this.closed = true;
        }
        Payment p = new Payment();
        p.setType(type);
        p.setCurrentTotal(currentTotal);
        p.setRest(restPlata);
        p.setTotalBon(totalBon);
        if (this.payments.size() > 0 && (last = this.payments.lastElement()).equals(p)) {
            return;
        }
        this.total = totalBon;
        this.nrBon = nrBon;
        this.nrZ = nrZ;
        this.payments.add(p);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String toXml() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<receipt").append(" total='").append(Utils.getString2DecimalsNoTrunc(this.total)).append("'").append(" nrReceipt='").append(this.nrBon).append("'").append(" nrZ='").append(this.nrZ).append("'").append(">");
        for (XmlData produs : this.produse) {
            buffer.append("\n\t").append(produs.toXml());
        }
        for (XmlData payment : this.payments) {
            buffer.append("\n\t").append(payment.toXml());
        }
        buffer.append("\n").append("</receipt>");
        return buffer.toString();
    }

    @Override
    public String toCSV() {
        StringBuffer buffer = new StringBuffer();
        String time = Formatters.ecrOnlineCSVFormat.format(new Date());
        String nrBon1 = Utils.getStringMaxSize(10, "" + this.nrBon, Character.valueOf(' '), true);
        String valCash = this.getVal(PaymentType.NUMERAR.getName());
        String valCard = this.getVal(PaymentType.CEC.getName());
        String valTicket = this.getVal(PaymentType.TICKET.getName());
        String prefix = time + ',' + nrBon1 + ',' + valCash + ',' + valCard + ',' + valTicket + ',';
        for (XmlData produs : this.produse) {
            buffer.append(prefix);
            buffer.append(produs.toCSV());
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private String getVal(String tipPlata2) {
        double value = 0.0;
        for (int i = 0; i < this.payments.size(); ++i) {
            Payment payment = (Payment)this.payments.elementAt(i);
            if (!payment.getType().getName().equalsIgnoreCase(tipPlata2)) continue;
            value += payment.getCurrentTotal();
        }
        return Utils.getStringMaxSize(15, Utils.getString2DecimalsNoTrunc(value), Character.valueOf(' '), true);
    }

    public Vector getProduse() {
        return this.produse;
    }

    public void addAll(Vector produse) {
        for (int i = 0; i < produse.size(); ++i) {
            Produs produs = (Produs)produse.elementAt(i);
            this.addProdus(produs);
        }
    }
}

