/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import purejavacomm.SerialPort;
import ro.atreides.ecr_online_native.newecr.ECR;
import ro.atreides.ecr_online_native.newecr.online.Constants;
import ro.atreides.ecr_online_native.newecr.online.Message;
import ro.atreides.ecr_online_native.newecr.online.Utils;
import ro.atreides.ecr_online_native.newecr.online_event.Listener;
import ro.atreides.ecr_online_native.newecr.online_event.MessageData;
import ro.atreides.ecr_online_native.newecr.online_event.ReaderImpl;
import ro.atreides.ecr_online_native.newecr.online_event.Wrapper;
import ro.atreides.ecr_online_native.newecr.online_event.Writer;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.Validators;

public class MP55Detector
extends ECR {
    private boolean running = true;
    private String seria;

    public MP55Detector(String portName, int speed) throws Exception {
        super(portName, speed);
        super.start();
    }

    @Override
    public synchronized void closeAll() {
        this.running = false;
        super.closeAll();
    }

    @Override
    protected void startThread(InputStream in, final OutputStream out, SerialPort port) {
        final Writer writer = new Writer(out);
        final ReaderImpl reader = new ReaderImpl(in, port);
        reader.setListener(new Listener(){
            private Writer writer;
            private Wrapper wrapper;
            {
                this.writer = new Writer(out);
                this.wrapper = new Wrapper();
            }

            @Override
            public void message(Message message) {
                this.writer.writetoport_NOFLUSH(Constants.ACK_MESSAGE);
                this.writer.flush();
                byte[] data = message.getData();
                MessageData mdata = this.wrapper.getMessageData(data, data.length);
                MP55Detector.this.seria = mdata.getSeria();
                MP55Detector.this.closeAll();
            }

            @Override
            public void ack() {
            }

            @Override
            public void nack() {
            }
        });
        new Thread(){

            @Override
            public void run() {
                2.yield();
                while (MP55Detector.this.running) {
                    writer.writetoport(Constants.TAKE_MESSAGE);
                    try {
                        reader.read(50);
                    }
                    catch (IOException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
            }
        }.start();
    }

    public String getSerial() {
        return this.seria;
    }

    public boolean detect() {
        long start = System.currentTimeMillis();
        long delay = 2000L;
        while (System.currentTimeMillis() - start <= delay && this.running) {
            Utils.sleep(10);
        }
        this.closeAll();
        return Validators.correctString(this.seria);
    }
}

