/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import ro.atreides.ecr_online_native.newecr.gui.XmlData;
import ro.atreides.utils.Utils;

public class Produs
implements XmlData {
    private String code;
    private double price;
    private double quantity;
    private String name;
    private double value;

    public void compute() {
        this.value = this.price * this.quantity;
    }

    public double getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
        this.compute();
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
        this.compute();
    }

    @Override
    public String toXml() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<product");
        buffer.append(" code='").append(this.code).append("'");
        buffer.append(" price='").append(Utils.getString2DecimalsNoTrunc(this.price)).append("'");
        buffer.append(" quantity='").append(Utils.getString3DecimalsNoTrunc(this.quantity)).append("'");
        buffer.append("/>");
        return buffer.toString();
    }

    @Override
    public String toCSV() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Utils.getStringMaxSize(40, this.name, Character.valueOf(' '), true));
        buffer.append(',');
        buffer.append(Utils.getStringMaxSize(13, this.code, Character.valueOf(' '), true));
        buffer.append(',');
        buffer.append(Utils.getStringMaxSize(15, Utils.getString2DecimalsNoTrunc(this.price), Character.valueOf(' '), true));
        buffer.append(',');
        buffer.append(Utils.getStringMaxSize(10, Utils.getString3DecimalsNoTrunc(this.quantity), Character.valueOf(' '), true));
        buffer.append(',');
        return buffer.toString();
    }

    public String toString() {
        String result = "Product code: " + this.code + " price: " + Utils.getString2DecimalsNoTrunc(this.price) + " quantity: " + Utils.getString3DecimalsNoTrunc(this.quantity);
        return result;
    }
}

