/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import jxl.read.biff.BiffException;
import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.ecr_online_native.newecr.gui.Backup;
import ro.atreides.ecr_online_native.newecr.gui.Config;
import ro.atreides.ecr_online_native.newecr.gui.License;
import ro.atreides.ecr_online_native.newecr.gui.LicenseView;
import ro.atreides.ecr_online_native.newecr.gui.PasswordManager;
import ro.atreides.ecr_online_native.newecr.gui.Products;
import ro.atreides.ecr_online_native.newecr.gui.SimpleListPanel;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;

public class SetariPanel
extends JPanel {
    private JTextField fieldRoot;

    public SetariPanel() {
        this.init();
        this.display();
    }

    private void init() {
        this.fieldRoot = new JTextField();
        this.fieldRoot.setEditable(false);
        this.fieldRoot.setBackground(Color.WHITE);
        this.refreshRoot();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(3, 3, 3, 3);
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        this.add((Component)this.buildRootPanel(), c);
        ++c.gridy;
        this.add((Component)this.buildLogsPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)this.buildLicentePanel(), c);
    }

    private JPanel buildRootPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Files"));
        JButton schimbaRoot = new JButton("Change");
        schimbaRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setFileSelectionMode(1);
                File vanzari = new File(Config.getVanzariDir());
                vanzari.mkdirs();
                fileChooser.setCurrentDirectory(vanzari);
                int retValue = fileChooser.showOpenDialog(SetariPanel.this);
                if (retValue == 0) {
                    File f = fileChooser.getSelectedFile();
                    Config.setVanzariDir(f);
                    SetariPanel.this.refreshRoot();
                    Products.getInstance().reload();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 21;
        result.add((Component)new JLabel("Sells"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 10;
        result.add((Component)this.fieldRoot, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        result.add((Component)schimbaRoot, c);
        return result;
    }

    private void refreshRoot() {
        this.fieldRoot.setText(new File(Config.getVanzariDir()).getAbsolutePath());
        this.fieldRoot.setToolTipText(this.fieldRoot.getText());
    }

    public JPanel buildLogsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder("Logs"));
        JButton send = new JButton("Send Logs");
        send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Backup.sendLogs();
                }
                catch (Throwable e1) {
                    Logger.logError((Object)SetariPanel.this, e1);
                    DialogUtils.okDialog(SetariPanel.this.getFrame(), "Error sending mail!", "");
                }
            }
        });
        JTextField server = new JTextField(5);
        server.setEditable(false);
        server.setText(Config.getMailServer());
        JTextField email = new JTextField(5);
        email.setEditable(false);
        email.setText(Config.getMailTo());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("server:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)server, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("email:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)email, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)send, c);
        return result;
    }

    private JPanel buildLicentePanel() {
        SimpleListPanel panel = new SimpleListPanel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                LicenseView view = (LicenseView)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return view.getSeria();
                    }
                    case 1: {
                        return view.getLicense();
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public String[] buildColumns() {
                return new String[]{"Serial", "License"};
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class, String.class};
            }

            @Override
            public Vector buildData() {
                return Config.getLicenses();
            }

            @Override
            public JPanel buildBottomPanel() {
                final 3 parent = this;
                JButton incarcaProduse = new JButton("Load products");
                incarcaProduse.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String inputFile;
                        final String xml = FileUtils.getCurrentDir() + File.separator + "products.xml";
                        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Produsele vor fi inlocuite. Continuam", "Confirmare") && (inputFile = FileDialog.getLoadDialogLocation(parent, "Selectati fisierul de produse", "xls")) != null) {
                            final Vector products = new Vector();
                            try {
                                ExcelUtils.readExcel(new File(inputFile), new ExcelImportInterface(){
                                    String productName = "";
                                    String codBare = "";
                                    double pret = 0.0;
                                    int cotaTva = 0;
                                    int departament = 0;
                                    int grupa = 0;
                                    boolean completed = false;
                                    int currentLine = 2;

                                    @Override
                                    public void lineEnd() {
                                        if (!this.completed) {
                                            Logger.logDebug(this, "Line: " + this.currentLine + " eronata.");
                                        } else {
                                            ProductData produs = new ProductData();
                                            produs.setProductCode(this.codBare);
                                            produs.setName(this.productName);
                                            produs.setPriceAsFloat(this.pret);
                                            produs.setQuantityAsInt(1000);
                                            produs.setDepartamentAsInt(this.departament);
                                            produs.setGroupAsInt(this.grupa);
                                            produs.setTvaGroupAsInt(this.cotaTva);
                                            products.add(produs);
                                        }
                                        ++this.currentLine;
                                    }

                                    @Override
                                    public void valueRead(int row, int column, String value) {
                                        switch (column) {
                                            case 0: {
                                                this.productName = value;
                                                break;
                                            }
                                            case 1: {
                                                this.codBare = value;
                                                break;
                                            }
                                            case 2: {
                                                if (!Validators.correctDouble(value)) {
                                                    this.completed = false;
                                                    break;
                                                }
                                                this.pret = Utils.parseDouble(value);
                                                break;
                                            }
                                            case 3: {
                                                if (!Validators.correctDouble(value)) {
                                                    this.completed = false;
                                                    break;
                                                }
                                                this.cotaTva = Integer.parseInt(value);
                                                break;
                                            }
                                            case 4: {
                                                if (!Validators.correctDouble(value)) {
                                                    this.completed = false;
                                                    break;
                                                }
                                                this.departament = Integer.parseInt(value);
                                                break;
                                            }
                                            case 5: {
                                                if (!Validators.correctDouble(value)) {
                                                    this.completed = false;
                                                    break;
                                                }
                                                this.grupa = Integer.parseInt(value);
                                            }
                                        }
                                    }

                                    @Override
                                    public void lineStart() {
                                        this.productName = "";
                                        this.codBare = "";
                                        this.pret = 0.0;
                                        this.cotaTva = 0;
                                        this.departament = 0;
                                        this.grupa = 0;
                                        this.completed = true;
                                    }

                                    @Override
                                    public void sheetEnd(String sheetName) {
                                        StringBuffer buf = new StringBuffer();
                                        buf.append("<products>\n");
                                        for (int i = 0; i < products.size(); ++i) {
                                            ProductData productData = (ProductData)products.elementAt(i);
                                            buf.append("<product ");
                                            buf.append("code=\"" + TextUtils.escapeForXML(productData.getProductCode()) + "\" ");
                                            buf.append("name=\"" + TextUtils.escapeForXML(productData.getProductName()) + "\" ");
                                            buf.append("price=\"" + Utils.getString2Decimals(productData.getPret()) + "\" ");
                                            buf.append("department=\"" + productData.getDepartement() + "\" ");
                                            buf.append("group=\"" + productData.getGroup() + "\" ");
                                            buf.append("tvagroup=\"" + productData.getTvaGroup() + "\" ");
                                            buf.append("/>\n");
                                        }
                                        buf.append("</products>\n");
                                        try {
                                            FileUtils.writeTextToFile(xml, buf.toString());
                                        }
                                        catch (IOException e) {
                                            Logger.logException(this, (Exception)e);
                                        }
                                    }

                                    @Override
                                    public void sheetStart(String sheetName) {
                                    }
                                });
                            }
                            catch (IOException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            catch (BiffException e) {
                                Logger.logException(this, (Exception)((Object)e));
                            }
                            DialogUtils.okDialog(parent, "Fisierul de produse a fost salvat la : " + xml, "Operatie efectuata");
                        }
                    }
                });
                JButton add = new JButton("Add license");
                add.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String serial = DialogUtils.inputDialog(SetariPanel.this.getFrame(), "", "Enter ECR Serial number:");
                        if (serial == null) {
                            return;
                        }
                        if (!Validators.correctInteger(serial) || serial.length() != 6) {
                            DialogUtils.errorDialog(SetariPanel.this.getFrame(), "Serial number is incorrect!", "");
                            return;
                        }
                        String license = DialogUtils.inputDialog(SetariPanel.this.getFrame(), Config.getLicenseFor(serial), "Enter License:");
                        if (!License.isLicensed(license, serial)) {
                            DialogUtils.errorDialog(SetariPanel.this.getFrame(), "License incorrect!", "");
                            return;
                        }
                        Config.setLicenseFor(serial, license);
                        this.refreshTable();
                        License.getInstance().reload();
                    }
                });
                JPanel panel = new JPanel();
                panel.add(incarcaProduse);
                panel.add(add);
                return panel;
            }

            @Override
            public JPopupMenu getPopup(Object o) {
                return null;
            }

            @Override
            public void doubleClick(Object o) {
                LicenseView view = (LicenseView)o;
                if (PasswordManager.getInstance().hasPermission(SetariPanel.this.getFrame())) {
                    Config.setLicenseFor(view.getSeria(), "");
                    this.refreshTable();
                }
            }
        };
        panel.setBorder(new TitledBorder("Licenses"));
        return panel;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getRoot(this);
    }
}

