/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.gui;

import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.ecr_online_native.database.TransfersInterface;
import ro.atreides.ecr_online_native.newecr.gui.Bon;
import ro.atreides.ecr_online_native.newecr.gui.Products;
import ro.atreides.ecr_online_native.newecr.gui.Produs;
import ro.atreides.ecr_online_native.newecr.gui.Vanzari;
import ro.atreides.ecr_online_native.newecr.online_event.PaymentType;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class TransfersImplGui
extends TransfersInterface {
    private Vanzari vanzari = new Vanzari();
    private Bon lastBon;
    private Bon produseTemporare;
    private int lastNrBon = 0;
    private int lastZ = 0;

    @Override
    public void sellProduct(String code, double cantitate) {
    }

    @Override
    public void totalTICHET(double total, double restPlata) {
    }

    @Override
    public void totalCEC(double total, double restPlata) {
    }

    @Override
    public void totalEUR(double total, double restPlata) {
    }

    @Override
    public void totalNUMERAR(double total, double restPlata) {
    }

    @Override
    public void removeProduct(String code) {
    }

    @Override
    public ProductData getProductData(String code, double cantitate, String serieCasa) {
        ProductData result = Products.getInstance().getProductForCode(code, serieCasa);
        return result;
    }

    @Override
    public void sellProduct(String code, double cantitate, double price, String serieCasa) {
        Produs produs = new Produs();
        String name = "";
        ProductData pd = Products.getInstance().getProductForCode(code, serieCasa);
        if (pd != null) {
            name = pd.getProductName();
        }
        produs.setName(name);
        produs.setCode(code);
        produs.setQuantity(cantitate);
        produs.setPrice(price);
        if (this.lastBon == null) {
            this.lastBon = new Bon();
        }
        this.lastBon.addProdus(produs);
        Logger.logDebug(this, "VALOARE PRODUSE BON CURENT: " + Utils.getString2Decimals(this.lastBon.getValoareProduse()));
    }

    @Override
    public void productSentToEcr(String code, double cantitate, double price, String serieCasa) {
        Produs produs = new Produs();
        String name = "";
        ProductData pd = Products.getInstance().getProductForCode(code, serieCasa);
        if (pd != null) {
            name = pd.getProductName();
        }
        produs.setName(name);
        produs.setCode(code);
        produs.setQuantity(cantitate);
        produs.setPrice(price);
        if (this.produseTemporare == null) {
            this.produseTemporare = new Bon();
        }
        this.produseTemporare.addProdus(produs);
        Logger.logDebug(this, "VALOARE PRODUSE TEMPORARE: " + Utils.getString2Decimals(this.produseTemporare.getValoareProduse()));
    }

    @Override
    public void removeLastTempProduct() {
        if (this.produseTemporare != null) {
            boolean somethingDone = this.produseTemporare.removeLastProduct();
            if (somethingDone) {
                Logger.logDebug(this, "STERS ULTIMUL PRODUS TEMPORAR");
            } else {
                Logger.logDebug(this, "PRODUS TEMPORAR INEXISTENT - NU AM CE STERGE");
            }
        }
        Logger.logDebug(this, "VALOARE PRODUSE TEMPORARE: " + Utils.getString2Decimals(this.produseTemporare.getValoareProduse()));
    }

    @Override
    public void total(PaymentType type, double currentTotal, double restPlata, double totalBon, int nrBon, int nrZ, String serieCasa) {
        if (this.lastNrBon == nrBon && this.lastZ == nrZ) {
            return;
        }
        if (this.lastBon == null) {
            this.lastBon = new Bon();
        }
        this.lastBon.addPayment(type, currentTotal, restPlata, totalBon, nrBon, nrZ);
        if (this.lastBon.isClosed()) {
            this.lastNrBon = nrBon;
            this.lastZ = nrZ;
            double totalVz = this.lastBon.getValoareProduse();
            if (totalBon > totalVz) {
                Logger.logWarning(this, "EROARE TOTAL: valoare produse : " + Utils.getString2Decimals(totalVz) + ", total bon : " + Utils.getString2Decimals(totalBon));
                Logger.logWarning(this, "ADAUGAM PRODUSELE TEMPORARE in valoare de : " + Utils.getString2Decimals(this.produseTemporare.getValoareProduse()));
                this.lastBon.addAll(this.produseTemporare.getProduse());
            }
            this.vanzari.save(this.lastBon, serieCasa, nrBon, nrZ);
            this.vanzari.saveCSV(this.lastBon, serieCasa, nrBon, nrZ);
            this.lastBon = null;
            this.produseTemporare = null;
        }
    }
}

