/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.online;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import purejavacomm.CommPortIdentifier;
import ro.atreides.ecr_online_native.newecr.gui.Casa;
import ro.atreides.ecr_online_native.newecr.gui.MP55Detector;
import ro.atreides.utils.gui.GenericDialog;

public class Utils {
    public static final Integer[] speeds = new Integer[]{4800, 9600};
    public static final String CONFIG_FILE = "config.txt";

    public static void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Vector getPorts() {
        TreeSet<String> treeset = new TreeSet<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            treeset.add(portId.getName());
        }
        return new Vector(treeset);
    }

    public static Vector getCase() {
        Vector<Casa> result = new Vector<Casa>();
        Vector ports = Utils.getPorts();
        for (String port : ports) {
            for (int i = 0; i < speeds.length; ++i) {
                Integer integer = speeds[i];
                Casa casa = new Casa();
                casa.setPort(port);
                casa.setSpeed(integer);
                result.add(casa);
            }
        }
        return result;
    }

    public static Vector detect() {
        Vector<Casa> result = new Vector<Casa>();
        block2: for (String port : Utils.getPorts()) {
            for (int i = 0; i < speeds.length; ++i) {
                Integer speed = speeds[i];
                MP55Detector detector = null;
                try {
                    System.out.println("detect(): port = " + port + ", speed = " + speed);
                    detector = new MP55Detector(port, speed);
                    boolean detected = detector.detect();
                    if (!detected) continue;
                    String seria = detector.getSerial();
                    Casa casa = new Casa();
                    casa.setPort(port);
                    casa.setSpeed(speed);
                    casa.setSeria(seria);
                    result.add(casa);
                    continue block2;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static Vector detect(Component parent) {
        final Vector result = new Vector();
        final JDialog dialog = Utils.getDialog("<html><font size=4>Detecting, please wait...</font></html>", (JFrame)SwingUtilities.getRoot(parent));
        new Thread(){

            @Override
            public void run() {
                1.yield();
                result.addAll(Utils.detect());
                dialog.setVisible(false);
            }
        }.start();
        dialog.setVisible(true);
        return result;
    }

    public static String load(String key, String filename) {
        String result = "";
        try {
            Properties conf = Utils.loadConfiguration(filename);
            result = conf.getProperty(key, "");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String load(String key) {
        return Utils.load(key, CONFIG_FILE);
    }

    public static int loadAsInt(String key) {
        int result = 0;
        String value = Utils.load(key);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static void save(String key, String value, String filename) {
        try {
            Properties conf = Utils.loadConfiguration(filename);
            if (key != null && value != null) {
                conf.setProperty(key, value);
                Utils.saveConfiguration(filename, conf);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void save(String key, String value) {
        Utils.save(key, value, CONFIG_FILE);
    }

    public static Properties loadConfiguration(String configFileName) {
        Properties conf = new Properties();
        try {
            conf.load(new FileInputStream(configFileName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return conf;
    }

    private static void saveConfiguration(String configFileName, Properties property) {
        try {
            property.store(new FileOutputStream(configFileName), "ECR ONLINE PROPERTIES");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static JDialog getDialog(String text, JFrame frame) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(text));
        JDialog dialog = GenericDialog.getDialog(true, new JLabel(text), frame, "");
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }
}

