/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.online_event;

import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.ecr_online_native.database.TransfersInterface;
import ro.atreides.ecr_online_native.newecr.online.Constants;
import ro.atreides.ecr_online_native.newecr.online.Message;
import ro.atreides.ecr_online_native.newecr.online_event.CodeTypes;
import ro.atreides.ecr_online_native.newecr.online_event.Listener;
import ro.atreides.ecr_online_native.newecr.online_event.MessageData;
import ro.atreides.ecr_online_native.newecr.online_event.Wrapper;
import ro.atreides.ecr_online_native.newecr.online_event.Writer;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public abstract class ListenerImpl
implements Listener {
    public static final int WAITING_FOR_ACK = 0;
    public static final int WAITING_FOR_CONFIRMATION = 1;
    public static final int IDLE = 2;
    private int state = 2;
    private ProductData NULL_PRODUCT;
    long start = System.currentTimeMillis();
    private Wrapper wrapper = new Wrapper();
    private Writer writer;
    private MessageData lastMessage;

    public ListenerImpl(Writer writer) {
        this.writer = writer;
        this.NULL_PRODUCT = new ProductData("", "Produs Inexistent", "0.00", "1000", "1", "1", "1", 1.0);
    }

    @Override
    public void message(Message message) {
        this.writer.writetoport_NOFLUSH(Constants.ACK_MESSAGE);
        byte[] data = message.getData();
        Logger.logDebug(this, "Receptionat : " + new String(data));
        MessageData mdata = this.wrapper.getMessageData(data, data.length);
        this.arrivedSerial(mdata.getSeria());
        if (mdata.getType() == CodeTypes.TYPE_A) {
            Logger.logDebugVerbose(this, "data :" + mdata + "\tstate = " + this.state);
        } else {
            Logger.logDebug(this, "data :" + mdata + "\tstate = " + this.state);
        }
        if (this.state == 1) {
            switch (mdata.getType()) {
                case TYPE_A: {
                    this.sellProduct(this.lastMessage);
                    break;
                }
                case TYPE_B: {
                    break;
                }
                default: {
                    this.sellProduct(this.lastMessage);
                }
            }
            this.state = 2;
        }
        switch (mdata.getType()) {
            case TYPE_1: {
                this.message_type_1(mdata);
                break;
            }
            case TYPE_7: {
                this.message_type_7(mdata);
                break;
            }
            case TYPE_3: {
                this.message_type_3(mdata);
                break;
            }
            case TYPE_A: {
                this.message_type_A(mdata);
                break;
            }
            default: {
                this.state = 2;
            }
        }
        this.writer.flush();
    }

    private void message_type_1(MessageData mdata) {
        this.lastMessage = mdata;
        switch (this.state) {
            case 2: {
                this.start = System.currentTimeMillis();
                ProductData productData = this.getProductData(mdata);
                if (productData == null) {
                    Logger.logWarning(this, "produs negasit pt codul " + mdata.getCode());
                    productData = this.NULL_PRODUCT;
                    productData.setProductCode(mdata.getCode());
                }
                mdata.setPrice(productData.getPrice());
                byte[] m = this.getMessageForProduct(productData);
                Logger.logDebug(this, "writing to ECR: " + productData);
                this.writer.writetoport(m);
                this.state = 0;
                this.transfers().productSentToEcr(mdata.getCode(), mdata.getQuantity(), productData.getPret(), mdata.getSeria());
                break;
            }
            case 0: {
                this.state = 2;
                this.message_type_1(mdata);
                break;
            }
        }
    }

    private void message_type_7(MessageData mdata) {
        this.message_type_1(mdata);
    }

    private void message_type_3(MessageData mdata) {
        this.total(mdata);
        this.state = 2;
    }

    private void message_type_A(MessageData mdata) {
        switch (this.state) {
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.state = 2;
            }
        }
    }

    @Override
    public void ack() {
        if (this.state == 0) {
            this.state = 1;
        }
        this.transfers().removeLastTempProduct();
    }

    @Override
    public void nack() {
        this.state = 2;
        this.transfers().removeLastTempProduct();
    }

    private ProductData getProductData(MessageData data) {
        try {
            ProductData product = this.transfers().getProductData(data.getCode(), data.getQuantity(), data.getSeria());
            return product;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void sellProduct(MessageData data) {
        Logger.logDebug(this, "ITEM SELLED: " + data);
        try {
            this.transfers().notifySell(data.getCode(), data.getQuantity(), Utils.parseDouble(data.getPrice()), data.getSeria());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void total(MessageData data) {
        Logger.logDebug(this, "TOTAL = " + (Object)((Object)data.getType()) + ", " + data.getCurrentTotal());
        try {
            this.transfers().notifyTotal(data.getPaymentType(), data.getCurrentTotal(), data.getRestDePlata(), data.getTotalBon(), data.getNrBon(), data.getNrZ(), data.getSeria());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public byte[] getMessageForProduct(ProductData productData) {
        String partial = this.wrapper.getPartialMessage(productData.getProductName(), productData.getPrice(), productData.getQuantityString(), productData.getDepartement(), productData.getGroup(), productData.getTvaGroup());
        return this.wrapper.constructMessage(partial);
    }

    public abstract TransfersInterface transfers();

    public abstract void arrivedSerial(String var1);
}

