/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr_online_native.newecr.online_event;

import java.io.IOException;
import java.io.InputStream;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr_online_native.newecr.ecr_constants.EventType;
import ro.atreides.ecr_online_native.newecr.online.Message;
import ro.atreides.ecr_online_native.newecr.online_event.Reader;
import ro.atreides.utils.Logger;

public class ReaderImpl
extends Reader {
    public static final int IDLE = 0;
    public static final int SEARCHING_FOR_END = 1;
    public static final int SEARCHING_FOR_FIRST_CRC_BYTE = 2;
    public static final int SEARCHING_FOR_SECOND_CRC_BYTE = 3;
    private int state = 0;

    public ReaderImpl(InputStream input, SerialPort port) {
        super(input, port);
    }

    @Override
    protected void dataArrived(byte[] buffer, int offset, int len) {
        byte[] rawData = new byte[len];
        System.arraycopy(buffer, offset, rawData, 0, len);
        int i = 0;
        while (i < len) {
            switch (this.state) {
                case 0: {
                    byte b;
                    this.currentPosition = 0;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 6) {
                            this.fireEvent(EventType.ACK_READ, rawData);
                            break;
                        }
                        if (b == 21) {
                            this.fireEvent(EventType.NACK_READ, rawData);
                            break;
                        }
                        if (b == 10) {
                            this.state = 1;
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    byte b;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 13) {
                            this.state = 2;
                            this.currentMessage[this.currentPosition] = 13;
                            ++this.currentPosition;
                            break;
                        }
                        this.currentMessage[this.currentPosition] = b;
                        ++this.currentPosition;
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 2: {
                    this.currentMessage[this.currentPosition] = buffer[i];
                    ++this.currentPosition;
                    this.state = 3;
                    ++i;
                    break;
                }
                case 3: {
                    this.currentMessage[this.currentPosition] = buffer[i];
                    ++this.currentPosition;
                    this.state = 0;
                    short crc = this.crcCalculator.crcFast(this.currentMessage, this.currentPosition - 2);
                    short crcInMessage = (short)(this.currentMessage[this.currentPosition - 2] << 8 & 0xFF00 | this.currentMessage[this.currentPosition - 1] & 0xFF);
                    if (crc == crcInMessage) {
                        this.fireEvent(EventType.MESSAGE_OK, rawData);
                        return;
                    }
                    this.fireEvent(EventType.MESSAGE_ERROR, rawData);
                    return;
                }
            }
        }
    }

    protected void fireEvent(EventType event, byte[] rawMessage) {
        try {
            switch (event) {
                case ACK_READ: {
                    Logger.logDebug(this, "reading ACK from ECR");
                    Logger.logDebugVerbose(this, "FIRE EVENT : Raw Data : " + new String(rawMessage));
                    this.listener.ack();
                    break;
                }
                case NACK_READ: {
                    Logger.logWarning(this, "reading NACK from ECR");
                    Logger.logDebugVerbose(this, "FIRE EVENT : Raw Data : " + new String(rawMessage));
                    this.listener.nack();
                    break;
                }
                case MESSAGE_ERROR: {
                    Logger.logWarning(this, "crc error");
                    break;
                }
                case MESSAGE_OK: {
                    byte[] tmp = new byte[this.currentPosition - 3];
                    System.arraycopy(this.currentMessage, 0, tmp, 0, this.currentPosition - 3);
                    Message m = new Message(tmp);
                    Logger.logDebugVerbose(this, "reading message from ECR: " + m);
                    Logger.logDebugVerbose(this, "FIRE EVENT : Raw Data : " + new String(rawMessage));
                    this.listener.message(m);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void read(int timeout) throws IOException {
        try {
            this.port.enableReceiveTimeout(timeout);
            int n = this.input.read(this.buffer);
            this.dataArrived(this.buffer, 0, n);
            if (n != -1) {
                this.port.enableReceiveTimeout(10);
                while (this.state != 0) {
                    n = this.input.read(this.buffer);
                    this.dataArrived(this.buffer, 0, n);
                }
            }
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
    }
}

