/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecronline.datecs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.BonFiscalItem;
import ro.atreides.ecronline.BonFiscalPlata;
import ro.atreides.ecronline.EcrOnlineInterface;
import ro.atreides.ecronline.PluFilePrinter;
import ro.atreides.ecronline.PluItem;
import ro.atreides.ecronline.db.EcrOnlineDao;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class RandomAccessDatecsEcrOnline
extends Thread
implements PluFilePrinter {
    private int nrCasaMarcat;
    private EcrOnlineInterface inter;
    private boolean codBare;
    private ConnectionPool pool = ConnectionPool.getInstance();
    private String decimalCharacter = "3";
    private String cotaTva = "1";
    private boolean windowsMachine = false;
    private RandomAccessFile bonRaf;
    private RandomAccessFile itemsRaf;
    private String bonRegexp;
    private String itemRegexp;

    public RandomAccessDatecsEcrOnline(EcrOnlineInterface inter, int nrCasaMarcat, boolean codBare) throws SQLException {
        this.inter = inter;
        this.nrCasaMarcat = nrCasaMarcat;
        this.codBare = codBare;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream("conf/online.properties"));
            this.decimalCharacter = props.getProperty("decimal", "3");
            this.cotaTva = props.getProperty("cotaTva", "1");
            this.windowsMachine = Boolean.parseBoolean(props.getProperty("windowsMachine", "true"));
        }
        catch (NumberFormatException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void seekAfterBon(long startSeek, String nrZ, String nrBon) throws IOException {
        String line;
        this.bonRaf.seek(startSeek);
        long pointer = startSeek;
        boolean found = true;
        while ((line = this.bonRaf.readLine()) != null) {
            if (!line.matches(this.bonRegexp)) continue;
            String currentZ = line.substring(70, 75);
            String currentBon = line.substring(8, 12);
            if (currentZ.equalsIgnoreCase(nrZ) && currentBon.equalsIgnoreCase(nrBon)) {
                pointer = this.bonRaf.getFilePointer();
                found = true;
                continue;
            }
            if (!found) continue;
            this.bonRaf.seek(pointer);
            break;
        }
    }

    private void seekItems(long startSeek, String nrZ, String nrBon) throws IOException {
        String line;
        this.itemsRaf.seek(startSeek);
        long pointer = startSeek;
        boolean found = true;
        while ((line = this.itemsRaf.readLine()) != null) {
            if (!line.matches(this.itemRegexp)) continue;
            String currentZ = line.substring(96, 101);
            String currentBon = line.substring(8, 12);
            if (currentZ.equalsIgnoreCase(nrZ) && currentBon.equalsIgnoreCase(nrBon)) {
                pointer = this.itemsRaf.getFilePointer();
                found = true;
                continue;
            }
            if (!found) continue;
            this.itemsRaf.seek(pointer);
            break;
        }
    }

    @Override
    public void run() {
        try {
            this.openBonFile();
            this.openItemsFile();
            String maxKey = this.getDao().getMaxBon();
            String maxZ = null;
            String maxBon = null;
            if (maxKey != null) {
                Vector items = Utils.splitString(maxKey, '_');
                maxZ = (String)items.get(0);
                maxBon = (String)items.get(1);
            }
            long seek = 0L;
            if (maxZ != null && maxBon != null) {
                this.seekAfterBon(seek, maxZ, maxBon);
            }
            while (true) {
                BonFiscal bf;
                if ((bf = this.readBonFiscal()) != null) {
                    Collection items = this.getBonItems(bf);
                    bf.setItems(items);
                    if (!this.getDao().isBonEntered(bf.getKey())) {
                        this.inter.readBon(bf);
                        this.getDao().addBon(bf.getKey());
                        this.pool.requestConnection().commitTransaction();
                        this.pool.releaseConnection();
                        Logger.logDebug(this, "Am procesat: " + bf.toString());
                        continue;
                    }
                    Logger.logDebug(this, "Bon deja procesat: " + bf.toString());
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private synchronized EcrOnlineDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        EcrOnlineDao dao = null;
        while (dao == null) {
            dao = (EcrOnlineDao)this.pool.getDao(EcrOnlineDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(EcrOnlineDao.class.getName(), connection);
        }
        return dao;
    }

    private String getBonItemsFile() {
        return "TRAN_ECR" + this.nrCasaMarcat + ".DAT";
    }

    protected String getBonFile() {
        return "BON_ECR" + this.nrCasaMarcat + ".DAT";
    }

    protected Collection getBonItems(BonFiscal bf) throws IOException {
        Vector<BonFiscalItem> result = new Vector<BonFiscalItem>();
        long pos = this.itemsRaf.getFilePointer();
        String line = this.itemsRaf.readLine();
        while (line != null) {
            String origKey;
            BonFiscalItem bfi;
            String currentKey;
            int status;
            if (line.matches(this.itemRegexp) && (status = (currentKey = (bfi = this.getItem(line)).getKey()).compareTo(origKey = bf.getKey())) >= 0) {
                if (status > 0) {
                    this.itemsRaf.seek(pos);
                    break;
                }
                result.add(bfi);
            }
            pos = this.itemsRaf.getFilePointer();
            line = this.itemsRaf.readLine();
        }
        return result;
    }

    private BonFiscal readBonFiscal() throws IOException {
        String line = this.bonRaf.readLine();
        BonFiscal bf = null;
        if (line != null && line.matches(this.bonRegexp)) {
            bf = this.getBonFiscal(line);
            Vector<BonFiscalPlata> plati = new Vector<BonFiscalPlata>();
            BonFiscalPlata plata = new BonFiscalPlata();
            plata.setSuma(bf.getSumaPlatita());
            plata.setTipPlata(bf.getTipPlata());
            plati.add(plata);
            long pos = this.bonRaf.getFilePointer();
            line = this.bonRaf.readLine();
            while (line != null) {
                if (!line.matches(this.bonRegexp)) continue;
                BonFiscal item = this.getBonFiscal(line);
                if (item.getKey().equalsIgnoreCase(bf.getKey())) {
                    plata = new BonFiscalPlata();
                    plata.setSuma(item.getSumaPlatita());
                    plata.setTipPlata(item.getTipPlata());
                    plati.add(plata);
                    line = this.bonRaf.readLine();
                    continue;
                }
                this.bonRaf.seek(pos);
                break;
            }
            bf.setPlati(plati);
        }
        return bf;
    }

    private BonFiscal getBonFiscal(String line) {
        BonFiscal bf = new BonFiscal();
        try {
            StringTokenizer token = new StringTokenizer(line, ",");
            String nrCasa = token.nextToken();
            String nrOper = token.nextToken();
            String numarBon = token.nextToken();
            String tipPlata2 = token.nextToken();
            String rest = token.nextToken();
            String suma = token.nextToken();
            String platit = token.nextToken();
            String nrZecimale = token.nextToken();
            int nr = Integer.parseInt(nrZecimale);
            double sumaPlatita = Utils.parseDouble(platit) / Math.pow(10.0, nr - 1);
            String nrCard = token.nextToken();
            String ora = token.nextToken();
            String data = token.nextToken();
            String numarZ = token.nextToken();
            bf.setNumarBon(numarBon);
            bf.setNumarZ(numarZ);
            TipPlata tp = TipPlataProvider.getInstance().getTipPlataByCodCasa(tipPlata2);
            if (tp != null) {
                bf.setTipPlata(tp.getId());
            } else {
                bf.setTipPlata(-1);
            }
            bf.setSumaPlatita(sumaPlatita);
            Date d = DateUtils.getDate(data + "-" + ora, Formatters.ecrOnlineFormat);
            bf.setDataBon(d.getTime());
            bf.setKey();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            Logger.logDebug(this, e.getMessage());
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            Logger.logDebug(this, e.getMessage());
        }
        return bf;
    }

    private BonFiscalItem getItem(String line) {
        StringTokenizer token = new StringTokenizer(line, ",");
        token.nextToken();
        token.nextToken();
        String numarBon = token.nextToken();
        String cod = token.nextToken();
        String ppu = token.nextToken();
        token.nextToken();
        String cantitate = token.nextToken();
        token.nextToken();
        token.nextToken();
        token.nextToken();
        String numarZ = token.nextToken();
        BonFiscalItem bfi = new BonFiscalItem();
        if (cod.equals("9999999999999")) {
            bfi.setQuantity(Utils.parseDouble(ppu));
            if (this.codBare) {
                bfi.setCodBare("0000000000000");
            } else {
                bfi.setCod(0);
            }
        } else {
            bfi.setQuantity(Utils.parseDouble(cantitate) / 1000.0);
            if (this.codBare) {
                bfi.setCodBare(cod);
            } else {
                bfi.setCod(Integer.valueOf(cod));
            }
        }
        bfi.setNumarBon(numarBon);
        bfi.setNumarZ(numarZ);
        bfi.setKey();
        return bfi;
    }

    private void openItemsFile() throws IOException {
        this.itemsRaf = new RandomAccessFile(this.getBonItemsFile(), "r");
    }

    private void openBonFile() throws IOException {
        this.bonRaf = new RandomAccessFile(this.getBonFile(), "r");
    }

    @Override
    public String printPLU(Vector items) {
        try {
            File f = new File("PLU.DAT");
            FileWriter wr = new FileWriter(f);
            for (PluItem product : items) {
                String c = "";
                c = this.codBare ? c + product.getCodBare() : c + product.getCod();
                String cod = Utils.getStringMaxSize(13, c, new Character('0'), true);
                String cat = product.getIdSectie() + "";
                String cat1 = Utils.getStringMaxSize(2, cat, new Character('0'), true);
                int price = (int)(product.getPrice() * 100.0);
                String pret = Utils.getStringMaxSize(8, price + "", new Character('0'), true);
                String name = Utils.getStringMaxSize(40, product.getProductName(), new Character(' '), false);
                name = name.replace(',', ' ');
                String line = cod + "," + cat1 + "," + this.cotaTva + "," + pret + "," + this.decimalCharacter + "," + name;
                if (this.windowsMachine) {
                    line = line + "\r";
                }
                wr.write(line + "\n");
            }
            wr.flush();
            wr.close();
            return f.getAbsolutePath();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }
}

