/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.AgedDebtorsEntry;
import ro.atreides.facturi.Delegat;
import ro.atreides.facturi.FacturatEntry;
import ro.atreides.facturi.FacturiDao;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.gui.AddFacturaPanel;
import ro.atreides.nomenclatura.FacturiDataProvider;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.FacturaEmitent;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrintUtils;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FacturiAfterAddInterface;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.PlatiEntry;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.DocumentInterface;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.facturi.FacturaItem;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.facturi.FacturiEmiseInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class FacturiLogic
implements FacturiEmiseInterface {
    private static FacturiLogic instance = null;
    private AddFacturaPanel addFacturaPanel;
    private FacturiDataProvider dataProvider;
    private StockLogic stockLogic = StockLogic.getInstance();
    private DocumentInterface documentInterface;
    private ConnectionPool pool = ConnectionPool.getInstance();
    private FacturiAfterAddInterface afterAddInterface;
    public static final int FACTURA_PROFORMA = 1;
    public static final String FACTURA_PROFORMA_LABEL = LangRoAll.proforma;
    public static final int FACTURA_TEMPORAR = 2;
    public static final String FACTURA_TEMPORAR_LABEL = "Comanda ferma";
    public static final int FACTURA_LISTATA = 3;
    public static final String FACTURA_LISTATA_LABEL = "Listata";
    public static final int FACTURA_VALIDATA = 4;
    public static final String FACTURA_VALIDATA_LABEL = "Validata";
    public static final int FACTURA_ANULATA = 5;
    public static final String FACTURA_ANULATA_LABEL = "Anulata";
    public static final int AVIZ = 6;
    public static final String AVIZ_LABEL = "Aviz";

    private FacturiLogic() throws SQLException {
    }

    public static synchronized FacturiLogic getInstance() {
        if (instance == null) {
            try {
                instance = new FacturiLogic();
            }
            catch (SQLException e) {
                Logger.logException(FacturiLogic.class, (Exception)e);
                Utils.systemExit();
            }
            catch (Exception e) {
                Logger.logException(FacturiLogic.class, e);
                Utils.systemExit();
            }
        }
        return instance;
    }

    private synchronized FacturiDao getFacturiDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        FacturiDao dao = null;
        while (dao == null) {
            dao = (FacturiDao)this.pool.getDao(FacturiDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(FacturiDao.class.getName(), connection);
        }
        return dao;
    }

    public String getStringForStatus(int status) {
        switch (status) {
            case 1: {
                return FACTURA_PROFORMA_LABEL;
            }
            case 2: {
                return FACTURA_TEMPORAR_LABEL;
            }
            case 3: {
                return FACTURA_LISTATA_LABEL;
            }
            case 4: {
                return FACTURA_VALIDATA_LABEL;
            }
            case 5: {
                return FACTURA_ANULATA_LABEL;
            }
            case 6: {
                return AVIZ_LABEL;
            }
        }
        return "";
    }

    public int getStatusForString(String status) {
        if (status.equalsIgnoreCase(FACTURA_PROFORMA_LABEL)) {
            return 1;
        }
        if (status.equalsIgnoreCase(FACTURA_TEMPORAR_LABEL)) {
            return 2;
        }
        if (status.equalsIgnoreCase(FACTURA_LISTATA_LABEL)) {
            return 3;
        }
        if (status.equalsIgnoreCase(FACTURA_VALIDATA_LABEL)) {
            return 4;
        }
        if (status.equalsIgnoreCase(FACTURA_ANULATA_LABEL)) {
            return 5;
        }
        if (status.equalsIgnoreCase(AVIZ_LABEL)) {
            return 6;
        }
        return -1;
    }

    public Vector getAllStatuses() {
        Vector<String> result = new Vector<String>();
        result.add(FACTURA_PROFORMA_LABEL);
        result.add(FACTURA_TEMPORAR_LABEL);
        result.add(AVIZ_LABEL);
        result.add(FACTURA_LISTATA_LABEL);
        result.add(FACTURA_VALIDATA_LABEL);
        result.add(FACTURA_ANULATA_LABEL);
        return result;
    }

    @Override
    public FacturaItemView buildFacturaItemView(double cantitate, int idMagazie, int idProduct, int idCategorie, String magazie, double ppuCuTva, double ppuFaraTva, double valoareTVA, String produs, String um, String produsLine2) {
        double qtyRounded = FacturiLogic.round4Facturare(cantitate);
        double ppuCuTvaRound = FacturiLogic.round4Facturare(ppuCuTva);
        double ppuFaraTvaRound = FacturiLogic.round4Facturare(ppuFaraTva);
        double valTvaRound = FacturiLogic.round4Facturare(valoareTVA);
        double value = ppuFaraTvaRound * qtyRounded;
        double valoareCuTva = ppuCuTvaRound * qtyRounded;
        double cotaTva = FacturiLogic.round4Facturare(ppuCuTva / ppuFaraTva);
        FacturaItemView fi = new FacturaItemView(-1, cantitate, idMagazie, idProduct, magazie, ppuFaraTvaRound, produs, um, value, valTvaRound, ppuCuTvaRound, valoareCuTva, cotaTva, ppuFaraTvaRound, value, valTvaRound, ppuCuTvaRound, valoareCuTva, produsLine2);
        return fi;
    }

    public static double round4Facturare(double toRound) {
        try {
            return FloatUtils.roundDoubleUp(toRound, VpConfig.getInstance().facturareRoundDecimals);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public DocumentInterface getDocumentInterface() {
        return this.documentInterface;
    }

    public void setDocumentInterface(DocumentInterface documentInterface) {
        this.documentInterface = documentInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddFactura(Timestamp time) {
        try {
            boolean result = this.documentInterface.canAddDocument(time);
            this.pool.commit();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public int addFacturaNoCommit(int idClient, double valoare, double tva, double total, String seria, int numar, Timestamp data, Vector<FacturaItemView> items, int idAgent, Timestamp scadenta, int status, Vector orderIds, String numarTipizat, String numarAuto, boolean aviz, int whatToPrint, int idSocietateaNoastra, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        Timestamp newData = this.documentInterface.getTimeDocument(8, data);
        this.getFacturiDao().addFactura(idClient, valoare, seria, numar, newData, tva, total, idAgent, scadenta, status, numarTipizat, numarAuto, idSocietateaNoastra);
        int idFactura = this.pool.requestConnection().getIndentityLocal();
        this.addItemsNoCommit(idFactura, items);
        this.addOrderIdsNoCommit(idFactura, orderIds);
        String docName = aviz ? AVIZ_LABEL : LangRoAll.factura;
        boolean fiscal = true;
        fiscal = whatToPrint != 3;
        if (status >= 3 || Config.getInstance().getBoolean("facturareAddTemporarLaDocumente") || VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
            String titlu = docName + " " + seria + numar;
            if (comandaType == StockLogic.COMANDA_TYPE.COMANDA_FERMA) {
                titlu = "Comanda ferma " + numar;
            }
            this.documentInterface.facturaEmisaAdded(idFactura, newData, titlu, fiscal, comandaType);
        }
        if (status == 2) {
            for (int i = 0; i < items.size(); ++i) {
                FacturaItemView facturaItemView = items.elementAt(i);
                int idMagazie = facturaItemView.getIdMagazie();
                if (idMagazie <= 0) continue;
                int idProduct = facturaItemView.getIdProduct();
                int idStock = this.stockLogic.getStockInterface().getIdStockForProductNoCommit(idProduct);
            }
        }
        return idFactura;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addFactura(int idClient, double valoare, double tva, double total, String seria, int numar, Timestamp data, Vector items, int idAgent, Timestamp scadenta, int status, Vector orderIds, String numarTipizat, String numarAuto, boolean aviz, int what, int idSocietateaNoastra, StockLogic.COMANDA_TYPE comandaType) {
        try {
            int idFactura = this.addFacturaNoCommit(idClient, valoare, tva, total, seria, numar, data, items, idAgent, scadenta, status, orderIds, numarTipizat, numarAuto, aviz, what, idSocietateaNoastra, comandaType);
            this.pool.commit();
            int n = idFactura;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkFacturaFileToDb(int fileId, int facturaId) {
        try {
            this.getFacturiDao().linkFacturaFile(fileId, facturaId);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Hashtable buildMapForNotify(double tva, double total, String seria, Timestamp data, String numarFactura, Client c) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("tva", tva);
        result.put("total", total);
        result.put("seria", seria);
        result.put("data", data);
        result.put("numarFactura", numarFactura);
        result.put("client", c);
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String dataN = formatSimple.format(data);
        total = FloatUtils.roundDouble(total, VpConfig.getInstance().facturareRoundDecimals);
        String nodeTitle = "Alte Facturi " + seria + " Nr " + numarFactura + " " + c.toString() + " " + total;
        String nodeDescription = "";
        nodeDescription = nodeDescription + "Numar factura : " + numarFactura + "<br/>";
        nodeDescription = nodeDescription + "Seria : " + seria + "<br/>";
        nodeDescription = nodeDescription + "Client : " + c.toString() + "<br/>";
        nodeDescription = nodeDescription + "Data : " + dataN + "<br/>";
        nodeDescription = nodeDescription + "Total : " + total + "<br/>";
        result.put("node_title", nodeTitle);
        result.put("node_description", nodeDescription);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reprocessFactura(int idFactura, Timestamp data, String document, boolean fiscal, boolean protocol, StockLogic.COMANDA_TYPE comandaType) {
        try {
            this.reprocessFacturaNoCommit(idFactura, data, document, fiscal, protocol, comandaType);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean reprocessFacturaNoCommit(int idFactura, Timestamp data, String document, boolean fiscal, boolean protocol, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        Vector items = this.getFacturiItemsNoCommit(idFactura);
        this.reprocessFacturaItems(items, data, document, fiscal, protocol, comandaType);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFacturaItems(int idFactura, Vector items) {
        try {
            this.addItemsNoCommit(idFactura, items);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void addItemsNoCommit(int idFactura, Vector items) throws SQLException {
        for (int i = 0; i < items.size(); ++i) {
            FacturaItemView o = (FacturaItemView)items.elementAt(i);
            int idMagazie = o.getIdMagazie();
            double quantity = o.getCantitate();
            this.getFacturiDao().addFacturaItem(idFactura, o.getIdProduct(), quantity, o.getPpuCuTva(), o.getPpuFaraTva(), o.getValoareTva(), idMagazie, o.getProdusLine2Full(), o.getProdusLine1());
        }
    }

    private void addOrderIdsNoCommit(int idFactura, Vector orders) throws SQLException {
        for (int i = 0; i < orders.size(); ++i) {
            Integer orderId = (Integer)orders.elementAt(i);
            this.getFacturiDao().addOrderIdToFactura(orderId, idFactura);
        }
    }

    private void reprocessFacturaItems(Vector items, Timestamp data, String serieNumar, boolean fiscal, boolean protocol, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        for (int i = 0; i < items.size(); ++i) {
            FacturaItemView o = (FacturaItemView)items.elementAt(i);
            int idMagazie = o.getIdMagazie();
            double quantity = o.getCantitate();
            int idFacturaItem = o.getId();
            if (idMagazie <= 0) continue;
            int idStock = this.dataProvider.getStockForProductNoCommit(o.getIdProduct());
            if (idStock > 0) {
                if (comandaType == StockLogic.COMANDA_TYPE.TEMPORARA) continue;
                this.stockLogic.decrementStock(idMagazie, idStock, quantity, idFacturaItem, data, serieNumar, fiscal, false, comandaType, o.getIdLot());
                continue;
            }
            int idProdusReteta = this.dataProvider.getIdReteta(o.getIdProduct());
            this.dataProvider.descarcaFactura(idProdusReteta, quantity, data, "Factura " + serieNumar, idMagazie, fiscal, protocol, comandaType, o.getIdLot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFactura(int idFactura, Timestamp dateadd) {
        try {
            this.getFacturiDao().deleteFactura(idFactura);
            Vector<Integer> idProducts = this.getIdProductsFromFacturaItems(idFactura);
            StockLogic.getInstance().deleteFisaMagazieByProductIdAndDate(idProducts, dateadd);
            this.documentInterface.documentDeleted(dateadd);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valideazaFactura(FacturiEmiseView factura) {
        try {
            this.getFacturiDao().setStatusForFactura(factura.getIdFactura(), 4);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anuleazaFactura(FacturiEmiseView factura, int whatToPrint) {
        try {
            int idFactura = factura.getIdFactura();
            this.getFacturiDao().deleteItemsForFactura(idFactura);
            this.getFacturiDao().setStatusForFactura(idFactura, 5);
            this.getFacturiDao().updateTotal(0.0, 0.0, 0.0, idFactura);
            Vector<Integer> idProducts = this.getIdProductsFromFacturaItems(idFactura);
            StockLogic.getInstance().deleteFisaMagazieByProductIdAndDate(idProducts, factura.getData());
            boolean fiscal = true;
            fiscal = whatToPrint != 3;
            this.documentInterface.facturaEmisaUpdated(idFactura, factura.getData(), "Factura " + factura.getSerieNumar(), fiscal, StockLogic.COMANDA_TYPE.EFECTUAT);
            UsersLogic.getInstance().addBOUserLogNoCommit("Anulare factura  serie numar: " + factura.getSerieNumar());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFactura(FacturiEmiseView factura, int idClient, double valoare, double tva, double total, String seria, int numar, Timestamp data, Timestamp scadenta, Vector items, int status, int oldStatus, String numarTipizat, String numarAuto, boolean aviz, int whatToPrint, int idSocietateaNoastra, StockLogic.COMANDA_TYPE comandaType) {
        try {
            Timestamp t1 = factura.getData();
            Timestamp t2 = data;
            Timestamp newData = factura.getData();
            if (!DateUtils.sameMinute(t1, t2)) {
                newData = this.documentInterface.getTimeDocument(8, data);
            }
            if (oldStatus >= 3 || Config.getInstance().getBoolean("facturareAddTemporarLaDocumente")) {
                this.documentInterface.documentDeleted(factura.getData());
                this.documentInterface.documentDeleted(newData);
            }
            int idFactura = factura.getIdFactura();
            this.getFacturiDao().deleteItemsForFactura(idFactura);
            this.getFacturiDao().updateFactura(idClient, valoare, tva, total, seria, numar, newData, scadenta, status, numarTipizat, numarAuto, idFactura, idSocietateaNoastra);
            this.addItemsNoCommit(idFactura, items);
            String docName = aviz ? AVIZ_LABEL : LangRoAll.factura;
            boolean fiscal = true;
            fiscal = whatToPrint != 3;
            if (oldStatus >= 3 || Config.getInstance().getBoolean("facturareAddTemporarLaDocumente") || VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
                this.documentInterface.facturaEmisaUpdated(idFactura, newData, docName + " " + seria + numar, fiscal, comandaType);
            } else if (status >= 3 || Config.getInstance().getBoolean("facturareAddTemporarLaDocumente") || VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
                this.documentInterface.facturaEmisaAdded(idFactura, newData, docName + " " + seria + numar, fiscal, comandaType);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastNrFactura(String seria) {
        try {
            int result;
            int n = result = this.getFacturiDao().getLastFacturaNumber(seria);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = 0;
            return n;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getAllProducts() {
        return this.dataProvider.getAllProducts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPriceForProduct(Product product) {
        try {
            double d = this.dataProvider.getPriceForProductNoCommit(product.getId());
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPretAchizitieForProduct(Product product) {
        try {
            double d = this.dataProvider.getPretAchizitieForProduct(product.getId());
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUmForProduct(int s) {
        try {
            String string = this.dataProvider.getUmForProduct(s);
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = "";
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public AddFacturaPanel getAddFacturaPanel() {
        return this.addFacturaPanel;
    }

    public void setAddFacturaPanel(AddFacturaPanel addFacturaPanel) {
        this.addFacturaPanel = addFacturaPanel;
    }

    @Override
    public void addFacturaItemToGui(FacturaItemView fi) {
        if (this.addFacturaPanel != null) {
            this.addFacturaPanel.addFacturaItem(fi);
        }
    }

    public FacturiDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(FacturiDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<FacturiEmiseView> getFacturiEmise(Hashtable criteria, int what) {
        try {
            Integer idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
            Integer idAgent = (Integer)criteria.get("Agent");
            Integer status = (Integer)criteria.get(Constants.STATUS_FACTURA_KEY);
            Timestamp start = new Timestamp(((Date)criteria.get(Constants.START_KEY)).getTime());
            Timestamp stop = new Timestamp(((Date)criteria.get(Constants.STOP_KEY)).getTime());
            String numar = (String)criteria.get("Numar factura");
            if (numar == null) {
                numar = "";
            }
            int idSocietateaNoastra = -1;
            Object societateObj = criteria.get("Societate");
            if (societateObj != null) {
                ClientPersJuridica societatea = (ClientPersJuridica)societateObj;
                idSocietateaNoastra = societatea.getIdPersJuridica();
            }
            FacturiDao dao = this.getFacturiDao();
            Vector<FacturiEmiseView> result = dao.getFacturiList(idClient, start, stop, idAgent, status, numar, what, idSocietateaNoastra);
            for (FacturiEmiseView facturiEmiseView : result) {
                int idClient1 = facturiEmiseView.getIdClient();
                Client c = ClientLogic.getInstance().getClientFromHash(facturiEmiseView.getIdClient());
                if (c == null) {
                    c = ClientLogic.getInstance().getClientByIdNoCommit(idClient1);
                }
                if (c == null) {
                    Logger.logWarning(this, "Factura " + facturiEmiseView.getSerieNumar() + " - nu am gasit clientul asociat !!");
                    continue;
                }
                facturiEmiseView.setClient(c.toString());
                if (c instanceof ClientPersFizica) {
                    ClientPersFizica cpf = (ClientPersFizica)c;
                    String cnp = ClientLogic.getInstance().getCNPForClientNoCommit(cpf);
                    facturiEmiseView.setCui(cnp);
                } else {
                    ClientPersJuridica cpj = (ClientPersJuridica)c;
                    facturiEmiseView.setCui(cpj.getCui());
                }
                Vector<Integer> ids = this.getFacturiDao().getOrderIdsForFactura(facturiEmiseView.getIdFactura());
                facturiEmiseView.setOrderIds(ids);
            }
            Vector<FacturiEmiseView> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<FacturiEmiseView> vector = new Vector<FacturiEmiseView>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String printPvCustodie(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String nrFactura, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral, int nrCopii) {
        try {
            String tempFile = PrintLogic.getInstance().preparePVCustodiePdf(titlu, cumparator, j, cui, sediu, judet, iban, banca, nrFactura, data, items, totalFaraTva, totalTva, totalGeneral);
            String outFile = FileUtils.getCurrentDir() + File.separator + "data" + File.separator + "Custodie_" + nrFactura + "_" + data + ".pdf";
            PrintUtils.printPdf(tempFile, outFile);
            PrintLogic.getInstance().printPVCustodie(tempFile, nrCopii);
            return outFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFacturiItems(int idFactura) {
        Vector result = new Vector();
        try {
            result = this.getFacturiItemsNoCommit(idFactura);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getFacturiItemsNoCommit(int idFactura) throws SQLException {
        Vector<FacturaItemView> result = new Vector<FacturaItemView>();
        Vector items1 = this.getFacturiDao().getFacturaItems(idFactura);
        for (int i = 0; i < items1.size(); ++i) {
            FacturaItem o = (FacturaItem)items1.elementAt(i);
            Product p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(o.getIdProduct());
            String product = p.getName();
            String linieProdus2 = o.getNumeProdus();
            String linieProdus1 = o.getProdusLine1();
            if (linieProdus1 != null && !linieProdus1.equals("")) {
                product = linieProdus1;
            }
            String um = this.dataProvider.getUmForProduct(o.getIdProduct());
            int idMagazie = o.getIdMagazie();
            String magazie = LangRoAll.faraDescarcare;
            if (idMagazie > 0) {
                Magazie m = this.stockLogic.getMagazieByIdNoCommit(idMagazie);
                magazie = m.getLabel();
            }
            int idCategorie = this.dataProvider.getCategorieForProduct(o.getIdProduct()).getId();
            FacturaItemView fiv = this.buildFacturaItemView(o.getCantitate(), idMagazie, o.getIdProduct(), idCategorie, magazie, o.getPpuCuTva(), o.getPpuFaraTva(), o.getValoareTva(), product, um, linieProdus2 != null ? linieProdus2 : "");
            fiv.setId(o.getId());
            fiv.setProdusLine1(linieProdus1);
            result.add(fiv);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<FacturiNeplatiteEntry> getFacturiNeplatite(int idCLient, int what) {
        Vector<FacturiNeplatiteEntry> result = new Vector();
        try {
            result = this.getFacturiDao().getFacturiNeplatitePtClient(idCLient, what);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDetaliiIncasare(int idFactura, int what) {
        Vector<Object> result = new Vector();
        try {
            result = this.getFacturiDao().getDetaliiPlataForFactura(idFactura, what);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Hashtable<Integer, FacturatEntry> getTotalFacturatNoCommit(Timestamp start, Timestamp stop, int idClient) throws SQLException {
        return this.getFacturiDao().getTotalFacturiForClient(idClient, start, stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, FacturatEntry> getTotalFacturat(Timestamp start, Timestamp stop, int idClient) {
        try {
            Hashtable<Integer, FacturatEntry> hashtable = this.getTotalFacturatNoCommit(start, stop, idClient);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, FacturatEntry> hashtable = new Hashtable<Integer, FacturatEntry>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Hashtable<Integer, AgedDebtorsEntry> getTotalFacturatCategoriesNoCommit(Timestamp start, Timestamp stop, int idCategory) throws SQLException {
        return this.getFacturiDao().getTotalFacturiForClientCategories(start, stop, idCategory);
    }

    public void exportFacturaToCiel(Vector newData) throws IOException {
        StringBuffer exportBuffer = new StringBuffer();
        for (int i = 0; i < newData.size(); ++i) {
            NoteView noteView = (NoteView)newData.elementAt(i);
            int idProdus = noteView.getIdProdus();
            Product p = NomeclaturaLogic.getInstance().getProductById(idProdus);
            String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(idProdus);
            double q = noteView.getCantitate();
            double total = noteView.getSuma();
            double ppu = total / q;
            exportBuffer.append(codBare);
            exportBuffer.append('|');
            exportBuffer.append(codBare);
            exportBuffer.append('|');
            exportBuffer.append(p.getName());
            exportBuffer.append('|');
            exportBuffer.append(Utils.getString2DecimalsNoTrunc(q));
            exportBuffer.append('|');
            exportBuffer.append("BUC");
            exportBuffer.append('|');
            exportBuffer.append(Utils.getString2DecimalsNoTrunc(ppu));
            exportBuffer.append('|');
            exportBuffer.append(Utils.getString2DecimalsNoTrunc(ppu));
            exportBuffer.append('|');
            exportBuffer.append('\r');
            exportBuffer.append('\n');
        }
        FileUtils.writeTextToFile(FileUtils.getCurrentDir() + File.separator + "exportCiel.txt", exportBuffer.toString());
    }

    public String tiparesteFacturaOdt(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String numarIntern, String data, Vector<FacturaItemView> items, String totalFaraTva, String totalTva, String totalGeneral, String scadenta, String modPlata, String observatii, String numeDelegat, String numeEmitent, String cnpEmitent, String seria, String seriaBuletin, String nrBuletin, String eliberatDe, String auto, String ora, String templateFactura, boolean chitanta, String platit, FacturiAfterAddInterface afterAddInterface, int idClient, FacturaEmitent emitent, String totalFaraTvaV2, String totalTvaV2, String totalGeneralV2, String serieChitanta, String numarChitanta, Hashtable optionalHash) {
        String xmlDir = Config.getInstance().getString("facturareExportFacturaXmlDirectory");
        if (Validators.correctString(xmlDir)) {
            this.writeFacturaXmlToDisk(items, xmlDir, numarIntern);
        }
        String s = PrintLogic.getInstance().tiparesteFacturaOdtNew(titlu, cumparator, j, cui, sediu, judet, iban, banca, numarIntern, data, items, totalFaraTva, totalTva, totalGeneral, scadenta, modPlata, observatii, numeDelegat, numeEmitent, cnpEmitent, seria, seriaBuletin, nrBuletin, eliberatDe, auto, ora, chitanta, templateFactura, platit, afterAddInterface, idClient, emitent, totalFaraTvaV2, totalTvaV2, totalGeneralV2, serieChitanta, numarChitanta, optionalHash);
        return s;
    }

    public Vector getDelegati(int idPersJuridica) {
        BiCi bi;
        int idBuletin;
        Delegat d;
        ClientPersFizica clientPersFizica;
        Vector<Delegat> result = new Vector<Delegat>();
        Vector allDelegati = ClientLogic.getInstance().getPartnersInGroup("pers_juridice_groups_delegati_proprii", 1);
        for (int i = 0; i < allDelegati.size(); ++i) {
            Client client = (Client)allDelegati.get(i);
            if (!(client instanceof ClientPersFizica)) continue;
            clientPersFizica = (ClientPersFizica)client;
            d = new Delegat();
            d.setIdPersFizica(clientPersFizica.getIdPersFizica());
            d.setLabel(clientPersFizica.toString());
            idBuletin = clientPersFizica.getIdBuletin();
            if (idBuletin > 0) {
                bi = ClientLogic.getInstance().getBiCiById(idBuletin);
                d.setSerBi(bi.getSeria());
                d.setNrBi(bi.getNumarul());
                d.setPolitia(bi.getSectia());
            }
            result.add(d);
        }
        allDelegati = ClientLogic.getInstance().getPartnersInGroup("pers_juridice_groups_delegat", 1);
        Vector delegatiPJ = ClientLogic.getInstance().getAnjagati(idPersJuridica);
        for (int i = 0; i < delegatiPJ.size(); ++i) {
            clientPersFizica = (ClientPersFizica)delegatiPJ.elementAt(i);
            if (!allDelegati.contains(clientPersFizica)) continue;
            d = new Delegat();
            d.setIdPersFizica(clientPersFizica.getIdPersFizica());
            d.setLabel(clientPersFizica.toString());
            idBuletin = clientPersFizica.getIdBuletin();
            if (idBuletin > 0) {
                bi = ClientLogic.getInstance().getBiCiById(idBuletin);
                d.setSerBi(bi.getSeria());
                d.setNrBi(bi.getNumarul());
                d.setPolitia(bi.getSectia());
            }
            result.add(d);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adaugaFacturaOdtBg(Client client, Vector<FacturaItemView> items, int numarIntern, String seria, Timestamp dataFacturii, double valoareTotala, double tvaTotal, double totalGeneral, Timestamp scadenta, String modPlata, String observatii, String numeDelegat, String nume, String cnp, String numarTipizat, int idAgent, String seriaBi, String nrBi, String politia, String numarAuto, String title, int what, String templateFactura, boolean chitanta, String platit, FacturiAfterAddInterface afterAddInterface, int idClient, int idSocietateaNoastra, FacturaEmitent emitent, String totalFaraTvaV2, String totalTvaV2, String totalGeneralV2, StockLogic.COMANDA_TYPE comandaType, String serieChitanta, String numarChitanta) {
        String banca;
        String iban;
        String cui;
        String j;
        String cumparator;
        try {
            this.addFacturaNoCommit(client.getId(), valoareTotala, tvaTotal, totalGeneral, seria, numarIntern, dataFacturii, items, idAgent, scadenta, 3, new Vector(), numarTipizat, numarAuto, false, what, idSocietateaNoastra, comandaType);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean e1 = false;
            return e1;
        }
        finally {
            this.pool.releaseConnection();
        }
        if (client instanceof ClientPersFizica) {
            ClientPersFizica pf = (ClientPersFizica)client;
            cumparator = pf.getFirstname() + " " + pf.getLastname();
            j = "";
            cui = "";
            iban = "";
            banca = "";
            int idBuletin = pf.getIdBuletin();
            BiCi bici = ClientLogic.getInstance().getBiCiById(idBuletin);
            if (bici != null) {
                j = "CNP: " + bici.getCnp();
                cui = "Bi/Ci: " + bici.getSeria() + " " + bici.getNumarul() + " emis de " + bici.getSectia();
            }
        } else {
            ClientPersJuridica pj = (ClientPersJuridica)client;
            cumparator = pj.getCompanyName();
            j = pj.getJ();
            cui = pj.getCui();
            iban = pj.getBankIban();
            banca = pj.getBank();
        }
        String adresa = client.getAddress1();
        String judet = client.getCity();
        String dataS = Formatters.DATE_FORMAT_RO.format(dataFacturii);
        String scadentaS = Formatters.DATE_FORMAT_RO.format(scadenta);
        String ora = Formatters.TIME_FORMAT.format(dataFacturii);
        String s = this.tiparesteFacturaOdt(title, cumparator, j, cui, adresa, judet, iban, banca, numarIntern + "", dataS, items, Utils.getString2DecimalsNoTrunc(valoareTotala), Utils.getString2DecimalsNoTrunc(tvaTotal), Utils.getString2DecimalsNoTrunc(totalGeneral), scadentaS, modPlata, observatii, numeDelegat, nume, cnp, seria, seriaBi, nrBi, politia, "", ora, templateFactura, chitanta, platit, afterAddInterface, idClient, emitent, totalFaraTvaV2, totalTvaV2, totalGeneralV2, serieChitanta, numarChitanta, new Hashtable());
        return s != null;
    }

    public static FacturaEmitent getFacturaEmitent(ClientPersJuridica cpj) {
        FacturaEmitent fe = new FacturaEmitent();
        fe.setSediu(cpj.getAddress1() + " " + cpj.getCity());
        fe.setBanca(cpj.getBank());
        fe.setIban(cpj.getBankIban());
        fe.setJ(cpj.getJ());
        fe.setCui(cpj.getCui());
        fe.setSocietate(cpj.getCompanyName());
        return fe;
    }

    public boolean tiparesteChitanta(String numarIntern, String data, Client client, String explicatii, String platit) {
        String cui;
        String cumparator;
        if (client instanceof ClientPersFizica) {
            ClientPersFizica pf = (ClientPersFizica)client;
            cumparator = pf.getFirstname() + " " + pf.getLastname();
            cui = "";
            int idBuletin = pf.getIdBuletin();
            BiCi bici = ClientLogic.getInstance().getBiCiById(idBuletin);
            if (bici != null) {
                cui = "Bi/Ci: " + bici.getSeria() + " " + bici.getNumarul() + " emis de " + bici.getSectia();
            }
        } else {
            ClientPersJuridica pj = (ClientPersJuridica)client;
            cumparator = pj.getCompanyName();
            cui = pj.getCui();
        }
        String adresa = client.getAddressAsString();
        String judet = client.getCity();
        FacturiAfterAddInterface addInterface = new FacturiAfterAddInterface(){

            @Override
            public void afterAdd(String generatedFile, String title, int idClient) {
                ClientLogic.getInstance().addDocumentToClient(generatedFile, title, "Chitanta incasare", idClient);
            }
        };
        boolean result = PrintLogic.getInstance().tiparesteChitanta(numarIntern, data, cumparator, cui, adresa, judet, explicatii, platit, "template_chitanta_openoffice.odt", addInterface, client.getId(), "Chitanta");
        return result;
    }

    private void writeFacturaXmlToDisk(Vector<FacturaItemView> items, String directory, String numarIntern) {
        FileUtils.buildDir(directory);
        String fullPath = new File(directory).getAbsolutePath();
        String filename = fullPath + File.separator + "factura_" + numarIntern + ".xml";
        StringBuffer buff = new StringBuffer();
        buff.append("<facturafurnizor>\n");
        for (FacturaItemView item : items) {
            String cant = Utils.getString2Decimals(item.getCantitate());
            String cotaTva = Utils.getString2Decimals(item.getCotaTva() - 1.0);
            String pretCuTva = Utils.getString2Decimals(item.getPpuCuTva());
            String pretFaraTva = Utils.getString2Decimals(item.getPpuFaraTva());
            String valoare = Utils.getString2Decimals(item.getValoareCuTva());
            int idProdus = item.getIdProduct();
            String cod = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(idProdus);
            String line = "<produs cantitate=\"" + cant + "\" valoarecutva=\"" + valoare + "\" cotatva=\"" + cotaTva + "\" codbare=\"" + cod + "\" />\n";
            buff.append(line);
        }
        buff.append("</facturafurnizor>\n");
        try {
            FileUtils.writeTextToFile(filename, buff.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void setAfterAddInterface(FacturiAfterAddInterface afterAddInterface) {
        this.afterAddInterface = afterAddInterface;
    }

    public FacturiAfterAddInterface getAfterAddInterface() {
        return this.afterAddInterface;
    }

    public void addPlataLaFactura(double totalAchitat, String cumparator, int idLocatie, int numarInter, int idFactura) {
        TipPlata cash = TipPlataProvider.getInstance().getDefaultTipPlataCommit();
        Plata plata = new Plata(cash.getId(), totalAchitat, cash.getEcrMapping(), cash.getLabel(), "", 0);
        Vector<Plata> plati = new Vector<Plata>();
        plati.add(plata);
        Vector<PlatiEntry> facturiEmise = new Vector<PlatiEntry>();
        PlatiEntry pe = new PlatiEntry();
        pe.setIdFactura(idFactura);
        pe.setSuma(totalAchitat);
        pe.setDetaliereIncasari(new Hashtable());
        facturiEmise.add(pe);
        String anexa = "Factura " + numarInter;
        FacturiLogic.getInstance().getDataProvider().addIncasareFacturaCashInRegCasa(plati, idLocatie, numarInter + "", DateUtils.getCurrentTimestamp(), anexa, cumparator, facturiEmise);
    }

    public boolean isMultipleSocietatiEnabled() {
        return Config.getInstance().getBoolean("societatiMultipleEnabled");
    }

    public int writeAndLinkFileToDb(String file) {
        try {
            File f = new File(file);
            String fileName = f.getName();
            int size = (int)f.length();
            FileInputStream fin = new FileInputStream(file);
            int idFile = DocumenteLogic.getInstance().addFileCommit(fileName, "", file, "", fin, size);
            return idFile;
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
            return -1;
        }
    }

    public void linkFacturaFileInDb(String file, int idFactura) {
        int fileId = this.writeAndLinkFileToDb(file);
        this.linkFacturaFileToDb(fileId, idFactura);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getFileIdByIdFactura(int idFactura) {
        Hashtable result = new Hashtable();
        try {
            result = this.getFacturiDao().getIdFileByIdFactura(idFactura);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<Integer> getIdProductsFromFacturaItems(int idFactura) throws SQLException {
        Vector<Integer> result = new Vector<Integer>();
        Vector facturiItemsNoCommit = this.getFacturiItemsNoCommit(idFactura);
        for (FacturaItemView fiv : facturiItemsNoCommit) {
            result.add(fiv.getIdProduct());
        }
        return result;
    }

    public Hashtable<String, String> getSerieSiNumarChitanteForUser(Component parent, String username) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String seriiChitante = VpConfig.getInstance().facturareChitanteSerii;
        if (seriiChitante.isEmpty()) {
            DialogUtils.errorDialog(parent, "Configurare vida, setati seriile de chitanta", LangRoAll.nuPotContinua);
            return null;
        }
        String[] asocieri = seriiChitante.split(",");
        Vector<String> seriiAsociateUserului = new Vector<String>();
        for (String s : asocieri) {
            String[] split = s.split("=");
            if (split.length < 2 || !split[1].equalsIgnoreCase(username) && !split[1].equals("*")) continue;
            String serie = split[0];
            seriiAsociateUserului.add(serie);
        }
        if (seriiAsociateUserului.isEmpty()) {
            DialogUtils.errorDialog(parent, "Configurare incompleta, userul nu are o serie de chitanta asociata", LangRoAll.nuPotContinua);
            return null;
        }
        String serieChitanta = seriiAsociateUserului.size() == 1 ? (String)seriiAsociateUserului.get(0) : (String)DialogUtils.getItemChooserDialog(seriiAsociateUserului, 2, false);
        int numarChitanta = RegistreLogic.getInstance().getNewNumberForRegistru(serieChitanta, "", true);
        String numarChitantaString = numarChitanta + "";
        result.put("serie_chitanta", serieChitanta);
        result.put("numar_chitanta", numarChitantaString);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocumentForComandaFermaOnOrder(Order o) {
        try {
            int factura_id;
            int n = factura_id = this.getFacturiDao().getIdDocumentForComandaFerma(o.getId());
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void deleteFacturaItemsByIdNoCommit(int id) throws SQLException {
        this.getFacturiDao().deleteItemsById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFacturaItemsById(int id) {
        try {
            this.deleteFacturaItemsByIdNoCommit(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePricesFacturaItemViewValuta(Vector<FacturaItemView> data, Valuta valutaSelectata) {
        Vector<Valuta> allValute = ValuteLogic.getInstance().getAllValute();
        Hashtable<Integer, Valuta> valuteHash = new Hashtable<Integer, Valuta>();
        for (Valuta valuta : allValute) {
            valuteHash.put(valuta.getId(), valuta);
        }
        try {
            for (FacturaItemView f : data) {
                Valuta valutaProdusului = ValuteLogic.getInstance().getValutaFromProductNoCommit(f.getIdProduct());
                if (valutaSelectata.equals(valutaProdusului)) continue;
                Double coeficient = valutaSelectata.isPrincipala() ? valutaProdusului.getParitate() : Double.valueOf(valutaProdusului.getParitate() / valutaSelectata.getParitate());
                this.updateFacturaItemViewPricesWithCoeficient(f, coeficient);
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void updateFacturaItemViewPricesWithCoeficient(FacturaItemView f, Double coeficient) {
        double ppuFaraTva = f.getPpuFaraTva();
        f.setPpuFaraTva(ppuFaraTva * coeficient);
        f.setPpuCuTva(f.getPpuFaraTva() * f.getCotaTva());
        f.setValoareCuTva(f.getPpuCuTva() * f.getCantitate());
        f.setValoare(f.getCantitate() * f.getPpuFaraTva());
        f.setValoareTva(f.getValoareTva() * coeficient);
    }
}

