/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.facturi.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.Delegat;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.gui.AddDelegatDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.FacturaEmitent;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.MagazieDisponibilBean;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class AddFacturaPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JDialog parentDialog;
    private Component parent;
    private JComboBox magazii;
    private JComboBox agenti;
    private JComboBox delegati;
    private JComboBox serii;
    private JComboBox societati;
    private XComboBox clienti;
    private XComboBox produse;
    private JTextField numarIntern;
    private JTextField numarTipizat;
    private JTextField time;
    private JTextField produsFacturaLine2;
    private JTextField umText;
    private JTextField cantitate;
    private JTextField pretCuTva;
    private JTextField pretFaraTva;
    private JTextField modPlata;
    private JTextField auto;
    private JTextField credit;
    private JTextField observatii;
    private JTextField nrBon;
    private JTextField produsFacturaLine1;
    private JTextField adaosImpus;
    private JCheckBox faraTva;
    private JButton adauga;
    private JButton printProforma;
    private JButton renunta;
    private JButton printFactura;
    private JButton printFacturaCuChitanta;
    private JButton temporarButton;
    private JButton adaugaDelegat;
    private JButton avizButton;
    private MDateEntryField data;
    private MDateEntryField scadenta;
    private JLabel totalFactura;
    private JLabel totalTva;
    private JLabel totalFacturaCuTva;
    private AbstractTM itemsTm;
    private double valoareTotala;
    private double tvaTotal1;
    private double totalGeneral;
    private double valoareTotala2;
    private double tvaTotal2;
    private double totalGeneral2;
    private String totalTvaText;
    private String totalTvaText2;
    private FacturiLogic facturiLogic;
    private SwitchToList action;
    private FilterableComboBoxModel clientsComboModel;
    private FilterableComboBoxModel productsComboModel;
    private FacturiEmiseView factura;
    private JPanel produsPanel;
    private JPanel facturaPanel;
    private JPanel clientPanel;
    private JPanel societatePanel;
    private boolean computePriceCuTva = false;
    private Vector orderIds = new Vector();
    private User emitent;
    private Hashtable facturaByNotaHash = new Hashtable();
    private Hashtable<Double, FacturaItemView> discountHash = new Hashtable();
    private Delegat forcedDelegat = null;
    private boolean allowEditGlobal = false;
    public static final String[] columns = new String[]{LangRoAll.denumire, "UM", "Cant", "Magazia", "Ppu f TVA", "Val f TVA", "TVA Total"};
    private JTable table;
    private Integer numarFactura;
    private Valuta valutaSelectata = null;

    public void setForcedDelegat(Delegat forcedDelegat) {
        this.forcedDelegat = forcedDelegat;
    }

    public SwitchToList getAction() {
        return this.action;
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    public User getEmitent() {
        return this.emitent;
    }

    public void setEmitent(User emitent) {
        this.emitent = emitent;
    }

    public AddFacturaPanel(Component parent) {
        this.parent = parent;
        this.facturiLogic = FacturiLogic.getInstance();
        this.init();
        if (this.produse.getItemCount() > 0) {
            this.produse.setSelectedIndex(0);
            this.updateUnitateMasura();
            this.updateProductName();
        }
    }

    public AddFacturaPanel(Component parent, Hashtable criteria) {
        this(parent);
        this.enableButtonsBasedOnCriteria(criteria);
    }

    private void updateUnitateMasura() {
        Product s = (Product)this.produse.getSelectedItem();
        if (s != null) {
            this.umText.setText(this.facturiLogic.getUmForProduct(s.getId()));
        }
    }

    private void updateProductName() {
        this.computePriceCuTva = false;
        Product s = (Product)this.produse.getSelectedItem();
        if (s != null) {
            String productLine2 = NomeclaturaLogic.getInstance().getAllBarcodesForProductAsString(s.getId());
            this.produsFacturaLine1.setText(s.getName());
            this.produsFacturaLine2.setText(productLine2);
        }
    }

    @Override
    public void doStuff() {
        this.allowEditGlobal = Config.getInstance().getBoolean("facturareAllowEditFacturaListata");
    }

    private void init() {
        this.allowEditGlobal = Config.getInstance().getBoolean("facturareAllowEditFacturaListata");
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.societati = new JComboBox<ClientPersJuridica>(ClientLogic.getInstance().getSocietatiPropriiSorted());
        this.productsComboModel = new FilterableComboBoxModel(this.facturiLogic.getAllProducts());
        this.produse = new XComboBox(this.productsComboModel, true);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produse.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddFacturaPanel.this.produse.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.agenti = new JComboBox();
        ComboUtils.replaceItemsForCombo(this.agenti, UsersLogic.getInstance().getUsersInGroup("group_agenti"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddFacturaPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getClientsSorted());
            }

            @Override
            public String getName() {
                return "FacturaPanel_persFizica";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddFacturaPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getClientsSorted());
                ComboUtils.replaceItemsForCombo(AddFacturaPanel.this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted(), false);
            }

            @Override
            public String getName() {
                return "FacturaPanel_persJuridica";
            }
        }, 42);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddFacturaPanel.this.refreshMagaziiCombo(-1);
            }

            @Override
            public String getName() {
                return "AddFacturaPanel_magazii";
            }
        }, 27);
        UsersLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(AddFacturaPanel.this.agenti, UsersLogic.getInstance().getUsersInGroup("group_agenti"));
            }

            @Override
            public String getName() {
                return "AddFacturaPanel_users";
            }
        }, 4);
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddFacturaPanel.this.refreshIngredientsCombo();
            }

            @Override
            public String getName() {
                return "AddFacturaPanel_produseReteta";
            }
        }, 2);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddFacturaPanel.this.refreshIngredientsCombo();
            }

            @Override
            public String getName() {
                return "AddFacturaPanel_stocks";
            }
        }, 26);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.societatePanel = this.getSocietatePanel();
        if (this.facturiLogic.isMultipleSocietatiEnabled()) {
            result.add((Component)this.societatePanel, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 1.0;
        this.clientPanel = this.getClientPanel();
        result.add((Component)this.clientPanel, c);
        c.weightx = 1.0;
        this.facturaPanel = this.getFacturaPanel();
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)this.facturaPanel, c);
        ++c.gridy;
        c.gridx = 0;
        this.produsPanel = this.getProdusPanel();
        result.add((Component)this.produsPanel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        JPanel nirTable = this.getNirTablePanel();
        result.add((Component)nirTable, c);
        return result;
    }

    private void updatePriceFieldsForProduct(Product p) {
        System.out.println("update price fields for product " + p);
        if (p != null) {
            String adaosText = this.adaosImpus.getText();
            if (Validators.correctDouble(adaosText)) {
                double adaos = Utils.parseDouble(adaosText);
                System.out.println("adaos : " + adaos);
                double ppuNoTva = this.facturiLogic.getPretAchizitieForProduct(p) * (1.0 + adaos / 100.0);
                this.pretFaraTva.setText(Utils.getString2Decimals(ppuNoTva));
                if (this.faraTva.isSelected()) {
                    this.pretCuTva.setText(Utils.getString2Decimals(ppuNoTva));
                } else {
                    Categorie c = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                    Tva tva = TvaLogic.getInstance().getTvaById(c.getIdTva());
                    double ppuTva = ppuNoTva * (1.0 + tva.getCota());
                    this.pretCuTva.setText(Utils.getString2Decimals(ppuTva));
                }
            } else {
                System.out.println("fara adaos");
                double ppuTva = this.facturiLogic.getPriceForProduct(p);
                Categorie c = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                Tva tva = TvaLogic.getInstance().getTvaById(c.getIdTva());
                double ppuNoTva = ppuTva / (1.0 + tva.getCota());
                this.pretFaraTva.setText(Utils.getString2Decimals(ppuNoTva));
                if (this.faraTva.isSelected()) {
                    this.pretCuTva.setText(Utils.getString2Decimals(ppuNoTva));
                } else {
                    this.pretCuTva.setText(Utils.getString2Decimals(ppuTva));
                }
            }
            this.refreshMagaziiCombo(p.getId());
        } else {
            System.out.println("p is null");
        }
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product p = (Product)AddFacturaPanel.this.produse.getSelectedItem();
                AddFacturaPanel.this.updatePriceFieldsForProduct(p);
            }
        });
        result.add((Component)this.produse, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.produslinie1), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produsFacturaLine1 = new JTextField(10);
        this.produsFacturaLine1.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddFacturaPanel.this.produsFacturaLine1.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                AddFacturaPanel.this.produsFacturaLine1.select(0, 0);
            }
        });
        result.add((Component)this.produsFacturaLine1, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret fara tva"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.pretFaraTva = new JTextField(10);
        this.pretFaraTva.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddFacturaPanel.this.pretFaraTva.setSelectionStart(0);
                AddFacturaPanel.this.pretFaraTva.setSelectionEnd(AddFacturaPanel.this.pretFaraTva.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                Product p;
                if (AddFacturaPanel.this.computePriceCuTva && (p = (Product)AddFacturaPanel.this.produse.getSelectedItem()) != null) {
                    if (!Validators.correctDouble(AddFacturaPanel.this.pretFaraTva.getText())) {
                        DialogUtils.errorDialog(AddFacturaPanel.this.parent, "Pretul fara tva nu este un numar", LangRoAll.nuPotContinua);
                        AddFacturaPanel.this.pretFaraTva.setText("");
                        return;
                    }
                    double ppuNoTva = Utils.parseDouble(AddFacturaPanel.this.pretFaraTva.getText());
                    if (!AddFacturaPanel.this.faraTva.isSelected()) {
                        Categorie c = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
                        Tva tva = TvaLogic.getInstance().getTvaById(c.getIdTva());
                        double cota1 = tva.getCota();
                        double cota = FloatUtils.roundDoubleUp(cota1, VpConfig.getInstance().facturareRoundDecimals);
                        double ppuTva = ppuNoTva * (1.0 + cota);
                        ppuTva = FloatUtils.roundDoubleUp(ppuTva, VpConfig.getInstance().facturareRoundDecimals);
                        AddFacturaPanel.this.pretCuTva.setText(Utils.getStringXDecimals(ppuTva, VpConfig.getInstance().facturareRoundDecimals));
                    } else {
                        AddFacturaPanel.this.pretCuTva.setText(Utils.getStringXDecimals(ppuNoTva, VpConfig.getInstance().facturareRoundDecimals));
                    }
                }
            }
        });
        this.pretFaraTva.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AddFacturaPanel.this.computePriceCuTva = true;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        result.add((Component)this.pretFaraTva, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.produslinie2), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.produsFacturaLine2 = new JTextField(10);
        result.add((Component)this.produsFacturaLine2, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret cu tva"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.pretCuTva = new JTextField(10);
        this.pretCuTva.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddFacturaPanel.this.pretCuTva.setSelectionStart(0);
                AddFacturaPanel.this.pretCuTva.setSelectionEnd(AddFacturaPanel.this.pretCuTva.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.pretCuTva, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("U.M."), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.umText = new JTextField(10);
        result.add((Component)this.umText, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        result.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFacturaPanel.this.addEntry();
            }
        });
        result.add((Component)this.adauga, c);
        this.refreshIngredientsCombo();
        this.refreshMagaziiCombo(-1);
        this.initFields();
        FocusTraversalPolicy focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    AddFacturaPanel.this.updateUnitateMasura();
                    AddFacturaPanel.this.updateProductName();
                    return AddFacturaPanel.this.produsFacturaLine1;
                }
                if (aComponent.equals(AddFacturaPanel.this.produsFacturaLine1)) {
                    return AddFacturaPanel.this.magazii;
                }
                if (aComponent.equals(AddFacturaPanel.this.magazii)) {
                    return AddFacturaPanel.this.cantitate;
                }
                if (aComponent.equals(AddFacturaPanel.this.cantitate)) {
                    return AddFacturaPanel.this.pretFaraTva;
                }
                if (aComponent.equals(AddFacturaPanel.this.pretFaraTva)) {
                    return AddFacturaPanel.this.pretCuTva;
                }
                if (aComponent.equals(AddFacturaPanel.this.pretCuTva)) {
                    return AddFacturaPanel.this.adauga;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                AddFacturaPanel.this.produse.selectAllText();
                return AddFacturaPanel.this.produse;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return AddFacturaPanel.this.produse;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return AddFacturaPanel.this.adauga;
            }
        };
        result.setFocusCycleRoot(true);
        result.setFocusTraversalPolicy(focus);
        return result;
    }

    private void updateMagazieDisponibilLabel(Product product) {
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            MagazieDisponibilBean m = (MagazieDisponibilBean)this.magazii.getSelectedItem();
            System.out.println("UPDATING PRICES" + m);
        } else {
            int idMagazie = -1;
            Hashtable<Integer, String> dis = StockLogic.getInstance().getStockInterface().getStringDisponibilForMagazieAndStock(product.getId(), idMagazie, false);
            System.out.println("UPDATING PRICES" + dis.get(-1));
        }
    }

    private void refreshIngredientsCombo() {
        this.productsComboModel.refresh(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1));
    }

    private void refreshMagaziiCombo(int idProduct) {
        Vector<Magazie> m = StockLogic.getInstance().getMagazii();
        boolean showDisponibil = Config.getInstance().getBoolean("facturareShowCantitatePerMagazii");
        Vector<MagazieDisponibilBean> magazieDisponibilBeans = new Vector<MagazieDisponibilBean>();
        for (Magazie magazie : m) {
            MagazieDisponibilBean mdb = new MagazieDisponibilBean();
            mdb.setMagazie(magazie);
            if (showDisponibil && idProduct > 0) {
                Hashtable<Integer, String> s = StockLogic.getInstance().getStockInterface().getStringDisponibilForMagazieAndStock(idProduct, magazie.getId(), true);
                mdb.setDisponibil(s.get(magazie.getId()));
                mdb.setShowDisponibil(true);
            }
            magazieDisponibilBeans.add(mdb);
        }
        ComboUtils.replaceItemsForCombo(this.magazii, magazieDisponibilBeans);
    }

    private void initFields() {
        this.produsFacturaLine2.setText("");
        this.produsFacturaLine1.setText("");
        this.umText.setText("");
        this.cantitate.setText("");
        this.forcedDelegat = null;
    }

    private JPanel getSocietatePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Societate"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Societatea noastra"), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.societati, c);
        return result;
    }

    private JPanel getFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date factura"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Seria"), c);
        this.serii = new JComboBox();
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.serii, c);
        Vector v = Utils.splitString(Config.getInstance().getString("facturareSerii"), ',');
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            this.serii.addItem(s);
        }
        this.serii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddFacturaPanel.this.factura == null) {
                    AddFacturaPanel.this.setNrFactura();
                } else {
                    String serieFactura = AddFacturaPanel.this.factura.getSerie();
                    AddFacturaPanel.this.setNrFactura(serieFactura, AddFacturaPanel.this.factura.getNumarIntern());
                }
            }
        });
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr intern"), c);
        this.numarIntern = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.numarIntern, c);
        this.setNrFactura();
        if (Config.getInstance().getBoolean("facturareNrInternReadOnly")) {
            this.numarIntern.setEditable(false);
        }
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr tipizat"), c);
        this.numarTipizat = new JTextField(10);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.numarTipizat, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.data = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.data.setValue(new Date());
        this.data.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Data facturii");
        this.data.setMinimum(DateUtils.getStartOfCentury());
        this.data.setShowTodayButton(true);
        result.add((Component)this.data, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.time = new JTextField();
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Scadenta"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.scadenta = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.scadenta.setValue(new Date());
        this.scadenta.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this.scadenta.setConstraints((MDateSelectorConstraints)c2);
        this.scadenta.setToolTipText("Data scadenta");
        this.scadenta.setMinimum(DateUtils.getStartOfCentury());
        this.scadenta.setShowTodayButton(true);
        result.add((Component)this.scadenta, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Plata"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.modPlata = new JTextField(5);
        result.add((Component)this.modPlata, c);
        c.gridwidth = 1;
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr Bon"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrBon = new JTextField(10);
        result.add((Component)this.nrBon, c);
        this.nrBon.setEditable(false);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Adaos %"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.adaosImpus = new JTextField(3);
        result.add((Component)this.adaosImpus, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Fara TVA"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.faraTva = new JCheckBox();
        this.faraTva.setSelected(false);
        result.add((Component)this.faraTva, c);
        return result;
    }

    private JPanel getClientPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date client"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.gridwidth = 6;
        c.weightx = 1.0;
        result.add((Component)this.clienti, c);
        c.gridwidth = 1;
        c.gridx += 6;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Agent"), c);
        ++c.gridx;
        c.gridwidth = 3;
        result.add((Component)this.agenti, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Obs"), c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.observatii = new JTextField(30);
        result.add((Component)this.observatii, c);
        c.gridwidth = 1;
        c.gridx += 2;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Credit"), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.credit = new JTextField(10);
        result.add((Component)this.credit, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Auto"), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.auto = new JTextField(10);
        result.add((Component)this.auto, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Delegat"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.delegati = new JComboBox();
        result.add((Component)this.delegati, c);
        final AddFacturaPanel panel = this;
        c.gridwidth = 1;
        c.gridx += 2;
        c.weightx = 0.0;
        this.adaugaDelegat = new JButton("+");
        this.adaugaDelegat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Client client = (Client)AddFacturaPanel.this.clienti.getSelectedItem();
                if (client == null || client instanceof ClientPersFizica) {
                    DialogUtils.errorDialog(AddFacturaPanel.this.parent, "Alegeti o persoana juridica", LangRoAll.nuPotContinua);
                    return;
                }
                ClientPersJuridica cpj = (ClientPersJuridica)client;
                AddDelegatDialog dia = new AddDelegatDialog(panel, AddFacturaPanel.this.parentDialog, GuiUtils.currentFrame, cpj, AddFacturaPanel.this.delegati);
            }
        });
        result.add((Component)this.adaugaDelegat, c);
        FocusTraversalPolicy focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    AddFacturaPanel.this.updateDetaliiClienti();
                    return AddFacturaPanel.this.numarIntern;
                }
                if (aComponent.equals(AddFacturaPanel.this.numarIntern)) {
                    return AddFacturaPanel.this.data;
                }
                if (aComponent.equals(AddFacturaPanel.this.data)) {
                    return AddFacturaPanel.this.time;
                }
                if (aComponent.equals(AddFacturaPanel.this.time)) {
                    return AddFacturaPanel.this.agenti;
                }
                if (aComponent.equals(AddFacturaPanel.this.agenti)) {
                    return AddFacturaPanel.this.observatii;
                }
                if (aComponent.equals(AddFacturaPanel.this.observatii)) {
                    return AddFacturaPanel.this.credit;
                }
                if (aComponent.equals(AddFacturaPanel.this.credit)) {
                    return AddFacturaPanel.this.modPlata;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                AddFacturaPanel.this.clienti.selectAllText();
                return AddFacturaPanel.this.clienti;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return AddFacturaPanel.this.clienti;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return AddFacturaPanel.this.modPlata;
            }
        };
        result.setFocusCycleRoot(true);
        result.setFocusTraversalPolicy(focus);
        return result;
    }

    public void updateDetaliiClienti() {
        Client c = (Client)this.clienti.getSelectedItem();
        if (c instanceof ClientPersJuridica) {
            ClientPersJuridica cpj = (ClientPersJuridica)c;
            int idAgent = cpj.getIdAgent();
            if (idAgent > 0) {
                User u = UsersLogic.getInstance().getUserById(idAgent);
                this.agenti.setSelectedItem(u);
            } else {
                this.agenti.setSelectedIndex(0);
            }
            this.observatii.setText(cpj.getObservatii());
            if (Config.getInstance().getBoolean("facturareModificareDataAutomat")) {
                Date now = new Date();
                this.data.setValue(now);
                this.time.setText(Formatters.TIME_FORMAT.format(now));
                int nrZileScadenta = cpj.getNrZileScadenta();
                Date d2 = DateUtils.addDaysToDate(now, nrZileScadenta);
                this.scadenta.setValue(d2);
            }
            this.credit.setText("" + cpj.getCredit());
            int idPersJuridica = cpj.getIdPersJuridica();
            Vector del2 = this.facturiLogic.getDelegati(idPersJuridica);
            ComboUtils.replaceItemsForCombo(this.delegati, (Collection)del2, false);
        } else {
            this.agenti.setSelectedIndex(0);
            this.observatii.setText("");
            if (Config.getInstance().getBoolean("facturareModificareDataAutomat")) {
                this.scadenta.setValue(new Date());
                this.data.setValue(new Date());
                this.time.setText(Formatters.TIME_FORMAT.format(new Date()));
            }
            this.credit.setText("");
        }
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.valoare), c);
        ++c.gridx;
        this.totalFactura = new JLabel("0");
        result.add((Component)this.totalFactura, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare TVA"), c);
        ++c.gridx;
        this.totalTva = new JLabel("0");
        result.add((Component)this.totalTva, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalFacturaCuTva = new JLabel("0");
        result.add((Component)this.totalFacturaCuTva, c);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.printFactura = new JButton("Tipareste factura");
        this.printFactura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean confirmat = true;
                if (AddFacturaPanel.this.factura != null) {
                    confirmat = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Confirmare", "");
                }
                if (confirmat) {
                    AddFacturaPanel.this.printFacturaOdt("Factura fiscala", 3, AddFacturaPanel.this.emitent, false, 0.0, StockLogic.COMANDA_TYPE.EFECTUAT);
                    if (AddFacturaPanel.this.parentDialog != null) {
                        AddFacturaPanel.this.parentDialog.dispose();
                    }
                }
            }
        });
        result.add((Component)this.printFactura, c);
        this.printFacturaCuChitanta = new JButton("Tipareste factura + chitanta");
        this.printFacturaCuChitanta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String totalS = DialogUtils.inputDialog(GuiUtils.currentFrame, AddFacturaPanel.this.totalFacturaCuTva.getText(), "Suma achitata");
                if (!Validators.correctDouble(totalS)) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Introduceti un numar", LangRoAll.nuPotContinua);
                    return;
                }
                double t = Utils.parseDouble(totalS);
                boolean confirmat = true;
                if (AddFacturaPanel.this.factura != null) {
                    confirmat = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Confirmare", "");
                }
                if (confirmat) {
                    AddFacturaPanel.this.printFacturaOdt("Factura fiscala", 3, AddFacturaPanel.this.emitent, true, t, StockLogic.COMANDA_TYPE.EFECTUAT);
                    if (AddFacturaPanel.this.parentDialog != null) {
                        AddFacturaPanel.this.parentDialog.dispose();
                    }
                }
            }
        });
        if (this.showFacturaSiChitantaButton()) {
            ++c.gridx;
            result.add((Component)this.printFacturaCuChitanta, c);
        }
        this.printProforma = new JButton("Oferta");
        this.printProforma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockLogic.COMANDA_TYPE comandaType = StockLogic.COMANDA_TYPE.EFECTUAT;
                if (VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
                    comandaType = StockLogic.COMANDA_TYPE.TEMPORARA;
                }
                boolean confirmat = true;
                if (AddFacturaPanel.this.factura != null) {
                    confirmat = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Confirmare", "");
                }
                if (confirmat) {
                    AddFacturaPanel.this.printFacturaOdt("Oferta", 1, AddFacturaPanel.this.emitent, false, 0.0, comandaType);
                    if (AddFacturaPanel.this.parentDialog != null) {
                        AddFacturaPanel.this.parentDialog.dispose();
                    }
                }
            }
        });
        if (this.showProformaButton()) {
            ++c.gridx;
            result.add((Component)this.printProforma, c);
        }
        this.temporarButton = new JButton("Comanda ferma");
        this.temporarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                StockLogic.COMANDA_TYPE comandaType = StockLogic.COMANDA_TYPE.EFECTUAT;
                if (VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
                    comandaType = StockLogic.COMANDA_TYPE.COMANDA_FERMA;
                }
                boolean confirmat = true;
                if (AddFacturaPanel.this.factura != null) {
                    confirmat = DialogUtils.confirmDialog(GuiUtils.currentFrame, "Confirmare", "");
                }
                if (confirmat) {
                    AddFacturaPanel.this.salveaza(2, false, 0.0, -1, null, null, comandaType);
                    if (AddFacturaPanel.this.parentDialog != null) {
                        AddFacturaPanel.this.parentDialog.dispose();
                    }
                }
            }
        });
        if (this.showTemporarButton()) {
            c.gridx = 0;
            ++c.gridy;
            result.add((Component)this.temporarButton, c);
        }
        this.avizButton = new JButton("Tipareste aviz");
        this.avizButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddFacturaPanel.this.printFacturaOdt("Aviz de insotire a marfii", 6, AddFacturaPanel.this.emitent, false, 0.0, StockLogic.COMANDA_TYPE.EFECTUAT);
                if (AddFacturaPanel.this.parentDialog != null) {
                    AddFacturaPanel.this.parentDialog.dispose();
                }
            }
        });
        if (this.showAvizButton()) {
            ++c.gridx;
            result.add((Component)this.avizButton, c);
        }
        ++c.gridx;
        this.renunta = new JButton(LangRoAll.renunta);
        this.renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddFacturaPanel.this.resetFields();
                if (AddFacturaPanel.this.parentDialog != null) {
                    AddFacturaPanel.this.parentDialog.dispose();
                }
            }
        });
        result.add((Component)this.renunta, c);
        return result;
    }

    protected boolean showProformaButton() {
        return true;
    }

    protected boolean showFacturaSiChitantaButton() {
        return true;
    }

    protected boolean showTemporarButton() {
        return true;
    }

    protected boolean showAvizButton() {
        return true;
    }

    private void salveaza(int status, boolean chitanta, double totalAchitat, int idLocatie, String cumparator, String facturaPath, StockLogic.COMANDA_TYPE comandaType) {
        Date d2;
        boolean aviz = status == 6;
        Client c = (Client)this.clienti.getSelectedItem();
        if (c == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            return;
        }
        String nr = this.numarIntern.getText();
        int nr1 = 0;
        if (!Validators.correctInteger(nr)) {
            DialogUtils.errorDialog(this.parent, "Numarul facturii este incorect", LangRoAll.nuPotContinua);
            this.setNrFactura();
            this.numarIntern.requestFocus();
            return;
        }
        nr1 = Integer.parseInt(nr);
        Date d = DateUtils.setTimeToDate((Component)this, this.data, this.time);
        if (d == null) {
            return;
        }
        Timestamp data = new Timestamp(d.getTime());
        boolean canAdd = this.facturiLogic.canAddFactura(data);
        if (!canAdd) {
            DialogUtils.errorDialog(this, "Data este mai mica decat ultima validare", LangRoAll.nuPotContinua);
            return;
        }
        int idAgent = -1;
        if (ComboUtils.anythingButAllSelected(this.agenti)) {
            User u = (User)this.agenti.getSelectedItem();
            idAgent = u.getId();
        }
        if ((d2 = DateUtils.setTimeToDate((Component)this, this.scadenta, "23:59")) == null) {
            return;
        }
        Timestamp data2 = new Timestamp(d2.getTime());
        if (data2.before(data)) {
            DialogUtils.errorDialog(this, "Scadenta este mai mica decat data facturii", LangRoAll.nuPotContinua);
            return;
        }
        String nt1 = "";
        if (Validators.correctString(this.numarTipizat.getText())) {
            nt1 = this.numarTipizat.getText();
        } else if (Config.getInstance().getBoolean("facturareRequestNrTipizat")) {
            DialogUtils.errorDialog(this, "Completati numar tipizat", LangRoAll.nuPotContinua);
            this.numarTipizat.requestFocus();
            return;
        }
        String nrAuto = "";
        if (Validators.correctString(this.auto.getText())) {
            nrAuto = this.auto.getText();
        }
        String serie = "";
        if (this.serii.getItemCount() > 0) {
            serie = (String)this.serii.getSelectedItem();
        }
        int idSocietateaNoastra = -1;
        if (this.facturiLogic.isMultipleSocietatiEnabled() && ComboUtils.anythingButAllSelected(this.societati)) {
            ClientPersJuridica societateaNoastra = (ClientPersJuridica)this.societati.getSelectedItem();
            idSocietateaNoastra = societateaNoastra.getIdPersJuridica();
        }
        if (this.factura == null) {
            int idFacturaAdded = this.facturiLogic.addFactura(c.getId(), this.valoareTotala, this.tvaTotal1, this.totalGeneral, serie, nr1, data, this.itemsTm.getData(), idAgent, data2, status, this.orderIds, nt1, nrAuto, aviz, this.whatToPrint, idSocietateaNoastra, comandaType);
            if (chitanta) {
                this.facturiLogic.addPlataLaFactura(totalAchitat, cumparator, idLocatie, nr1, idFacturaAdded);
            }
            if (status == 3) {
                this.facturiLogic.linkFacturaFileInDb(facturaPath, idFacturaAdded);
            }
        } else {
            this.facturiLogic.updateFactura(this.factura, c.getId(), this.valoareTotala, this.tvaTotal1, this.totalGeneral, serie, nr1, data, data2, this.itemsTm.getData(), status, this.factura.getStatusFactura(), nt1, nrAuto, aviz, this.whatToPrint, idSocietateaNoastra, comandaType);
            if (chitanta) {
                this.addPlataLaFactura(totalAchitat, cumparator, idLocatie, this.factura);
            }
            if (status == 3) {
                this.facturiLogic.linkFacturaFileInDb(facturaPath, this.factura.getIdFactura());
            }
        }
        if (VpConfig.getInstance().deleteFacturaFileAfterSave) {
            this.deleteFacturaFile(facturaPath);
        }
        if (status == 2) {
            UsersLogic.getInstance().addBOUserLogCommit("Factura temporara  seria: " + serie + " numar: " + nr1);
        }
        this.resetFields();
    }

    private void addPlataLaFactura(double totalAchitat, String cumparator, int idLocatie, FacturiEmiseView factura) {
        this.facturiLogic.addPlataLaFactura(totalAchitat, cumparator, idLocatie, factura.getNumarIntern(), factura.getIdFactura());
    }

    private void deleteFacturaFile(String facturaPath) {
        boolean b = FileUtils.deleteFile(facturaPath);
    }

    private void printFacturaOdt(String title, int status, User emitent, boolean chitanta, double totalPlatit, StockLogic.COMANDA_TYPE comandaType) {
        String banca;
        String iban;
        String cui;
        String j;
        String cumparator;
        Date d;
        if (this.itemsTm.getData().size() == 0) {
            DialogUtils.errorDialog(this.parent, "Adaugati cel putin un produs", LangRoAll.nuPotContinua);
            return;
        }
        Client client = (Client)this.clienti.getSelectedItem();
        if (client == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            return;
        }
        try {
            d = this.data.getValue();
        }
        catch (ParseException e1) {
            DialogUtils.errorDialog(this.parent, "Data este incorecta", LangRoAll.nuPotContinua);
            return;
        }
        String data = Formatters.DATE_FORMAT_RO.format(d);
        String nt1 = "";
        if (Validators.correctString(this.numarTipizat.getText())) {
            nt1 = this.numarTipizat.getText();
        } else if (Config.getInstance().getBoolean("facturareRequestNrTipizat")) {
            DialogUtils.errorDialog(this, "Completati numar tipizat", LangRoAll.nuPotContinua);
            this.numarTipizat.requestFocus();
            return;
        }
        String serieChitanta = "";
        String numarChitanta = "";
        if (chitanta) {
            Hashtable<String, String> serieSiNumarChitanteForUser = FacturiLogic.getInstance().getSerieSiNumarChitanteForUser(this, emitent.getLogin());
            if (serieSiNumarChitanteForUser != null) {
                serieChitanta = serieSiNumarChitanteForUser.get("serie_chitanta");
                numarChitanta = serieSiNumarChitanteForUser.get("numar_chitanta");
            } else {
                return;
            }
        }
        if (client instanceof ClientPersFizica) {
            ClientPersFizica pf = (ClientPersFizica)client;
            cumparator = pf.getFirstname() + " " + pf.getLastname();
            j = "";
            cui = "";
            iban = "";
            banca = "";
            int idBuletin = pf.getIdBuletin();
            BiCi bici = ClientLogic.getInstance().getBiCiById(idBuletin);
            if (bici != null) {
                j = "CNP: " + bici.getCnp();
                cui = "Bi/Ci: " + bici.getSeria() + " " + bici.getNumarul() + " emis de " + bici.getSectia();
            }
        } else {
            ClientPersJuridica pj = (ClientPersJuridica)client;
            cumparator = pj.getCompanyName();
            j = pj.getJ();
            cui = pj.getCui();
            iban = pj.getBankIban();
            banca = pj.getBank();
        }
        String adresa = client.getAddress1();
        String judet = client.getCity();
        Date d2 = null;
        try {
            d2 = this.scadenta.getValue();
        }
        catch (ParseException e) {
            DialogUtils.errorDialog(this.parent, "Data scadenta este incorecta", LangRoAll.nuPotContinua);
            return;
        }
        String dS = Formatters.DATE_FORMAT_RO.format(d2);
        String timeS = Formatters.TIME_FORMAT.format(d2);
        String cnp = "";
        String nume = "";
        if (emitent != null) {
            cnp = emitent.getCodUnic();
            nume = emitent.getName();
        }
        String nrFactura = this.numarIntern.getText();
        String numeDelegat = "";
        String serBi = "";
        String nrBi = "";
        String politia = "";
        Delegat del = this.forcedDelegat;
        if (del == null) {
            del = (Delegat)this.delegati.getSelectedItem();
        }
        if (del != null) {
            numeDelegat = del.getLabel();
            serBi = del.getSerBi();
            nrBi = del.getNrBi();
            politia = del.getPolitia();
        }
        String seria = "";
        if (this.serii.getItemCount() > 0) {
            seria = (String)this.serii.getSelectedItem();
        }
        String autoS = this.auto.getText();
        int oldStatus = -1;
        if (this.factura != null) {
            oldStatus = this.factura.getStatusFactura();
        }
        if (oldStatus >= 0 && status != oldStatus && !DialogUtils.confirmDialog(this.parent, "Ati modificat seria conform cu operatia solicitata", LangRoAll.confirmare)) {
            return;
        }
        String templateFactura = "template_factura_openoffice.odt";
        String tipFactura = "";
        switch (status) {
            case 1: {
                tipFactura = FacturiLogic.FACTURA_PROFORMA_LABEL;
                templateFactura = "template_oferta_openoffice.odt";
                break;
            }
            case 3: {
                if (chitanta) {
                    templateFactura = "template_factura_cu_chitanta_openoffice.odt";
                }
                tipFactura = "Listata";
                break;
            }
            case 6: {
                tipFactura = "Aviz";
                templateFactura = "template_aviz_openoffice.odt";
            }
        }
        UsersLogic.getInstance().addBOUserLogCommit("Tiparire factura  tip: " + tipFactura + " seria: " + seria + " numar: " + nrFactura);
        FacturaEmitent fe = null;
        if (this.facturiLogic.isMultipleSocietatiEnabled()) {
            ClientPersJuridica cpj = (ClientPersJuridica)this.societati.getSelectedItem();
            if (cpj == null) {
                DialogUtils.errorDialog(this.parent, "Adaugati o societate proprie", LangRoAll.nuPotContinua);
                return;
            }
            fe = FacturiLogic.getFacturaEmitent(cpj);
        }
        Hashtable<String, String> optionsHash = new Hashtable<String, String>();
        if (this.valutaSelectata == null) {
            Valuta valutaPrincipala = ValuteLogic.getInstance().getValutaPrincipala();
            if (valutaPrincipala != null) {
                optionsHash.put("Valuta", valutaPrincipala.toString());
            }
        } else {
            optionsHash.put("Valuta", this.valutaSelectata.toString());
        }
        String facturaPath = this.facturiLogic.tiparesteFacturaOdt(title, cumparator, j, cui, adresa, judet, iban, banca, nrFactura, data, this.itemsTm.getData(), Utils.getString2DecimalsNoTrunc(this.valoareTotala), this.totalTvaText, Utils.getString2DecimalsNoTrunc(this.totalGeneral), dS, this.modPlata.getText(), this.observatii.getText(), numeDelegat, nume, cnp, seria, serBi, nrBi, politia, autoS, timeS, templateFactura, chitanta, Utils.getString2Decimals(totalPlatit), this.facturiLogic.getAfterAddInterface(), client.getId(), fe, Utils.getString2DecimalsNoTrunc(this.valoareTotala2), this.totalTvaText2, Utils.getString2DecimalsNoTrunc(this.totalGeneral2), serieChitanta, numarChitanta, optionsHash);
        if (facturaPath != null) {
            int idLocatie = -1;
            this.salveaza(status, chitanta, totalPlatit, idLocatie, cumparator, facturaPath, comandaType);
        } else {
            DialogUtils.errorDialog(this.parent, "Eroare la tiparire. Consultati logul pt detalii", LangRoAll.eroare);
        }
    }

    private void resetFields() {
        this.initFields();
        this.setNrFactura();
        this.itemsTm.refresh(new Vector());
        this.valoareTotala = 0.0;
        this.tvaTotal1 = 0.0;
        this.totalTvaText = "";
        this.totalGeneral = 0.0;
        this.orderIds.clear();
        this.facturaByNotaHash.clear();
        this.updateTotals();
        this.enableAllButtons(true);
        this.numarTipizat.setText("");
        this.auto.setText("");
        this.adaosImpus.setText("");
        this.faraTva.setSelected(false);
        if (Config.getInstance().getBoolean("facturareModificareDataAutomat")) {
            Date now = new Date();
            this.data.setValue(now);
            this.time.setText(Formatters.TIME_FORMAT.format(now));
            this.scadenta.setValue(now);
        }
        if (this.factura != null) {
            this.factura = null;
            this.action.doAction();
        }
        this.setFaraTvaEnabled();
        this.produse.setSelectedItem(null);
        this.refreshMagaziiCombo(-1);
    }

    private void setNrFactura() {
        if (this.numarFactura == null) {
            String serie = "";
            if (this.serii.getItemCount() > 0) {
                serie = (String)this.serii.getSelectedItem();
            }
            int lastFactura = this.facturiLogic.getLastNrFactura(serie) + 1;
            this.numarIntern.setText(lastFactura + "");
        } else {
            this.numarIntern.setText(this.numarFactura + "");
        }
    }

    private void setNrFactura(String serieFacturaToEdit, int numberFacturaToEdit) {
        String serie = "";
        if (this.serii.getItemCount() > 0) {
            serie = (String)this.serii.getSelectedItem();
        }
        if (serieFacturaToEdit == null || !serie.equalsIgnoreCase(serieFacturaToEdit)) {
            int lastFactura = this.facturiLogic.getLastNrFactura(serie) + 1;
            this.numarIntern.setText(lastFactura + "");
        } else {
            this.numarIntern.setText(numberFacturaToEdit + "");
        }
    }

    private void setFaraTvaEnabled() {
        if (this.itemsTm.getData().size() > 0) {
            this.faraTva.setEnabled(false);
        } else {
            this.faraTva.setEnabled(true);
        }
    }

    private void addEntry() {
        double cant = 0.0;
        double ppu = 0.0;
        Object selectedItem = this.produse.getSelectedItem();
        if (selectedItem == null || !(selectedItem instanceof Product)) {
            DialogUtils.errorDialog(this.parent, Utils.getTranslation(LangRoAll.alegetiUnProdus, new String[0]), LangRoAll.nuPotContinua);
            return;
        }
        Product product = (Product)selectedItem;
        String productName = this.produsFacturaLine1.getText();
        String productLine2 = this.produsFacturaLine2.getText();
        String unitName = this.umText.getText();
        String cantS = this.cantitate.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this.parent, Utils.getTranslation(LangRoAll.cantitateaNaN, new String[0]), LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        cant = Utils.parseDouble(cantS);
        String pretS = this.pretCuTva.getText();
        if (!Validators.correctDouble(pretS)) {
            DialogUtils.errorDialog(this.parent, Utils.getTranslation(LangRoAll.pretulNaN, new String[0]), LangRoAll.nuPotContinua);
            this.pretCuTva.requestFocus();
            return;
        }
        ppu = Utils.parseDouble(pretS);
        int idMagazie = 0;
        String magazie = LangRoAll.faraDescarcare;
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            MagazieDisponibilBean bean = (MagazieDisponibilBean)this.magazii.getSelectedItem();
            Magazie m = bean.getMagazie();
            idMagazie = m.getId();
            magazie = m.getLabel();
        }
        double ppuFaraTva = 0.0;
        double tva = 0.0;
        if (this.faraTva.isSelected()) {
            ppuFaraTva = ppu;
            tva = 0.0;
        } else {
            Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(product.getIdCategorie());
            Tva t = TvaLogic.getInstance().getTvaById(cat.getIdTva());
            double tvaNoi = t.getCota();
            double valoareFaraTva = cant * ppu;
            tva = FloatUtils.getTva(valoareFaraTva, tvaNoi);
            ppuFaraTva = FloatUtils.getValoareFaraTva(ppu, tvaNoi);
        }
        FacturaItemView fi = this.facturiLogic.buildFacturaItemView(cant, idMagazie, product.getId(), product.getIdCategorie(), magazie, ppu, ppuFaraTva, tva, productName, unitName, productLine2);
        fi.setProdusLine1(productName);
        Vector entries = this.itemsTm.getData();
        entries.add(fi);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
        this.umText.setText(unitName);
        this.setFaraTvaEnabled();
    }

    public void addNotaEntries(Vector<NoteView> notaEntries, Client client) {
        Vector<Magazie> magazii = StockLogic.getInstance().getMagazii();
        for (int i = 0; i < notaEntries.size(); ++i) {
            NoteView o = notaEntries.elementAt(i);
            int idMagazie = 0;
            String magazie = LangRoAll.faraDescarcare;
            Magazie m = o.getMagazieForFacturare();
            if (m != null) {
                idMagazie = m.getId();
                magazie = m.getLabel();
            }
            this.addNotaEntry(o, magazie, idMagazie, client, null);
        }
        this.populateWithDiscount();
        this.setFaraTvaEnabled();
        this.updateTotals();
    }

    public void populateWithDiscount() {
        for (Double aDouble : this.discountHash.keySet()) {
            FacturaItemView e = this.discountHash.get(aDouble);
            e.setValoare(-e.getValoare());
            this.itemsTm.getData().add(e);
        }
        this.discountHash.clear();
        this.updateTotals();
    }

    public void sortEntries() {
        Collections.sort(this.itemsTm.getData(), new Comparator(){

            public int compare(Object o1, Object o2) {
                FacturaItemView f1 = (FacturaItemView)o1;
                FacturaItemView f2 = (FacturaItemView)o2;
                return f1.getProdus().compareToIgnoreCase(f2.getProdus());
            }
        });
    }

    public void addNotaEntry(NoteView nv, String magazie, int idMagazie, Client client, Vector<Integer> forcedOrderIds) {
        double cotaTva = this.facturiLogic.getDataProvider().getCotaTvaForProduct(nv.getIdProdus());
        int discountProductCode = VpConfig.getInstance().facturareCodProdusDiscount;
        boolean workWithProductDiscount = false;
        if (discountProductCode != -1) {
            workWithProductDiscount = true;
        }
        double cantitate = nv.getCantitate();
        String produs = nv.getProdus();
        String produsLine2 = "";
        if (Validators.correctString(nv.getModPreparare())) {
            produsLine2 = nv.getModPreparare();
        }
        double discountNv = nv.getDiscount();
        double discountFaraTva = discountNv / (1.0 + cotaTva);
        double tvaDiscount = discountNv - discountFaraTva;
        double totalCuTva = nv.getSuma();
        if (workWithProductDiscount) {
            totalCuTva += discountNv;
        }
        double ppuCuTva = totalCuTva / cantitate;
        Categorie c = this.facturiLogic.getDataProvider().getCategorieForProduct(nv.getIdProdus());
        double ppuFaraTva = ppuCuTva / (1.0 + cotaTva);
        double valTva = (ppuCuTva - ppuFaraTva) * cantitate;
        FacturaItemView fi = this.facturiLogic.buildFacturaItemView(cantitate, idMagazie, nv.getIdProdus(), c.getId(), magazie, ppuCuTva, ppuFaraTva, valTva, produs, "Buc", produsLine2);
        FacturaItemView discountItem = null;
        if (workWithProductDiscount) {
            Product discountProduct = NomeclaturaLogic.getInstance().getProductByCod(discountProductCode);
            discountItem = this.facturiLogic.buildFacturaItemView(-1.0, idMagazie, discountProduct.getId(), c.getId(), magazie, -discountNv, -discountFaraTva, -tvaDiscount, "Discount - TVA " + cotaTva, "Buc", "");
        }
        String key = fi.getIdProduct() + "_" + fi.getPpuCuTva();
        FacturaItemView fiw = (FacturaItemView)this.facturaByNotaHash.get(key);
        if (workWithProductDiscount) {
            FacturaItemView discountItemInHash = this.discountHash.get(cotaTva);
            if (discountItemInHash != null) {
                discountItemInHash.setPpuFaraTva(discountItemInHash.getPpuFaraTva() + discountItem.getPpuFaraTva());
                discountItemInHash.setValoare(discountItemInHash.getValoare() + discountItem.getValoare());
                discountItemInHash.setValoareTva(discountItemInHash.getValoareTva() + discountItem.getValoareTva());
            } else if (discountNv > 0.0) {
                this.discountHash.put(cotaTva, discountItem);
            }
        }
        if (fiw != null) {
            fiw.setCantitate(fiw.getCantitate() + fi.getCantitate());
            fiw.setValoare(fiw.getValoare() + fi.getValoare());
            fiw.setValoareTva(fiw.getValoareTva() + fi.getValoareTva());
        } else {
            Vector entries = this.itemsTm.getData();
            entries.add(fi);
            this.facturaByNotaHash.put(key, fi);
        }
        this.itemsTm.fireTableDataChanged();
        if (forcedOrderIds != null) {
            for (Integer idOrder : forcedOrderIds) {
                if (this.orderIds.contains(idOrder)) continue;
                this.orderIds.add(idOrder);
            }
        } else {
            Integer idOrder = nv.getIdOrder();
            if (idOrder > 0 && !this.orderIds.contains(idOrder)) {
                this.orderIds.add(idOrder);
            }
        }
        if (client != null) {
            this.clienti.setSelectedItem(client);
        }
        this.initFields();
        this.updateTotals();
        this.setFaraTvaEnabled();
    }

    public void addFacturaItem(FacturaItemView fi) {
        Vector entries = this.itemsTm.getData();
        entries.add(fi);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
        this.setFaraTvaEnabled();
    }

    private void updateTotals() {
        String c;
        this.valoareTotala = 0.0;
        this.valoareTotala2 = 0.0;
        this.tvaTotal1 = 0.0;
        this.tvaTotal2 = 0.0;
        Hashtable<String, Double> tvas1 = new Hashtable<String, Double>();
        Hashtable<String, Double> tvas2 = new Hashtable<String, Double>();
        for (int i = 0; i < this.itemsTm.getData().size(); ++i) {
            FacturaItemView e = (FacturaItemView)this.itemsTm.getObjectAt(i);
            this.valoareTotala += e.getValoare();
            this.valoareTotala2 += e.getValoare2();
            String cota = Utils.getString2DecimalsNoTrunc(e.getCotaTva());
            Double totalPerCota = (Double)tvas1.get(cota);
            double totalNow = e.getValoareTva();
            if (totalPerCota != null) {
                totalNow += totalPerCota.doubleValue();
            }
            tvas1.put(cota, totalNow);
            Double totalPerCota2 = (Double)tvas2.get(cota);
            double totalNow2 = e.getValoareTva2();
            if (totalPerCota2 != null) {
                totalNow2 += totalPerCota2.doubleValue();
            }
            tvas2.put(cota, totalNow2);
            this.tvaTotal1 += e.getValoareTva();
            this.tvaTotal2 += e.getValoareTva2();
            this.totalGeneral = this.valoareTotala + this.tvaTotal1;
            this.totalGeneral2 = this.valoareTotala2 + this.tvaTotal2;
            System.out.println("Valoare : " + e.getValoare() + " tva : " + e.getValoareTva() + " valoare cu tva : " + e.getValoareCuTva() + " valoareTotala : " + this.valoareTotala + " tvaTotal : " + this.tvaTotal1 + " totalGeneral : " + this.totalGeneral);
        }
        this.totalGeneral = this.valoareTotala + this.tvaTotal1;
        this.totalGeneral2 = this.valoareTotala2 + this.tvaTotal2;
        this.totalTvaText = "";
        this.totalTvaText2 = "";
        for (String cota : tvas1.keySet()) {
            double valoare;
            c = cota.substring(cota.lastIndexOf(46) + 1);
            if (c.startsWith("0")) {
                c = c.substring(1);
            }
            if ((valoare = ((Double)tvas1.get(cota)).doubleValue()) == 0.0) continue;
            this.totalTvaText = this.totalTvaText + c + "% : " + Utils.getString2Decimals(valoare) + " ; ";
        }
        if (tvas1.size() > 0 && this.totalTvaText.length() >= 3) {
            this.totalTvaText = this.totalTvaText.substring(0, this.totalTvaText.length() - 3) + " ; ";
        }
        for (String cota : tvas2.keySet()) {
            double valoare;
            c = cota.substring(cota.lastIndexOf(46) + 1);
            if (c.startsWith("0")) {
                c = c.substring(1);
            }
            if ((valoare = ((Double)tvas2.get(cota)).doubleValue()) == 0.0) continue;
            this.totalTvaText2 = this.totalTvaText2 + c + "% : " + Utils.getString2Decimals(valoare) + " ; ";
        }
        if (tvas2.size() > 0 && this.totalTvaText2.length() >= 3) {
            this.totalTvaText2 = this.totalTvaText2.substring(0, this.totalTvaText2.length() - 3) + " ; ";
        }
        this.totalTvaText = this.totalTvaText + "TOTAL = " + Utils.getString2Decimals(this.tvaTotal1);
        this.totalTvaText2 = this.totalTvaText2 + "TOTAL = " + Utils.getString2Decimals(this.tvaTotal2);
        this.totalFactura.setText(Utils.getString2Decimals(this.valoareTotala));
        this.totalTva.setText(this.totalTvaText);
        this.totalFacturaCuTva.setText(Utils.getString2Decimals(this.totalGeneral));
        String nrBonText = "";
        for (int i = 0; i < this.orderIds.size(); ++i) {
            Integer id = (Integer)this.orderIds.elementAt(i);
            nrBonText = nrBonText + id;
            if (i >= this.orderIds.size() - 1) continue;
            nrBonText = nrBonText + ",";
        }
        this.nrBon.setText(nrBonText);
    }

    private JPanel getNirTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FacturaItemView e = (FacturaItemView)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return "<html><b>" + e.getProdus() + "</b><br/><i>" + e.getProdusLine2Full() + "</i></html>";
                    }
                    case 1: {
                        return e.getUm();
                    }
                    case 2: {
                        return Utils.getString3Decimals(e.getCantitate());
                    }
                    case 3: {
                        return e.getMagazie();
                    }
                    case 4: {
                        return Utils.getStringXDecimals(e.getPpuFaraTva(), VpConfig.getInstance().facturareRoundDecimals);
                    }
                    case 5: {
                        return Utils.getString2Decimals(e.getValoare());
                    }
                    case 6: {
                        return Utils.getString2Decimals(e.getValoareTva());
                    }
                }
                return null;
            }
        });
        this.table = new JTable(this.itemsTm);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                final int selRow = source.rowAtPoint(e.getPoint());
                if (AddFacturaPanel.this.factura == null || AddFacturaPanel.this.factura.getStatusFactura() == 1 || AddFacturaPanel.this.factura.getStatusFactura() == 2 || AddFacturaPanel.this.factura.getStatusFactura() == 6 || AddFacturaPanel.this.allowEditGlobal) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                    modifica.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            FacturaItemView item = (FacturaItemView)AddFacturaPanel.this.itemsTm.getObjectAt(selRow);
                            AddFacturaPanel.this.completeEntry(item);
                            AddFacturaPanel.this.eraseEntry(selRow);
                        }
                    });
                    JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                    sterge.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            if (DialogUtils.confirmDialog(AddFacturaPanel.this.parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                                AddFacturaPanel.this.eraseEntry(selRow);
                            }
                        }
                    });
                    popup.add(modifica);
                    popup.add(sterge);
                    popup.setInvoker(AddFacturaPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(this.table);
        result.add((Component)scroll, c);
        GuiUtils.updateJTableRowSize(this.table, VpConfig.getInstance().touchTableFontSize);
        return result;
    }

    private void completeEntry(FacturaItemView view) {
        Product p = NomeclaturaLogic.getInstance().getProductById(view.getIdProduct());
        this.produse.setSelectedItem(p);
        this.pretCuTva.setText(Utils.getString2Decimals(view.getPpuCuTva()));
        this.produsFacturaLine2.setText(view.getProdusLine2Full());
        this.produsFacturaLine1.setText(view.getProdusLine1());
        this.cantitate.setText(Utils.getString3Decimals(view.getCantitate()));
        this.umText.setText(view.getUm());
        int idMagazie = view.getIdMagazie();
        if (idMagazie == 0) {
            this.magazii.setSelectedItem("All");
        } else {
            Magazie m = StockLogic.getInstance().getMagazieById(idMagazie);
            MagazieDisponibilBean mdb = new MagazieDisponibilBean();
            mdb.setMagazie(m);
            this.magazii.setSelectedItem(mdb);
        }
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
        this.setFaraTvaEnabled();
    }

    public void setFacturaToEdit(FacturiEmiseView fev) {
        if (this.facturiLogic.isMultipleSocietatiEnabled()) {
            int idSoc = fev.getIdSocietateaNoastra();
            ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idSoc);
            if (cpj != null) {
                this.societati.setSelectedItem(cpj);
            }
        }
        boolean allowEdit = false;
        if (fev.getStatusFactura() == 3 && this.allowEditGlobal) {
            allowEdit = true;
            UsersLogic.getInstance().addBOUserLogCommit("Modificare factura  serie numar: " + fev.getSerieNumar());
        }
        this.factura = fev;
        Client c = ClientLogic.getInstance().getClientById(fev.getIdClient());
        this.clienti.setSelectedItem(c);
        this.numarIntern.setText(fev.getNumarIntern() + "");
        this.numarTipizat.setText(fev.getNumarTipizat());
        this.auto.setText(fev.getNumarAuto());
        this.serii.setSelectedItem(fev.getSerie());
        this.data.setValue((Date)this.factura.getData());
        this.time.setText(DateUtils.getTimeFromDate(this.factura.getData()));
        this.scadenta.setValue((Date)fev.getScadenta());
        Vector newData = this.facturiLogic.getFacturiItems(fev.getIdFactura());
        this.itemsTm.refresh(newData);
        this.orderIds.clear();
        this.facturaByNotaHash.clear();
        this.orderIds.addAll(fev.getOrderIds());
        this.updateTotals();
        this.setButtonStatus(fev, allowEdit);
        this.adaosImpus.setText("");
        this.faraTva.setSelected(false);
        this.setFaraTvaEnabled();
        this.observatii.setText("");
        this.modPlata.setText("");
    }

    private void enableProdusPanel(boolean status) {
        this.adauga.setEnabled(status);
        this.produse.setEnabled(status);
        this.cantitate.setEnabled(status);
        this.produsFacturaLine2.setEnabled(status);
        this.produsFacturaLine1.setEnabled(status);
        this.pretCuTva.setEnabled(status);
        this.umText.setEnabled(status);
        this.pretFaraTva.setEnabled(status);
        this.magazii.setEnabled(status);
        this.adauga.setEnabled(status);
    }

    private void enableSocietatiPanel(boolean status) {
        this.societati.setEnabled(status);
    }

    private void enableFacturaPanel(boolean status) {
        this.clienti.setEnabled(status);
        this.numarIntern.setEnabled(status);
        this.time.setEnabled(status);
        this.data.setEnabled(status);
        this.scadenta.setEnabled(status);
        this.agenti.setEnabled(status);
        this.observatii.setEnabled(status);
        this.credit.setEnabled(status);
        this.modPlata.setEnabled(status);
        this.adaugaDelegat.setEnabled(status);
        this.serii.setEnabled(status);
        this.numarIntern.setEnabled(status);
        this.numarTipizat.setEnabled(status);
        this.auto.setEnabled(status);
        this.faraTva.setEnabled(status);
    }

    private void setButtonStatus(FacturiEmiseView fev, boolean allowEdit) {
        this.enableAllButtons(false);
        switch (fev.getStatusFactura()) {
            case 1: {
                this.printProforma.setEnabled(true);
                this.temporarButton.setEnabled(true);
                this.printFactura.setEnabled(true);
                this.avizButton.setEnabled(true);
                this.enableFacturaPanel(true);
                this.enableProdusPanel(true);
                this.enableSocietatiPanel(true);
                break;
            }
            case 2: {
                this.temporarButton.setEnabled(true);
                this.avizButton.setEnabled(true);
                this.printProforma.setEnabled(true);
                this.printFactura.setEnabled(true);
                this.enableFacturaPanel(true);
                this.enableProdusPanel(true);
                this.enableSocietatiPanel(true);
                break;
            }
            case 3: {
                this.printFactura.setEnabled(true);
                if (!allowEdit) break;
                this.temporarButton.setEnabled(true);
                this.avizButton.setEnabled(true);
                this.printProforma.setEnabled(true);
                this.enableFacturaPanel(true);
                this.enableProdusPanel(true);
                this.enableSocietatiPanel(true);
                break;
            }
            case 4: {
                this.printFactura.setEnabled(true);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.avizButton.setEnabled(true);
                this.printFactura.setEnabled(true);
                this.enableFacturaPanel(true);
                this.enableProdusPanel(true);
                this.enableSocietatiPanel(true);
            }
        }
    }

    private void enableAllButtons(boolean status) {
        this.enableFacturaPanel(status);
        this.enableProdusPanel(status);
        this.enableSocietatiPanel(status);
        this.printProforma.setEnabled(status);
        this.temporarButton.setEnabled(status);
        this.printFactura.setEnabled(status);
        this.avizButton.setEnabled(status);
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public void setModPlata(String s) {
        this.modPlata.setText(s);
    }

    public void enableButtonsBasedOnCriteria(Hashtable criteria) {
        boolean ofertaTrue = criteria.get("Oferta") != null;
        boolean comandaFermaTrue = criteria.get("Comanda ferma") != null;
        boolean b = criteria.get("Active") != null;
        this.printProforma.setEnabled(ofertaTrue);
        this.temporarButton.setEnabled(comandaFermaTrue);
        this.printFactura.setEnabled(b);
        this.printFacturaCuChitanta.setEnabled(b);
        this.avizButton.setEnabled(false);
        Object o = criteria.get("Numar oferta");
        if (o != null) {
            this.numarFactura = (Integer)o;
            this.setNrFactura();
        }
        this.enableFacturaPanel(b);
        Object ao = criteria.get("Valuta");
        if (ao != null) {
            this.valutaSelectata = (Valuta)ao;
        }
    }

    public void updateItemsPriceValuta() {
        if (this.valutaSelectata != null) {
            Vector data = this.itemsTm.getData();
            FacturiLogic.getInstance().updatePricesFacturaItemViewValuta(data, this.valutaSelectata);
            this.itemsTm.refresh(data);
            this.updateTotals();
        }
    }
}

