/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.presentation.Fig;
import ro.atreides.gef.DBbridge;
import ro.atreides.gef.FigRectWithText;
import ro.atreides.gef.FigRestaurant;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.utils.gui.DiagramRestaurantInputDialog;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public class ModeCreateFigRectWithText
extends ModeCreate {
    protected DataInterface dataInterface;
    private int tip;

    public ModeCreateFigRectWithText(DataInterface inteface, int tip) {
        this.dataInterface = inteface;
        this._defaultWidth = 45;
        this._defaultHeight = 25;
        this.tip = tip;
    }

    @Override
    public String instructions() {
        return "Drag to define a text rectangle, then type";
    }

    @Override
    public Fig createNewItem(MouseEvent e, int snapX, int snapY) {
        return new FigRectWithText(this.dataInterface, snapX, snapY, 70, 70);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this.editor.damaged(this._newItem);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBbridge modifier = ModeCreateFigRectWithText.this.dataInterface.getDiagramModifier();
                    DiagramRestaurantInputDialog dialog = new DiagramRestaurantInputDialog(modifier.getMainFrame(), true, modifier.getMainFrame(), LangRoAll.denumire, "", 1, false, "");
                    String name = dialog.getInput();
                    String nrLocuri = dialog.getNrLocuri();
                    int nrL = 1;
                    if (Validators.correctInteger(nrLocuri)) {
                        nrL = Integer.parseInt(nrLocuri);
                    }
                    boolean virtuala = dialog.isVirtuala();
                    String fullDetails = dialog.getDetalii();
                    if (name != null && modifier.add(name, ModeCreateFigRectWithText.this.tip, nrL, virtuala, fullDetails)) {
                        ((FigRestaurant)((Object)ModeCreateFigRectWithText.this._newItem)).setNume(name);
                        ((FigRestaurant)((Object)ModeCreateFigRectWithText.this._newItem)).setNrLocuri(nrL);
                        ((FigRestaurant)((Object)ModeCreateFigRectWithText.this._newItem)).setVirtuala(virtuala);
                        ((FigRestaurant)((Object)ModeCreateFigRectWithText.this._newItem)).setFullDetails(fullDetails);
                        ModeCreateFigRectWithText.this.editor.add(ModeCreateFigRectWithText.this._newItem);
                        ModeCreateFigRectWithText.this.editor.getSelectionManager().select(ModeCreateFigRectWithText.this._newItem);
                        ModeCreateFigRectWithText.this._newItem = null;
                    } else {
                        ModeCreateFigRectWithText.this._newItem.deleteFromModel();
                    }
                    ModeCreateFigRectWithText.this.editor.damageAll();
                    ModeCreateFigRectWithText.this.done();
                }
            });
        }
        me.consume();
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

