/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.gui;

import java.awt.FileDialog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.CmdOpen;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.data.DataInterfaceSetter;

public class CmdOpenModified
extends CmdOpen
implements FilenameFilter {
    private DataInterface dataInterface;
    private Editor editor;

    public CmdOpenModified(DataInterface data, Editor editor) {
        super("Open");
        this.dataInterface = data;
        this.editor = editor;
    }

    public CmdOpenModified(DataInterface data, Editor editor, String filterPattern) {
        this(data, editor);
        this.setArg("filterPattern", filterPattern);
    }

    @Override
    public void doIt() {
        try {
            FileDialog fd = new FileDialog(this.editor.findFrame(), "Open...", 0);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Reading " + path + filename + "...");
                FileInputStream fis = new FileInputStream(path + filename);
                ObjectInputStream s = new ObjectInputStream(fis);
                List figs = (List)s.readObject();
                if (fis != null) {
                    fis.close();
                }
                Globals.showStatus("Read " + path + filename);
                this.deleteAllFigures();
                Layer lay = this.editor.getLayerManager().getActiveLayer();
                for (Fig fig : figs) {
                    if (fig instanceof DataInterfaceSetter) {
                        ((DataInterfaceSetter)((Object)fig)).setDataInterface(this.dataInterface);
                    }
                    lay.add(fig);
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("got an FileNotFoundException");
        }
        catch (ClassNotFoundException e) {
            System.out.println("got an ClassNotFoundException");
        }
        catch (IOException e) {
            System.out.println("got an IOException");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void deleteAllFigures() {
        Vector vector = new Vector(this.editor.getLayerManager().getContents());
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Fig fig = (Fig)iterator.next();
            iterator.remove();
            fig.deleteFromModel();
        }
    }
}

