/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.gui;

import java.awt.FileDialog;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.tigris.gef.base.CmdSave;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdSaveModified
extends CmdSave {
    public CmdSaveModified() {
        super("Save");
    }

    public CmdSaveModified(String filterPattern) {
        this();
        this.setArg("filterPattern", filterPattern);
    }

    @Override
    public void doIt() {
        try {
            Editor ce = Globals.curEditor();
            FileDialog fd = new FileDialog(ce.findFrame(), "Save Diagram", 1);
            fd.setFilenameFilter(this);
            fd.setDirectory(Globals.getLastDirectory());
            fd.setVisible(true);
            String filename = fd.getFile();
            String path = fd.getDirectory();
            Globals.setLastDirectory(path);
            if (filename != null) {
                Globals.showStatus("Writing " + path + filename + "...");
                FileOutputStream f = new FileOutputStream(path + filename);
                ObjectOutputStream s = new ObjectOutputStream(f);
                ce.preSave();
                s.writeObject(ce.getLayerManager().getContents());
                ce.postSave();
                Globals.showStatus("Wrote " + path + filename);
                f.close();
            }
        }
        catch (FileNotFoundException ignore) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException ignore) {
            System.out.println("got an IOException");
            ignore.printStackTrace();
        }
    }
}

