/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.xml;

import java.awt.Color;
import java.util.Vector;
import org.tigris.gef.presentation.Fig;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.gef.FigCircleWithText;
import ro.atreides.gef.FigComment;
import ro.atreides.gef.FigLineModified;
import ro.atreides.gef.FigRectWithText;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.utils.gui.Validators;

public class XmlHandler
extends DefaultHandler {
    private DataInterface dataInterface;
    private Vector<Fig> vector = new Vector();

    public XmlHandler(DataInterface dataInterface) {
        this.dataInterface = dataInterface;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equalsIgnoreCase("table")) {
                this.addTable(this.vector, this.dataInterface, attributes);
            } else if (qName.equalsIgnoreCase("comment")) {
                this.addComment(this.vector, this.dataInterface, attributes);
            } else if (qName.equalsIgnoreCase("line")) {
                this.addLine(this.vector, attributes);
            } else {
                System.out.println("<" + qName + "> from xml is unknown");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    private void addTable(Vector vector, DataInterface dataInterface, Attributes attributes) {
        try {
            String fullDetails;
            String type = attributes.getValue("type");
            String name = attributes.getValue("name");
            String locs = attributes.getValue("locuri");
            int locuri = 1;
            if (Validators.correctInteger(locs)) {
                locuri = Integer.parseInt(locs);
            }
            if ((fullDetails = attributes.getValue("fullDetails")) == null) {
                fullDetails = "";
            }
            String virtS = attributes.getValue("virtuala");
            boolean virtuala = false;
            if (virtS != null) {
                virtuala = Boolean.valueOf(virtS);
            }
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            int width = Integer.parseInt(attributes.getValue("width"));
            int height = Integer.parseInt(attributes.getValue("height"));
            if (type.equals("patrat")) {
                FigRectWithText fig = new FigRectWithText(dataInterface, x, y, width, height);
                fig.setNume(name);
                fig.setNrLocuri(locuri);
                fig.setVirtuala(virtuala);
                fig.setFullDetails(fullDetails);
                vector.add(fig);
            } else if (type.equals("circle")) {
                FigCircleWithText fig = new FigCircleWithText(dataInterface, x, y, width, height);
                fig.setNume(name);
                fig.setNrLocuri(locuri);
                fig.setVirtuala(virtuala);
                fig.setFullDetails(fullDetails);
                vector.add(fig);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addLine(Vector vector, Attributes attributes) {
        try {
            int x1 = Integer.parseInt(attributes.getValue("x"));
            int y1 = Integer.parseInt(attributes.getValue("y"));
            int x2 = Integer.parseInt(attributes.getValue("x2"));
            int y2 = Integer.parseInt(attributes.getValue("y2"));
            vector.add(new FigLineModified(x1, y1, x2, y2));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addComment(Vector vector, DataInterface dataInterface, Attributes attributes) {
        try {
            String text = attributes.getValue("text");
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            int width = Integer.parseInt(attributes.getValue("width"));
            int height = Integer.parseInt(attributes.getValue("height"));
            int fontSize = Integer.parseInt(attributes.getValue("fontsize"));
            Color backColor = new Color(Integer.parseInt(attributes.getValue("background")));
            Color forgColor = new Color(Integer.parseInt(attributes.getValue("foreground")));
            FigComment fig = new FigComment(dataInterface, x, y, width, height);
            fig.setForeground(forgColor);
            fig.setBackground(backColor);
            fig.setText(text);
            fig.setTextFontSize(fontSize);
            vector.add(fig);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Vector getData() {
        return this.vector;
    }
}

