/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.gef.utils.xml;

import java.awt.Color;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.presentation.Fig;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.gef.FigCircleWithText;
import ro.atreides.gef.FigComment;
import ro.atreides.gef.FigLineModified;
import ro.atreides.gef.FigRectWithText;
import ro.atreides.gef.data.DataInterface;
import ro.atreides.gef.utils.xml.XmlHandler;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Utils;

public class XmlUtils {
    public static Vector getFigures(String filename, DataInterface dataInterface) {
        XmlHandler handler = new XmlHandler(dataInterface);
        try {
            Utils.importXml((DefaultHandler)handler, filename);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return handler.getData();
    }

    public static boolean saveFigures(String filename, Editor editor) {
        try {
            String xml = XmlUtils.getXml(editor);
            FileUtils.writeTextToFile(filename, xml);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String getXml(Editor editor) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<graph>\n");
        Vector vector = new Vector(editor.getLayerManager().getContents());
        for (Fig fig : vector) {
            Fig f;
            if (fig instanceof FigRectWithText) {
                f = (FigRectWithText)fig;
                XmlUtils.addTable(buffer, "patrat", ((FigRectWithText)f).getNume(), ((FigRectWithText)f).getNrLocs(), f.getX(), f.getY(), f.getWidth(), f.getHeight(), ((FigRectWithText)f).isVirtuala(), ((FigRectWithText)f).getFullDetails());
                continue;
            }
            if (fig instanceof FigCircleWithText) {
                f = (FigCircleWithText)fig;
                XmlUtils.addTable(buffer, "circle", ((FigCircleWithText)f).getNume(), ((FigCircleWithText)f).getNrLocs(), f.getX(), f.getY(), f.getWidth(), f.getHeight(), ((FigCircleWithText)f).isVirtuala(), ((FigCircleWithText)f).getFullDetails());
                continue;
            }
            if (fig instanceof FigLineModified) {
                FigLineModified figLine = (FigLineModified)fig;
                XmlUtils.addLine(buffer, figLine.getX1(), figLine.getY1(), figLine.getX2(), figLine.getY2());
                continue;
            }
            if (!(fig instanceof FigComment)) continue;
            f = (FigComment)fig;
            XmlUtils.addComment(buffer, ((FigComment)f).getText(), f.getX(), f.getY(), f.getWidth(), f.getHeight(), ((FigComment)f).getFontSize(), ((FigComment)f).getForegroundColor(), ((FigComment)f).getBackgroundColor());
        }
        buffer.append("</graph>");
        return buffer.toString();
    }

    private static void addAttribute(StringBuffer buffer, String type, String value) {
        buffer.append(" ");
        buffer.append(type);
        buffer.append("=");
        buffer.append("\"");
        buffer.append(value);
        buffer.append("\"");
    }

    private static void addTable(StringBuffer buffer, String type, String name, int locuri, int x, int y, int width, int height, boolean virtuala, String fullDetails) {
        buffer.append("<");
        buffer.append("table");
        XmlUtils.addAttribute(buffer, "type", type);
        XmlUtils.addAttribute(buffer, "name", name);
        XmlUtils.addAttribute(buffer, "locuri", "" + locuri);
        XmlUtils.addAttribute(buffer, "virtuala", "" + virtuala);
        XmlUtils.addAttribute(buffer, "fullDetails", "" + fullDetails);
        XmlUtils.addAttribute(buffer, "x", x + "");
        XmlUtils.addAttribute(buffer, "y", y + "");
        XmlUtils.addAttribute(buffer, "width", width + "");
        XmlUtils.addAttribute(buffer, "height", height + "");
        buffer.append("/>\n");
    }

    private static void addComment(StringBuffer buffer, String text, int x, int y, int width, int height, int fontsize, Color foregroundColor, Color backgroundColor) {
        buffer.append("<");
        buffer.append("comment");
        XmlUtils.addAttribute(buffer, "text", text);
        XmlUtils.addAttribute(buffer, "x", x + "");
        XmlUtils.addAttribute(buffer, "y", y + "");
        XmlUtils.addAttribute(buffer, "width", width + "");
        XmlUtils.addAttribute(buffer, "height", height + "");
        XmlUtils.addAttribute(buffer, "fontsize", fontsize + "");
        XmlUtils.addAttribute(buffer, "foreground", foregroundColor.getRGB() + "");
        XmlUtils.addAttribute(buffer, "background", backgroundColor.getRGB() + "");
        buffer.append("/>\n");
    }

    private static void addLine(StringBuffer buffer, int x, int y, int x2, int y2) {
        buffer.append("<");
        buffer.append("line");
        XmlUtils.addAttribute(buffer, "x", x + "");
        XmlUtils.addAttribute(buffer, "y", y + "");
        XmlUtils.addAttribute(buffer, "x2", x2 + "");
        XmlUtils.addAttribute(buffer, "y2", y2 + "");
        buffer.append("/>\n");
    }
}

