/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.jocuri;

import ro.atreides.jocuri.AlertListener;
import ro.atreides.jocuri.JocuriLogic;
import ro.atreides.jocuri.MasaJocuri;

public class JocuriThread
extends Thread {
    private long timeout;
    private long alertBeforeMillis;
    private JocuriLogic logic;
    private int idTable;
    private boolean stop = false;
    private AlertListener listener;

    public JocuriThread(JocuriLogic logic, long timeout, int idTable, long alertBefore, AlertListener listener) {
        this.logic = logic;
        this.timeout = timeout;
        this.idTable = idTable;
        this.alertBeforeMillis = alertBefore;
        this.listener = listener;
        this.setName("Jocuri masa " + idTable);
    }

    @Override
    public void run() {
        boolean alertBeforeTriggered = false;
        while (!this.stop) {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            MasaJocuri m = this.logic.getMasaById(this.idTable);
            if (m.getStop() < now) {
                this.listener.alertStop(m.getLabel(), this.idTable);
                continue;
            }
            if (m.getStop() < now + this.alertBeforeMillis) {
                int minutesRem = (int)((m.getStop() - now) / 1000L / 60L);
                if (alertBeforeTriggered) continue;
                this.listener.alertWarning(minutesRem, m.getLabel(), this.idTable);
                alertBeforeTriggered = true;
                continue;
            }
            alertBeforeTriggered = false;
        }
    }

    public void stopRunning() {
        this.stop = true;
    }
}

