/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.jocuri.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.jocuri.MasaJocuri;
import ro.atreides.utils.db.DaoInterface;

public class JocuriDao
implements DaoInterface {
    private PreparedStatement addTable;
    private PreparedStatement deleteTable;
    private PreparedStatement startTable;
    private PreparedStatement stopTable;
    private PreparedStatement addTracking;
    private PreparedStatement getAllTables;
    private PreparedStatement getTableById;
    private PreparedStatement updateTable;
    private Connection connection;

    public JocuriDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addTable = this.connection.prepareStatement("insert into game_tables(label, status) values (?, 1)");
        this.deleteTable = this.connection.prepareStatement("update game_tables set status = 2 where id = ?");
        this.startTable = this.connection.prepareStatement("update game_tables set start = ?, durata = ? where id = ?");
        this.stopTable = this.connection.prepareStatement("update game_tables set start = -1, durata = -1 where id = ?");
        this.addTracking = this.connection.prepareStatement("insert into game_tracking(id_table, start, durata ) values (?, ?, ?)");
        this.getAllTables = this.connection.prepareStatement("select * from game_tables where status = 1");
        this.getTableById = this.connection.prepareStatement("select * from game_tables where id = ?");
        this.updateTable = this.connection.prepareStatement("update game_tables set durata = durata + ? where id = ?");
    }

    public void updateTable(int idTable, long toAdd) throws SQLException {
        this.updateTable.setLong(1, toAdd);
        this.updateTable.setInt(2, idTable);
        this.updateTable.execute();
    }

    public void addTable(String label) throws SQLException {
        this.addTable.setString(1, label);
        this.addTable.execute();
    }

    public void deleteTable(int idTable) throws SQLException {
        this.deleteTable.setInt(1, idTable);
        this.deleteTable.execute();
    }

    public void startTable(int idTable, long start, long durata) throws SQLException {
        this.startTable.setLong(1, start);
        this.startTable.setLong(2, durata);
        this.startTable.setInt(3, idTable);
        this.startTable.execute();
    }

    public void stopTable(int idTable) throws SQLException {
        this.stopTable.setInt(1, idTable);
        this.stopTable.execute();
    }

    public Vector getTables() throws SQLException {
        Vector<MasaJocuri> result = new Vector<MasaJocuri>();
        ResultSet rs = this.getAllTables.executeQuery();
        while (rs.next()) {
            MasaJocuri mj = this.getFromResultSet(rs);
            result.add(mj);
        }
        rs.close();
        return result;
    }

    public void addTracking(int idTable, long start, long durata) throws SQLException {
        this.addTracking.setInt(1, idTable);
        this.addTracking.setLong(2, start);
        this.addTracking.setLong(3, durata);
        this.addTracking.execute();
    }

    public MasaJocuri getTableById(int id) throws SQLException {
        this.getTableById.setInt(1, id);
        ResultSet rs = this.getTableById.executeQuery();
        MasaJocuri result = null;
        if (rs.next()) {
            result = this.getFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    private MasaJocuri getFromResultSet(ResultSet rs) throws SQLException {
        MasaJocuri mj = new MasaJocuri();
        mj.setId(rs.getInt("id"));
        mj.setLabel(rs.getString("label"));
        mj.setStart(rs.getLong("start"));
        mj.setDurata(rs.getLong("durata"));
        return mj;
    }
}

