/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.jocuri.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.jocuri.AlertListener;
import ro.atreides.jocuri.JocuriLogic;
import ro.atreides.jocuri.MasaJocuri;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class MasaEntry
extends JPanel
implements AlertListener {
    private MasaJocuri masa;
    private JLabel start;
    private JLabel stop;
    private JLabel durata;
    private JButton _15min;
    private JButton _30min;
    private JButton _60min;
    private JButton startButton;
    private JButton stopButton;
    private JButton resetButton;
    private long durataMillis = 0L;
    private int durataMinutes = 0;
    private JocuriLogic logic = JocuriLogic.getInstance();
    private boolean started = false;
    private JTextField masaLabel;

    public MasaEntry(MasaJocuri masa) {
        this.masa = masa;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 6;
        this.masaLabel = new JTextField(this.masa.getLabel());
        this.masaLabel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MasaEntry.this.masaLabel.setSelectionStart(0);
                MasaEntry.this.masaLabel.setSelectionEnd(MasaEntry.this.masaLabel.getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.add((Component)this.masaLabel, c);
        c.gridwidth = 3;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Start : "), c);
        c.gridx += 3;
        this.start = new JLabel();
        this.add((Component)this.start, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Stop : "), c);
        this.stop = new JLabel();
        c.gridx += 3;
        this.add((Component)this.stop, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Durata : "), c);
        c.gridx += 3;
        this.durata = new JLabel();
        this.add((Component)this.durata, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this._15min = new JButton("+15");
        this._15min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.addTime(15);
            }
        });
        this.add((Component)this._15min, c);
        c.gridx += 2;
        this._30min = new JButton("+30");
        this._30min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.addTime(30);
            }
        });
        this.add((Component)this._30min, c);
        c.gridx += 2;
        this._60min = new JButton("+60");
        this._60min.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.addTime(60);
            }
        });
        this.add((Component)this._60min, c);
        ++c.gridy;
        c.gridx = 0;
        this.startButton = new JButton("\u2023");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.start();
            }
        });
        this.add((Component)this.startButton, c);
        c.gridx += 2;
        this.stopButton = new JButton("\u23cf");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.stop();
            }
        });
        this.add((Component)this.stopButton, c);
        c.gridx += 2;
        this.resetButton = new JButton("\u21e4");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasaEntry.this.reset();
            }
        });
        this.add((Component)this.resetButton, c);
        this.stopButton.setEnabled(false);
    }

    private void addTime(int minutes) {
        long toAdd = minutes * 60 * 1000;
        this.durataMillis += toAdd;
        this.durataMinutes += minutes;
        this.refresh();
        if (this.started) {
            long stopTime = this.logic.updateMasa(this.masa.getId(), toAdd);
            this.stop.setText(Formatters.TIME_FORMAT.format(new Date(stopTime)));
        }
    }

    private void start() {
        long stopTime = this.logic.startMasa(this.masa.getId(), this.durataMillis, System.currentTimeMillis(), this);
        this.start(System.currentTimeMillis(), this.durataMillis, stopTime);
    }

    public void start(long startLong, long durataLong, long stopLong) {
        this.stop.setText(Formatters.TIME_FORMAT.format(new Date(stopLong)));
        this.start.setText(Formatters.TIME_FORMAT.format(new Date(startLong)));
        this.durataMillis = durataLong;
        this.durataMinutes = (int)durataLong / 1000 / 60;
        this.durata.setText("" + this.durataMinutes);
        this.resetButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.masaLabel.setEditable(false);
        this.started = true;
    }

    private void stop() {
        String timpConsumat = this.logic.getTimpConsumatString(this.masa.getId());
        DialogUtils.okDialog(this, "Timp consumat : " + timpConsumat, "Timp consumat la " + this.masaLabel.getText());
        this.logic.stopMasa(this.masa.getId());
        this.resetButton.setEnabled(true);
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.masaLabel.setEditable(true);
        this.reset();
        this.started = false;
    }

    private void reset() {
        this.durataMillis = 0L;
        this.durataMinutes = 0;
        this.stop.setText("-");
        this.start.setText("-");
        this.refresh();
    }

    private void refresh() {
        this.durata.setText(this.durataMinutes + " minute");
    }

    @Override
    public void alertStop(String label, int idMasa) {
        if (this.started) {
            DialogUtils.okDialog(this, "Timpul a expirat la " + label, LangRoAll.stop);
            this.stop();
        }
    }

    @Override
    public void alertWarning(int minutesRemaining, String label, int idMasa) {
        DialogUtils.okDialog(this, minutesRemaining + " minute la " + label, "Avertizare");
    }
}

