/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.monitor.gui.EditableStateListener;
import ro.atreides.monitor.gui.TimePanel;
import ro.atreides.monitor.logic.ActionsLogic;
import ro.atreides.monitor.threads.BackupThread;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.LoginDialog;
import ro.atreides.utils.multilang.LangRoAll;

public class ActionsPanel
extends JPanel
implements EditableStateListener {
    private TimePanel timePanelVerifica;
    private TimePanel timePanelBackup;
    private BackupThread backupThread;

    public ActionsPanel() {
        this.initialize();
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.insets = new Insets(0, 2, 3, 2);
        JButton buttonUpdate = new JButton("Update Program");
        this.add((Component)buttonUpdate, c);
        buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
                String user = dialog.getUserName();
                String passwd = dialog.getPassword();
                String cod = dialog.getCodAutentificare();
                if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
                    return;
                }
                DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.1;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 2);
        JButton buttonTrimiteLoguri = new JButton("Trimite loguri");
        this.add((Component)buttonTrimiteLoguri, c);
        buttonTrimiteLoguri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
                String user = dialog.getUserName();
                String passwd = dialog.getPassword();
                String cod = dialog.getCodAutentificare();
                if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
                    return;
                }
                DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.1;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        JButton buttonTrimiteBaza = new JButton("Trimite baza");
        this.add((Component)buttonTrimiteBaza, c);
        buttonTrimiteBaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
                String user = dialog.getUserName();
                String passwd = dialog.getPassword();
                String cod = dialog.getCodAutentificare();
                if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
                    return;
                }
                DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel panelBackupBaza = new JPanel(new GridBagLayout());
        panelBackupBaza.setBorder(new TitledBorder("backup"));
        this.add((Component)panelBackupBaza, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        JButton buttonBackUpBaza = new JButton("Backup baza");
        panelBackupBaza.add((Component)buttonBackUpBaza, c);
        buttonBackUpBaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, true, true);
                if (u != null) {
                    boolean b = ActionsLogic.actionsImpl.backupDB(true, "monitor");
                    if (b) {
                        DialogUtils.okDialog(GuiUtils.currentFrame, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Operatie neefectuata", LangRoAll.eroare);
                    }
                }
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        this.timePanelBackup = new TimePanel();
        this.timePanelBackup.setEditableMode(false);
        this.timePanelBackup.setTime(ActionsLogic.getHoursBackupPanel(), ActionsLogic.getMinutesBackupPanel());
        this.backupThread = new BackupThread(this.timePanelBackup);
        this.backupThread.start();
        panelBackupBaza.add((Component)this.timePanelBackup, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel panelVerificaBaza = new JPanel(new GridBagLayout());
        panelVerificaBaza.setBorder(new TitledBorder("verificare"));
        this.add((Component)panelVerificaBaza, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        JButton buttonVerificaBaza = new JButton("Verifica baza");
        panelVerificaBaza.add((Component)buttonVerificaBaza, c);
        buttonVerificaBaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                User u = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, true, true);
                if (u != null) {
                    boolean b = ActionsLogic.actionsImpl.verifyDB();
                    if (b) {
                        DialogUtils.okDialog(GuiUtils.currentFrame, "Baza date fara probleme", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "URGENT !! Probleme de integritate ale bazei de date. Contactati suportul tehnic !", "ATENTIE");
                    }
                }
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        this.timePanelVerifica = new TimePanel();
        this.timePanelVerifica.setEditableMode(false);
        this.timePanelVerifica.setTime(ActionsLogic.getHoursVerifyPanel(), ActionsLogic.getMinutesVerifyPanel());
        panelVerificaBaza.add((Component)this.timePanelVerifica, c);
    }

    @Override
    public void setEditable(boolean editable) {
        this.timePanelVerifica.setEditableMode(editable);
        this.timePanelBackup.setEditableMode(editable);
    }

    @Override
    public void saveConfigurations() {
        ActionsLogic.saveConfigurationData(this.timePanelVerifica, this.timePanelBackup);
    }
}

