/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.monitor.gui.DiskPanelCellRenderer;
import ro.atreides.monitor.gui.DiskPanelEntry;
import ro.atreides.monitor.gui.EditableStateListener;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.monitor.gui.TimePanel;
import ro.atreides.monitor.logic.DiskLogic;
import ro.atreides.monitor.threads.DiskMonitorThread;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class DiskPanel
extends AbstractListPanel
implements EditableStateListener {
    private static final String[] columns = new String[]{"Nume", "Liber", "Warning(MB)", "Critical(MB)", "Monitor"};
    private DiskPanelCellRenderer renderer;
    private AbstractTM model;
    private TimePanel timePanel;
    private boolean isEditMode = false;

    public DiskPanel() {
        this.doStuff();
        this.initialize();
        this.setPreferredSize(new Dimension(350, 140));
        this.setMinimumSize(this.getPreferredSize());
        new DiskMonitorThread(this).start();
    }

    private Class[] getTypes() {
        return new Class[]{String.class, String.class, Integer.class, Integer.class, Boolean.class};
    }

    @Override
    public AbstractTM buildTableModel() {
        this.model = new AbstractTM(columns, this.getTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int i, int i1, Vector vector) {
                DiskPanelEntry e = (DiskPanelEntry)vector.elementAt(i);
                switch (i1) {
                    case 0: {
                        return e.getLabel();
                    }
                    case 1: {
                        return e.getFreeSpace();
                    }
                    case 2: {
                        return e.getWarning();
                    }
                    case 3: {
                        return e.getCritical();
                    }
                    case 4: {
                        return e.isMonitor();
                    }
                }
                return "out of bounds";
            }

            @Override
            public boolean isCellEditable(int i, int i1) {
                if (!DiskPanel.this.isEditMode) {
                    return false;
                }
                return i1 > 1;
            }

            @Override
            public void setValueAt(Object o, int i, int i1, Vector vector) {
                System.out.println("setValue");
                DiskPanelEntry e = (DiskPanelEntry)vector.elementAt(i);
                switch (i1) {
                    case 0: {
                        e.setLabel((String)o);
                        break;
                    }
                    case 1: {
                        e.setFreeSpace(((Integer)o).intValue());
                        break;
                    }
                    case 2: {
                        if (o == null) {
                            e.setWarning(0);
                            break;
                        }
                        e.setWarning((Integer)o);
                        break;
                    }
                    case 3: {
                        if (o == null) {
                            e.setWarning(0);
                            break;
                        }
                        e.setCritical((Integer)o);
                        break;
                    }
                    case 4: {
                        e.setMonitor((Boolean)o);
                        break;
                    }
                }
                DiskPanel.this.tm.fireTableRowsUpdated(i, i);
            }
        });
        this.renderer = new DiskPanelCellRenderer(this.model);
        return this.model;
    }

    public AbstractTM getModel() {
        return this.model;
    }

    private void updateJTableColumns(JTable unu) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            if (column.getHeaderValue().equals("Monitor")) continue;
            column.setCellRenderer(this.renderer);
        }
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public Vector buildData() {
        return DiskLogic.getVectorOfEntry();
    }

    @Override
    public String[] buildColumns() {
        return columns;
    }

    @Override
    public Class[] buildTypes() {
        return this.getTypes();
    }

    @Override
    public void doStuff() {
        this.display();
        this.updateJTableColumns(this.table);
    }

    private void initialize() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        c.fill = 0;
        panel.add((Component)new JLabel("Verifica "), c);
        c.gridx = 1;
        c.gridy = 0;
        this.timePanel = new TimePanel();
        this.timePanel.setTime(DiskLogic.getHours(), DiskLogic.getMinutes());
        this.timePanel.setEditableMode(false);
        panel.add((Component)this.timePanel, c);
        c.gridx = 2;
        JButton buttonRefresh = new JButton(LangRoAll.verifica);
        buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTM tm = DiskPanel.this.getModel();
                Vector vector = DiskLogic.getVectorOfEntry();
                tm.refresh(vector);
            }
        });
        panel.add((Component)buttonRefresh, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)panel, c);
    }

    public TimeGetter getTimeGetter() {
        return this.timePanel;
    }

    private Hashtable getDiskHashtable(Vector vector) {
        Hashtable<String, DiskPanelEntry> table = new Hashtable<String, DiskPanelEntry>();
        for (DiskPanelEntry diskPanelEntry : vector) {
            table.put(diskPanelEntry.getLabel(), diskPanelEntry);
        }
        return table;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditMode = editable;
        this.timePanel.setEditableMode(editable);
    }

    @Override
    public void saveConfigurations() {
        DiskLogic.saveConfigurationData(this.getDiskHashtable(this.getModel().getData()), this.timePanel);
    }
}

