/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jibble.pircbot.IrcException;
import ro.atreides.monitor.gui.AlertePanel;
import ro.atreides.monitor.irc.IrcClient;
import ro.atreides.monitor.util.SupportTextStyles;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.LoginDialog;

public class SupportPanel
extends JPanel {
    private IrcClient bot;
    private JButton connect;
    private JButton send;
    private JTextField sendTextField;
    private static final String CONNECT_STRING = "Conecteaza";
    private static final String DISCONNECT_STRING = "Deconecteaza";
    private String channel;
    private AlertePanel parent;
    private boolean allowPasswords;
    private JTextPane textPane;

    public SupportPanel(AlertePanel parent) {
        this.parent = parent;
        this.initialize();
        this.setPreferredSize(new Dimension(400, 400));
        this.setMinimumSize(this.getPreferredSize());
        this.allowPasswords = Config.getInstance().getBoolean("allowPasswords");
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 23;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridwidth = 4;
        c.insets = new Insets(0, 2, 3, 2);
        final DefaultStyledDocument document = new DefaultStyledDocument(new StyleContext());
        this.textPane = new JTextPane(document);
        JScrollPane scrool = new JScrollPane(this.textPane, 22, 30);
        this.add((Component)scrool, c);
        this.textPane.setEditable(false);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.anchor = 21;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(5, 2, 3, 2);
        this.connect = new JButton(CONNECT_STRING);
        this.add((Component)this.connect, c);
        this.connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (SupportPanel.this.connect.getText().equalsIgnoreCase(SupportPanel.CONNECT_STRING)) {
                    LoginDialog dialog = new LoginDialog((Frame)GuiUtils.currentFrame, true);
                    String user = dialog.getUserName();
                    String passwd = dialog.getPassword();
                    String cod = dialog.getCodAutentificare();
                    if ((user == null || user.length() == 0 || passwd == null || passwd.length() == 0) && cod.length() == 0) {
                        return;
                    }
                    User supervizor = UsersLogic.getInstance().getUser(user, passwd, cod, SupportPanel.this.allowPasswords, true);
                    if (supervizor != null && UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users")) {
                        SupportPanel.this.connectToServer(document, supervizor.getLogin());
                        SupportPanel.this.connect.setText(SupportPanel.DISCONNECT_STRING);
                        SupportPanel.this.send.setEnabled(true);
                        SupportPanel.this.sendTextField.setEnabled(true);
                    }
                } else {
                    SupportPanel.this.disconnectFromServer(document);
                    SupportPanel.this.connect.setText(SupportPanel.CONNECT_STRING);
                    SupportPanel.this.bot = null;
                    SupportPanel.this.send.setEnabled(false);
                    SupportPanel.this.sendTextField.setEnabled(false);
                }
            }
        });
        ++c.gridx;
        c.insets = new Insets(5, 2, 3, 2);
        this.add((Component)new JLabel("Text"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.5;
        this.sendTextField = new JTextField();
        this.add((Component)this.sendTextField, c);
        this.sendTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupportPanel.this.sendMessage(document);
            }
        });
        this.sendTextField.setEnabled(false);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.send = new JButton("Send");
        this.add((Component)this.send, c);
        this.send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SupportPanel.this.sendMessage(document);
            }
        });
        this.send.setEnabled(false);
    }

    private void sendMessage(StyledDocument document, String text) {
        if (text.length() > 0) {
            this.bot.sendMessage(this.channel, text);
            this.appendTextToDocument(document, document.getLength(), "\n[" + Formatters.TIME_FORMAT.format(new Date()) + ']' + "<" + this.bot.getNick() + "> ", SupportTextStyles.styleOfMyName);
            this.appendTextToDocument(document, document.getLength(), text, SupportTextStyles.styleOfMyText);
            this.sendTextField.setText("");
        }
    }

    private void sendMessage(StyledDocument document) {
        if (this.bot != null && this.bot.isConnected()) {
            String text = this.sendTextField.getText();
            this.sendMessage(document, text);
        }
    }

    private void connectToServer(StyledDocument document, String user) {
        this.channel = "#suport";
        this.bot = new IrcClient(user, document, this.textPane);
        String host = Config.getInstance().getString("supportServerIP", "89.39.32.234");
        int port = Config.getInstance().getInt("supportServerPort", 6667);
        try {
            this.connectToServer(this.bot, host, port, document);
            this.joinChannel(this.bot, this.channel, document);
            this.sendMessage(document, "entityName : " + Config.getInstance().getString("entityName"));
            this.sendMessage(document, "address : " + Config.getInstance().getString("address"));
            this.sendMessage(document, "societate : " + Config.getInstance().getString("societate"));
            this.sendMessage(document, "cui : " + Config.getInstance().getString("cui"));
            this.sendMessage(document, "j : " + Config.getInstance().getString("j"));
            this.sendMessage(document, "sediu : " + Config.getInstance().getString("sediu"));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IrcException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    private void disconnectFromServer(StyledDocument document) {
        this.appendTextToDocument(document, document.getLength(), "\ndisconnected", SupportTextStyles.styleOfMyName);
        this.bot.disconnect();
    }

    private void connectToServer(IrcClient bot, String host, int port, StyledDocument document) throws IOException, IrcException {
        try {
            this.appendTextToDocument(document, document.getLength(), "\nconnecting to ", SupportTextStyles.styleOfMyName);
            this.appendTextToDocument(document, document.getLength(), host + ":", SupportTextStyles.styleOfIP);
            this.appendTextToDocument(document, document.getLength(), port + "", SupportTextStyles.styleOfPort);
            this.appendTextToDocument(document, document.getLength(), "......", SupportTextStyles.styleOfMyName);
            bot.connect(host, port);
            this.appendTextToDocument(document, document.getLength(), "OK", SupportTextStyles.styleOfMyName);
        }
        catch (IOException e) {
            this.appendTextToDocument(document, document.getLength(), "ERROR", SupportTextStyles.styleOfError);
            throw e;
        }
        catch (IrcException e) {
            this.appendTextToDocument(document, document.getLength(), "ERROR", SupportTextStyles.styleOfError);
            throw e;
        }
        Formatters.TIME_FORMAT.format(new Date());
    }

    private void joinChannel(IrcClient bot, String channel, StyledDocument document) throws IOException, IrcException {
        this.appendTextToDocument(document, document.getLength(), "\njoining ", SupportTextStyles.styleOfMyName);
        this.appendTextToDocument(document, document.getLength(), channel + " ", SupportTextStyles.styleOfChannel);
        bot.joinChannel(channel);
        this.appendTextToDocument(document, document.getLength(), "......", SupportTextStyles.styleOfMyName);
        this.appendTextToDocument(document, document.getLength(), "OK", SupportTextStyles.styleOfMyName);
    }

    private void appendTextToDocument(StyledDocument document, int offset, String text, Style style) {
        try {
            document.insertString(offset, text, style);
            this.textPane.setCaretPosition(document.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

