/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import ro.atreides.monitor.gui.TimeGetter;

public class TimePanel
extends JPanel
implements TimeGetter {
    private static final Border BORDER_FOR_EDITING = new LineBorder(Color.GREEN);
    private static final Border BORDER_FOR_VIEWING = new LineBorder(Color.RED);
    private JFormattedTextField hoursField;
    private JFormattedTextField minutesField;

    public TimePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        this.add((Component)new JLabel(" la "), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 10;
        this.hoursField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.hoursField.setValue(0);
        this.hoursField.setColumns(3);
        this.hoursField.setMinimumSize(this.hoursField.getPreferredSize());
        this.add((Component)this.hoursField, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)new JLabel(" ore "), c);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 10;
        this.minutesField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.minutesField.setValue(0);
        this.minutesField.setColumns(3);
        this.minutesField.setMinimumSize(this.minutesField.getPreferredSize());
        this.add((Component)this.minutesField, c);
        c.gridx = 4;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)new JLabel(" min "), c);
    }

    public void setHours(int hours) {
        this.hoursField.setValue(Math.max(0, hours));
    }

    public void setMinutes(int minutes) {
        this.minutesField.setValue(Math.max(0, minutes));
    }

    public void setTime(int hours, int minutes) {
        this.setHours(hours);
        this.setMinutes(minutes);
    }

    @Override
    public int getHours() {
        try {
            int hours = ((Number)this.hoursField.getValue()).intValue();
            return hours;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getMinutes() {
        try {
            int minutes = ((Number)this.minutesField.getValue()).intValue();
            return minutes;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setEditableMode(boolean value) {
        this.hoursField.setEditable(value);
        this.hoursField.setBorder(value ? BORDER_FOR_EDITING : BORDER_FOR_VIEWING);
        this.minutesField.setEditable(value);
        this.minutesField.setBorder(value ? BORDER_FOR_EDITING : BORDER_FOR_VIEWING);
    }
}

