/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.irc;

import java.util.Date;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jibble.pircbot.PircBot;
import ro.atreides.monitor.util.SupportTextStyles;
import ro.atreides.utils.Formatters;

public class IrcClient
extends PircBot {
    private StyledDocument document;
    private JTextPane textPane;

    public IrcClient(String username, StyledDocument document, JTextPane textPane) {
        this.document = document;
        this.textPane = textPane;
        this.setName(username);
    }

    public void onMessage(String channel, String sender, String login, String hostname, String message) {
        this.appendTextToDocument(this.document, this.document.getLength(), "\n[" + Formatters.TIME_FORMAT.format(new Date()) + ']' + "<" + sender + "> ", SupportTextStyles.styleOfAntherName);
        this.appendTextToDocument(this.document, this.document.getLength(), message, SupportTextStyles.styleOfAnotherText);
    }

    protected void onJoin(String channel, String sender, String login, String hostname) {
        System.out.println("onJoin():" + channel + " " + sender + " " + login + " " + hostname);
    }

    protected void onChannelInfo(String channel, int userCount, String topic) {
        if (userCount > 50) {
            System.out.println("channel name = " + channel + ", userCount = " + userCount + ", topic = " + topic);
        }
    }

    private void appendTextToDocument(StyledDocument document, int offset, String text, Style style) {
        try {
            document.insertString(offset, text, style);
            this.textPane.setCaretPosition(document.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

