/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.monitor.logic;

import java.util.Hashtable;
import ro.atreides.monitor.MonitorActions;
import ro.atreides.monitor.gui.TimeGetter;
import ro.atreides.monitor.util.FileUtils;

public class ActionsLogic {
    private static final String pathToDiskConfigFile = "timeconfig.bin";
    private static final int KEY_HOURS_BACKUP = 0;
    private static final int KEY_MINUTES_BACKUP = 1;
    private static final int KEY_HOURS_VERIFY = 2;
    private static final int KEY_MINUTES_VERIFY = 3;
    public static MonitorActions actionsImpl;

    public static synchronized Hashtable loadConfigurationData() {
        Object obj = FileUtils.loadParametersFromFile(pathToDiskConfigFile);
        if (obj instanceof Hashtable) {
            return (Hashtable)obj;
        }
        return null;
    }

    public static synchronized void saveConfigurationData(TimeGetter verifyGetter, TimeGetter backupGetter) {
        Hashtable<Integer, Integer> table = new Hashtable<Integer, Integer>();
        table.put(2, verifyGetter.getHours());
        table.put(3, verifyGetter.getMinutes());
        table.put(0, backupGetter.getHours());
        table.put(1, backupGetter.getMinutes());
        FileUtils.saveParametersToFile(pathToDiskConfigFile, table);
    }

    private static Object getParameter(Object key) {
        Hashtable table = ActionsLogic.loadConfigurationData();
        if (table != null && key != null) {
            return table.get(key);
        }
        return null;
    }

    public static int getHoursBackupPanel() {
        Object obj = ActionsLogic.getParameter(0);
        return obj == null ? 1 : (Integer)obj;
    }

    public static int getMinutesBackupPanel() {
        Object obj = ActionsLogic.getParameter(1);
        return obj == null ? 0 : (Integer)obj;
    }

    public static int getHoursVerifyPanel() {
        Object obj = ActionsLogic.getParameter(2);
        return obj == null ? 1 : (Integer)obj;
    }

    public static int getMinutesVerifyPanel() {
        Object obj = ActionsLogic.getParameter(3);
        return obj == null ? 0 : (Integer)obj;
    }
}

