/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.pontaj.PontajRule;
import ro.atreides.pontaj.PontajShift;
import ro.atreides.pontaj.RaportPontajEntry;
import ro.atreides.pontaj.gui.CounterView;
import ro.atreides.pontaj.gui.PlanOrarEntry;
import ro.atreides.utils.Client;
import ro.atreides.utils.db.DaoInterface;

public class PontajDao
implements DaoInterface {
    private PreparedStatement punchUserIn;
    private PreparedStatement punchUserOut;
    private PreparedStatement getUsersRaport;
    private PreparedStatement addPlanOrar;
    private PreparedStatement deletePlanOrar;
    private PreparedStatement selectAllPlanOrar;
    private PreparedStatement updatePlanOrar;
    private PreparedStatement addRule;
    private PreparedStatement deleteRule;
    private PreparedStatement updateRule;
    private PreparedStatement getRules;
    private PreparedStatement addShift;
    private PreparedStatement deleteShiftsForRule;
    private PreparedStatement getShifts;
    private PreparedStatement punchClientIn;
    private PreparedStatement punchClientOut;
    private PreparedStatement getClientsRaport;
    private PreparedStatement getLastClientIn;
    private PreparedStatement getCounterReport;
    private PreparedStatement getNumarIntrari;
    private PreparedStatement deleteEntry;
    private PreparedStatement getPeopleInShift;
    private Connection connection;

    public void deleteEntry(int id) throws SQLException {
        this.deleteEntry.setInt(1, id);
        this.deleteEntry.execute();
    }

    public void deleteShiftsForRule(int id) throws SQLException {
        this.deleteShiftsForRule.setInt(1, id);
        this.deleteShiftsForRule.execute();
    }

    public void addShift(Timestamp start, Timestamp stop, int idRule, int tip) throws SQLException {
        this.addShift.setInt(1, idRule);
        this.addShift.setTimestamp(2, start);
        this.addShift.setTimestamp(3, stop);
        this.addShift.setInt(4, tip);
        this.addShift.execute();
    }

    public void updateRule(String nume, int before, int late, int overtime, int id) throws SQLException {
        this.updateRule.setString(1, nume);
        this.updateRule.setInt(2, before);
        this.updateRule.setInt(3, late);
        this.updateRule.setInt(4, overtime);
        this.updateRule.setInt(5, id);
        this.updateRule.execute();
    }

    public void deleteRule(int id) throws SQLException {
        this.deleteRule.setInt(1, id);
        this.deleteRule.execute();
    }

    public void addRule(String nume, int before, int late, int overtime) throws SQLException {
        this.addRule.setString(1, nume);
        this.addRule.setInt(2, before);
        this.addRule.setInt(3, late);
        this.addRule.setInt(4, overtime);
        this.addRule.execute();
    }

    public Vector getShifts(int idRule, int tip) throws SQLException {
        Vector<PontajShift> result = new Vector<PontajShift>();
        this.getShifts.setInt(1, idRule);
        this.getShifts.setInt(2, idRule);
        this.getShifts.setInt(3, tip);
        ResultSet rs = this.getShifts.executeQuery();
        while (rs.next()) {
            PontajShift ps = new PontajShift();
            ps.setId(rs.getInt("id"));
            ps.setIdRule(rs.getInt("id_rule"));
            ps.setOraStart(rs.getTimestamp("start"));
            ps.setOraStop(rs.getTimestamp("stop"));
            ps.setTip(rs.getInt("tip"));
            result.add(ps);
        }
        rs.close();
        return result;
    }

    public Vector getAllRules() throws SQLException {
        Vector<PontajRule> result = new Vector<PontajRule>();
        ResultSet rs = this.getRules.executeQuery();
        while (rs.next()) {
            PontajRule pr = new PontajRule();
            pr.setNume(rs.getString("name"));
            pr.setEarly(rs.getInt("early"));
            pr.setLate(rs.getInt("late"));
            pr.setOvertime(rs.getInt("overtime"));
            pr.setId(rs.getInt("id"));
            result.add(pr);
        }
        return result;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getPeopleInShift = this.connection.prepareStatement("select count(id) from pontaj where punch_out is null");
        this.deleteEntry = this.connection.prepareStatement("delete from pontaj where id = ?");
        this.addShift = this.connection.prepareStatement("insert into pontaj_shift(id_rule, start, stop, tip) values (?, ?, ?, ?)");
        this.deleteShiftsForRule = this.connection.prepareStatement("delete from pontaj_shift where id_rule = ?");
        this.getShifts = this.connection.prepareStatement("select * from pontaj_shift where (id_rule = ? or ? = -1 ) and tip = ? order by hour(start), minute(start), hour(stop), minute(stop)");
        this.addRule = this.connection.prepareStatement("insert into pontaj_rule(name, early, late, overtime ) values ( ?, ?, ?, ?)");
        this.deleteRule = this.connection.prepareStatement("delete from pontaj_rule where id = ?");
        this.updateRule = this.connection.prepareStatement("update pontaj_rule set name = ?, early = ?, late = ?, overtime = ? where id = ?");
        this.getRules = this.connection.prepareStatement("select * from pontaj_rule");
        this.punchUserIn = this.connection.prepareStatement("insert into pontaj(id_user, detalii) values ( ?, ? )");
        this.punchUserOut = this.connection.prepareStatement("update pontaj set punch_out = current_timestamp where id_user = ? and punch_out is null");
        this.getUsersRaport = this.connection.prepareStatement("select pontaj.punch_in as start, pontaj.punch_out as stop, pontaj.detalii, users.login, id_user  from pontaj inner join users on pontaj.id_user = users.id where (id_user = ? or ? = -1)  and punch_in >= ? and (punch_out <= ? or punch_out is null)");
        this.punchClientIn = this.connection.prepareStatement("insert into pontaj(id_client, id_abonament, detalii, counted) values ( ?, ?, ?, ? )");
        this.punchClientOut = this.connection.prepareStatement("update pontaj set punch_out = current_timestamp where id_client = ? and punch_out is null");
        this.getClientsRaport = this.connection.prepareStatement("select pontaj.punch_in as start, pontaj.punch_out as stop, pontaj.detalii, pontaj.counted, id_client, pontaj.id as id_pontaj  from pontaj inner join clienti on pontaj.id_client = clienti.id where (id_client = ? or ? = -1)  and punch_in >= ? and (punch_out <= ? or punch_out is null) order by punch_in, id_client");
        this.getCounterReport = this.connection.prepareStatement("select count(pontaj.punch_in) as numar, persoane_fizice.nume || ' ' || persoane_fizice.prenume as nume, persoane_fizice.telefon_fix, persoane_juridice.nume as societate from pontaj inner join clienti on pontaj.id_client = clienti.id inner join persoane_fizice on clienti.idPersFizica = persoane_fizice.id inner join persoane_juridice on persoane_fizice.id_pers_juridica = persoane_juridice.id where 1 = 1 and (clienti.idPersFizica = ? or ? = -1) and (persoane_juridice.id = ? or ? = -1) and punch_in >= ? and punch_in < ? group by persoane_fizice.nume, persoane_fizice.prenume, persoane_juridice.nume, persoane_fizice.telefon_fix");
        this.getLastClientIn = this.connection.prepareStatement("select punch_in from pontaj where punch_in = (select max(punch_in) from pontaj where id_client = ? and counted = 1)");
        this.addPlanOrar = this.connection.prepareStatement("insert into plan_orar(start, stop, pay) values (?,?,?)");
        this.updatePlanOrar = this.connection.prepareStatement("update plan_orar set start = ?, stop = ?, pay = ? where id = ?");
        this.selectAllPlanOrar = this.connection.prepareStatement("select * from plan_orar");
        this.deletePlanOrar = this.connection.prepareStatement("delete from plan_orar where id = ?");
        this.getNumarIntrari = this.connection.prepareStatement("select count(pontaj.punch_in) from pontaj where counted = 1 and pontaj.id_client = ? and punch_in >= ? and punch_in < ? and (id_abonament = ? or ? = -1)");
    }

    public int getNumarIntrari(int idClient, Timestamp start, Timestamp stop, int idAbonament) throws SQLException {
        int result = 0;
        this.getNumarIntrari.setInt(1, idClient);
        this.getNumarIntrari.setTimestamp(2, start);
        this.getNumarIntrari.setTimestamp(3, stop);
        this.getNumarIntrari.setInt(4, idAbonament);
        this.getNumarIntrari.setInt(5, idAbonament);
        ResultSet rs = this.getNumarIntrari.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getPeopleInShift() throws SQLException {
        int result = 0;
        ResultSet rs = this.getPeopleInShift.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Vector getCounterReport(int idCompanie, int idAngajat, Timestamp start, Timestamp stop) throws SQLException {
        Vector<CounterView> result = new Vector<CounterView>();
        this.getCounterReport.setInt(1, idAngajat);
        this.getCounterReport.setInt(2, idAngajat);
        this.getCounterReport.setInt(3, idCompanie);
        this.getCounterReport.setInt(4, idCompanie);
        this.getCounterReport.setTimestamp(5, start);
        this.getCounterReport.setTimestamp(6, stop);
        ResultSet rs = this.getCounterReport.executeQuery();
        while (rs.next()) {
            CounterView cv = new CounterView();
            cv.setCount(rs.getInt("numar"));
            cv.setNume(rs.getString("nume"));
            cv.setNumar(rs.getString("telefon_fix"));
            cv.setDepartament(rs.getString("societate"));
            result.add(cv);
        }
        rs.close();
        return result;
    }

    public Timestamp getLastClientIn(int idClient) throws SQLException {
        Timestamp result = null;
        this.getLastClientIn.setInt(1, idClient);
        ResultSet rs = this.getLastClientIn.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public void addClientPunchIn(int idClient, int idAbonament, String detalii, boolean recordCounted) throws SQLException {
        this.punchClientIn.setInt(1, idClient);
        this.punchClientIn.setInt(2, idAbonament);
        this.punchClientIn.setString(3, detalii);
        this.punchClientIn.setInt(4, recordCounted ? 1 : 0);
        this.punchClientIn.execute();
    }

    public void punchClientOut(int idClient) throws SQLException {
        this.punchClientOut.setInt(1, idClient);
        this.punchClientOut.execute();
    }

    public Vector getRaportPontajClients(int idClient, Timestamp start, Timestamp stop) throws SQLException {
        Vector<RaportPontajEntry> result = new Vector<RaportPontajEntry>();
        this.getClientsRaport.setInt(1, idClient);
        this.getClientsRaport.setInt(2, idClient);
        this.getClientsRaport.setTimestamp(3, start);
        this.getClientsRaport.setTimestamp(4, stop);
        ResultSet rs = this.getClientsRaport.executeQuery();
        while (rs.next()) {
            RaportPontajEntry re = new RaportPontajEntry();
            re.setIdUser(rs.getInt("id_client"));
            Client c = ClientLogic.getInstance().getClientById(re.getIdUser());
            re.setUser(c.toString());
            re.setDetalii(rs.getString("detalii"));
            re.setStart(rs.getTimestamp("start"));
            re.setStop(rs.getTimestamp("stop"));
            re.setId(rs.getInt("id_pontaj"));
            re.setCounted(rs.getInt("counted") == 1);
            result.add(re);
        }
        rs.close();
        return result;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public PontajDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public void deletePlanOrar(int id) throws SQLException {
        this.deletePlanOrar.setInt(1, id);
        this.deletePlanOrar.execute();
    }

    public Vector selectAllPlanOrar() throws SQLException {
        Vector<PlanOrarEntry> result = new Vector<PlanOrarEntry>();
        ResultSet rs = this.selectAllPlanOrar.executeQuery();
        while (rs.next()) {
            PlanOrarEntry poe = this.getPlanOrarEntryFromRS(rs);
            result.add(poe);
        }
        rs.close();
        return result;
    }

    public PlanOrarEntry getPlanOrarEntryFromRS(ResultSet rs) throws SQLException {
        PlanOrarEntry poe = new PlanOrarEntry();
        poe.setId(rs.getInt("id"));
        poe.setOraStart(rs.getTimestamp("start"));
        poe.setOraStop(rs.getTimestamp("stop"));
        poe.setPayedHours(rs.getDouble("pay"));
        return poe;
    }

    public void updatePlanOrar(int id, Timestamp start, Timestamp stop, double pay) throws SQLException {
        this.updatePlanOrar.setTimestamp(1, start);
        this.updatePlanOrar.setTimestamp(2, stop);
        this.updatePlanOrar.setDouble(3, pay);
        this.updatePlanOrar.setInt(4, id);
        this.updatePlanOrar.execute();
    }

    public void addPlanOrar(Timestamp start, Timestamp stop, double pay) throws SQLException {
        this.addPlanOrar.setTimestamp(1, start);
        this.addPlanOrar.setTimestamp(2, stop);
        this.addPlanOrar.setDouble(3, pay);
        this.addPlanOrar.execute();
    }

    public void addUserPunchIn(int idUser, String detalii) throws SQLException {
        this.punchUserIn.setInt(1, idUser);
        this.punchUserIn.setString(2, detalii);
        this.punchUserIn.execute();
    }

    public void punchUserOut(int idUser) throws SQLException {
        this.punchUserOut.setInt(1, idUser);
        this.punchUserOut.execute();
    }

    public Vector getRaportPontajUsers(int idUser, Timestamp start, Timestamp stop) throws SQLException {
        Vector<RaportPontajEntry> result = new Vector<RaportPontajEntry>();
        this.getUsersRaport.setInt(1, idUser);
        this.getUsersRaport.setInt(2, idUser);
        this.getUsersRaport.setTimestamp(3, start);
        this.getUsersRaport.setTimestamp(4, stop);
        ResultSet rs = this.getUsersRaport.executeQuery();
        while (rs.next()) {
            RaportPontajEntry re = new RaportPontajEntry();
            re.setUser(rs.getString("login"));
            re.setIdUser(rs.getInt("id_user"));
            re.setDetalii(rs.getString("detalii"));
            re.setStart(rs.getTimestamp("start"));
            re.setStop(rs.getTimestamp("stop"));
            result.add(re);
        }
        rs.close();
        return result;
    }
}

