/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.pontaj.PontajDao;
import ro.atreides.pontaj.PontajRule;
import ro.atreides.pontaj.PontajShift;
import ro.atreides.pontaj.PontajShiftPrezenta;
import ro.atreides.pontaj.RaportPontajEntry;
import ro.atreides.pontaj.RealOreEntry;
import ro.atreides.pontaj.gui.CounterReport;
import ro.atreides.pontaj.gui.PlanOrarEntry;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class PontajLogic
extends EventGenerator {
    private static PontajLogic instance;
    public static final int PUNCH_IN = 1;
    public static final int PUNCH_OUT = 2;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private PontajLogic() {
    }

    private synchronized PontajDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        PontajDao dao = null;
        while (dao == null) {
            dao = (PontajDao)this.pool.getDao(PontajDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(PontajDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized PontajLogic getInstance() {
        if (instance == null) {
            instance = new PontajLogic();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumarIntrari(int idClient, Timestamp start, Timestamp stop, int idContract) {
        int result = 0;
        try {
            result = this.getDao().getNumarIntrari(idClient, start, stop, idContract);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCounterClienti(Hashtable criteria) {
        Vector result = new Vector();
        int idCompanie = -1;
        Object comp = criteria.get("Departament");
        if (comp != null) {
            idCompanie = (Integer)comp;
        }
        int idAngajat = -1;
        comp = criteria.get(CounterReport.ANGAJAT_KEY);
        if (comp != null) {
            idAngajat = (Integer)comp;
        }
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        try {
            result = this.getDao().getCounterReport(idCompanie, idAngajat, new Timestamp(s1.getTime()), new Timestamp(s2.getTime()));
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRaportPontajUsers(Hashtable criteria) {
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Vector result = null;
        try {
            int idUser = -1;
            Object user = criteria.get("user");
            if (user != null) {
                idUser = (Integer)user;
            }
            result = this.getDao().getRaportPontajUsers(idUser, new Timestamp(s1.getTime()), new Timestamp(s2.getTime()));
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getClientsRaportPontaj(Hashtable criteria) {
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Vector result = null;
        try {
            int idClient = -1;
            Object user = criteria.get("user");
            if (user != null) {
                idClient = (Integer)user;
            }
            result = this.getDao().getRaportPontajClients(idClient, new Timestamp(s1.getTime()), new Timestamp(s2.getTime()));
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punchUserOut(int idUser) {
        try {
            this.getDao().punchUserOut(idUser);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punchUserIn(int idUser, String detalii) {
        try {
            this.punchUserInNoCommit(idUser, detalii);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void punchUserInNoCommit(int idUser, String detalii) throws SQLException {
        this.getDao().punchUserOut(idUser);
        this.getDao().addUserPunchIn(idUser, detalii);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punchClientOut(int idClient) {
        try {
            this.getDao().punchClientOut(idClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void punchClientIn(int idClient, int idAbonament, String detalii, boolean counted) {
        try {
            this.punchClientInNoCommit(idClient, idAbonament, detalii, counted);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void punchClientInNoCommit(int idClient, int idAbonament, String detalii, boolean counted) throws SQLException {
        this.getDao().punchClientOut(idClient);
        this.getDao().addClientPunchIn(idClient, idAbonament, detalii, counted);
    }

    public boolean isUserCheckedInNoCommit(int idUser) throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastClientCheckIn(int idClient) {
        try {
            Timestamp timestamp = this.getLastClientCheckInNoCommit(idClient);
            return timestamp;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            this.pool.releaseConnection();
        }
    }

    public Timestamp getLastClientCheckInNoCommit(int idClient) throws SQLException {
        return this.getDao().getLastClientIn(idClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPlanOrar() {
        try {
            Vector vector = this.getDao().selectAllPlanOrar();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlanOrarEntry(int id, Timestamp oraStart, Timestamp oraStop, double payedHours) {
        try {
            this.getDao().updatePlanOrar(id, oraStart, oraStop, payedHours);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlanOrarEntry(Timestamp oraStart, Timestamp oraStop, double payedHours) {
        try {
            this.getDao().addPlanOrar(oraStart, oraStop, payedHours);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlanOrarEntry(int id) {
        try {
            this.getDao().deletePlanOrar(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPontajShift(int idRule, Timestamp start, Timestamp stop, int tip) {
        try {
            this.getDao().addShift(start, stop, idRule, tip);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePontajEntry(int id) {
        try {
            this.getDao().deleteEntry(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePontajShift(int id) {
        try {
            this.getDao().deleteShiftsForRule(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPontajShifts(int idRule, int tip) {
        try {
            Vector vector = this.getDao().getShifts(idRule, tip);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRule(String nume, int before, int late, int overtime, Vector lucruShifts, Vector pauzaShifts) {
        int id = -1;
        try {
            PontajShift pontajShift;
            int i;
            this.getDao().addRule(nume, before, late, overtime);
            id = this.pool.requestConnection().getIndentityLocal();
            for (i = 0; i < lucruShifts.size(); ++i) {
                pontajShift = (PontajShift)lucruShifts.elementAt(i);
                this.getDao().addShift(pontajShift.getOraStart(), pontajShift.getOraStop(), id, pontajShift.getTip());
            }
            for (i = 0; i < pauzaShifts.size(); ++i) {
                pontajShift = (PontajShift)pauzaShifts.elementAt(i);
                this.getDao().addShift(pontajShift.getOraStart(), pontajShift.getOraStop(), id, pontajShift.getTip());
            }
            this.pool.commit();
            this.notifyListeners(601);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRule(String nume, int early, int late, int overtime, int id, Vector lucruShifts, Vector pauzaShifts) {
        try {
            PontajShift pontajShift;
            int i;
            this.getDao().deleteShiftsForRule(id);
            this.getDao().updateRule(nume, early, late, overtime, id);
            for (i = 0; i < lucruShifts.size(); ++i) {
                pontajShift = (PontajShift)lucruShifts.elementAt(i);
                this.getDao().addShift(pontajShift.getOraStart(), pontajShift.getOraStop(), id, pontajShift.getTip());
            }
            for (i = 0; i < pauzaShifts.size(); ++i) {
                pontajShift = (PontajShift)pauzaShifts.elementAt(i);
                this.getDao().addShift(pontajShift.getOraStart(), pontajShift.getOraStop(), id, pontajShift.getTip());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRule(int id) {
        try {
            this.getDao().deleteRule(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllRules() {
        try {
            Vector vector = this.getDao().getAllRules();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private long[] computeRealOre(Vector entries, PontajRule pr) {
        long[] result = new long[2];
        long comeEarlyMillis = 0L;
        long comeLateMillis = 0L;
        long leaveEarlyMillis = 0L;
        long leaveLateMillis = 0L;
        long allowedBreak = 0L;
        long intreruperi = 0L;
        long totalShiftMillis = 0L;
        long lastPrezentaStop = 0L;
        Vector lucru = this.getPontajShifts(pr.getId(), 1);
        Vector pauze = this.getPontajShifts(pr.getId(), 2);
        for (int i = 0; i < pauze.size(); ++i) {
            PontajShift pontajShift = (PontajShift)pauze.elementAt(i);
            allowedBreak += pontajShift.getOraStop().getTime() - pontajShift.getOraStart().getTime();
        }
        PontajShift pontajShift = (PontajShift)lucru.get(0);
        Timestamp startShift = pontajShift.getOraStart();
        Timestamp stopShift = pontajShift.getOraStop();
        long startShiftMillis = startShift.getTime() % DateUtils.dayMillis;
        long stopShiftMillis = stopShift.getTime() % DateUtils.dayMillis;
        for (int i = 0; i < entries.size(); ++i) {
            long diff;
            PontajShiftPrezenta psp = (PontajShiftPrezenta)entries.elementAt(i);
            RaportPontajEntry raportPontajEntry = psp.getPrezenta();
            Timestamp start = raportPontajEntry.getStartTime();
            Timestamp stop = raportPontajEntry.getStopTime();
            long millisStart = start.getTime() % DateUtils.dayMillis;
            long millisStop = stop.getTime() % DateUtils.dayMillis;
            if (i == 0) {
                if (startShiftMillis > millisStart && (diff = startShiftMillis - millisStart) > (long)(pr.getEarly() * 60 * 1000)) {
                    comeEarlyMillis = diff;
                }
                if (startShiftMillis < millisStart && (diff = millisStart - startShiftMillis) > (long)(pr.getLate() * 60 * 1000)) {
                    comeLateMillis = diff;
                }
                lastPrezentaStop = millisStop;
                totalShiftMillis += stopShiftMillis - startShiftMillis;
            }
            if (i == entries.size() - 1) {
                if (stopShiftMillis > millisStop) {
                    leaveEarlyMillis = stopShiftMillis - millisStop;
                }
                if (millisStop > stopShiftMillis && (diff = millisStop - stopShiftMillis) > (long)(pr.getOvertime() * 60 * 1000)) {
                    leaveLateMillis = diff;
                }
            }
            if (i <= 0 || i >= entries.size()) continue;
            intreruperi += millisStart - lastPrezentaStop;
            lastPrezentaStop = millisStop;
        }
        long totalRealMillis = totalShiftMillis + comeEarlyMillis - comeLateMillis + leaveLateMillis - leaveEarlyMillis;
        if (allowedBreak < intreruperi) {
            totalRealMillis -= intreruperi - allowedBreak;
        }
        long extraMillis = 0L;
        if (totalRealMillis > totalShiftMillis) {
            extraMillis = totalRealMillis - totalShiftMillis;
            totalRealMillis = totalShiftMillis;
            extraMillis = extraMillis > (long)(pr.getOvertime() * 60 * 1000) ? (extraMillis += this.getExtraMillis(stopShiftMillis, extraMillis)) : 0L;
        } else {
            extraMillis = 0L;
        }
        result[0] = totalRealMillis;
        result[1] = extraMillis;
        return result;
    }

    private long getExtraMillis(long endShift, long extraMillis) {
        long result = 0L;
        long e1 = endShift;
        long e2 = endShift + extraMillis;
        Vector plan = this.getPlanOrar();
        for (int i = 0; i < plan.size(); ++i) {
            PlanOrarEntry planOrarEntry = (PlanOrarEntry)plan.elementAt(i);
            Timestamp s1 = planOrarEntry.getOraStart();
            long s1m = s1.getTime() % DateUtils.dayMillis;
            Timestamp s2 = planOrarEntry.getOraStop();
            long s2m = s2.getTime() % DateUtils.dayMillis;
            if (e1 > s2m || e2 < s1m) continue;
            if (e1 <= s1m && e2 >= s2m) {
                result += (long)((double)(s2m - s1m) * (planOrarEntry.getPayedHours() - 1.0));
                continue;
            }
            if (e1 <= s1m) {
                result += (long)((double)(e2 - s1m) * (planOrarEntry.getPayedHours() - 1.0));
                continue;
            }
            result += (long)((double)(s2m - e1) * (planOrarEntry.getPayedHours() - 1.0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRealOreReport(Hashtable criteria) {
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        Vector<RealOreEntry> result = new Vector<RealOreEntry>();
        try {
            int idUser = (Integer)criteria.get("user");
            PontajRule pr = (PontajRule)criteria.get("rule");
            Vector lucru = this.getDao().getShifts(pr.getId(), 1);
            Hashtable shifts = new Hashtable();
            Vector<Date> days = DateUtils.getDaysInPerioada(s1, s2);
            for (int i = 0; i < days.size(); ++i) {
                Date startDay = days.elementAt(i);
                Date stopDay = DateUtils.getEndOfDay(startDay);
                Vector prezenta = this.getDao().getRaportPontajUsers(idUser, new Timestamp(startDay.getTime()), new Timestamp(stopDay.getTime()));
                for (int j = 0; j < lucru.size(); ++j) {
                    PontajShift pontajShift = (PontajShift)lucru.elementAt(j);
                    Timestamp startShift = pontajShift.getOraStart();
                    Timestamp stopShift = pontajShift.getOraStop();
                    long startShiftMillis = startShift.getTime() % DateUtils.dayMillis;
                    long stopShiftMillis = stopShift.getTime() % DateUtils.dayMillis;
                    for (int k = 0; k < prezenta.size(); ++k) {
                        long millisStop;
                        RaportPontajEntry raportPontajEntry = (RaportPontajEntry)prezenta.elementAt(k);
                        Timestamp start = raportPontajEntry.getStartTime();
                        Timestamp stop = raportPontajEntry.getStopTime();
                        long millisStart = start.getTime() % DateUtils.dayMillis;
                        if (stop == null || startShiftMillis > (millisStop = stop.getTime() % DateUtils.dayMillis) || stopShiftMillis < millisStart) continue;
                        System.out.println("Prezenta: " + start + " - " + stop);
                        System.out.println("Shift: " + startShift + " - " + stopShift + "\n");
                        String key = Formatters.DATE_FORMAT_RO.format(startDay) + "  " + pontajShift.toString();
                        Vector<PontajShiftPrezenta> curr = (Vector<PontajShiftPrezenta>)shifts.get(key);
                        if (curr == null) {
                            curr = new Vector<PontajShiftPrezenta>();
                        }
                        PontajShiftPrezenta psp = new PontajShiftPrezenta(pontajShift, raportPontajEntry);
                        curr.add(psp);
                        shifts.put(key, curr);
                    }
                }
            }
            for (String key : shifts.keySet()) {
                Vector entries = (Vector)shifts.get(key);
                if (entries == null) continue;
                long[] cifre = this.computeRealOre(entries, pr);
                RealOreEntry toAdd = new RealOreEntry();
                toAdd.setTura(key);
                toAdd.setNormalWork(cifre[0]);
                toAdd.setExtraWork(cifre[1]);
                if (cifre[0] <= 0L) continue;
                result.add(toAdd);
                toAdd.compute();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            result = new Vector();
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPeopleInShift() {
        try {
            int n = this.getDao().getPeopleInShift();
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }
}

