/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.RaportPontajEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class PontajReport
extends AbstractReportPanel {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JMultilineLabel total;
    private JComboBox users;
    private static final String[] columns = new String[]{LangRoAll.utilizator, "Punch in", "Punch out", "Durata", LangRoAll.detalii};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class};

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.users)) {
            User cat = (User)this.users.getSelectedItem();
            result.put("user", Integer.valueOf(cat.getId()));
            this.printCriteria.put(LangRoAll.utilizator, cat.getLogin());
        } else {
            this.printCriteria.remove(LangRoAll.utilizator);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return PontajLogic.getInstance().getRaportPontajUsers(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    RaportPontajEntry entry = (RaportPontajEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getUser());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getStart());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getStop());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getDurata());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getDetalii());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return PontajReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Evidenta ore";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportPontajEntry se = (RaportPontajEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getUser();
                    }
                    case 1: {
                        return se.getStart();
                    }
                    case 2: {
                        return se.getStop();
                    }
                    case 3: {
                        return se.getDurata();
                    }
                    case 4: {
                        return se.getDetalii();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.total = new JMultilineLabel();
        this.total.setText("Total :");
        result.add((Component)this.total, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        categPanel.add((Component)new JLabel(LangRoAll.utilizator), c);
        ++c.gridx;
        this.users = new JComboBox();
        this.users.setPrototypeDisplayValue("111111111111111111111111111111111");
        categPanel.add((Component)this.users, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
        String newLabel = "Total : " + DateUtils.getHoursForDiff(this.getTotalTime());
        this.total.setText(newLabel);
    }

    public long getTotalTime() {
        long total = 0L;
        for (int i = 0; i < this.data.size(); ++i) {
            RaportPontajEntry raportPontajEntry = (RaportPontajEntry)this.data.elementAt(i);
            total += raportPontajEntry.getDurataLong();
        }
        return total;
    }

    private void refreshUsers() {
        ComboUtils.replaceItemsForCombo(this.users, UsersLogic.getInstance().getAllUsers());
    }

    @Override
    public void doStuff() {
        this.refreshUsers();
        UsersLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "PontajReport_users";
            }

            @Override
            public void dataChanged() {
                PontajReport.this.refreshUsers();
            }
        }, 4);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: {
                        return 4;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return PontajReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return PontajReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                RaportPontajEntry ie = (RaportPontajEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getUser();
                    }
                    case 1: {
                        return ie.getStart();
                    }
                    case 2: {
                        return ie.getStop();
                    }
                    case 3: {
                        return ie.getDurata();
                    }
                    case 4: {
                        return ie.getDetalii();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

