/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.PontajRule;
import ro.atreides.pontaj.gui.PontajShiftPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PontajRuleList
extends AbstractListPanel {
    private JTextField nume;
    private JTextField early;
    private JTextField late;
    private JTextField overtime;
    private PontajRule toEdit;
    private PontajShiftPanel lucru;
    private PontajShiftPanel pauza;

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PontajRule plata = (PontajRule)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return plata.getNume();
                    }
                    case 1: {
                        return plata.getEarly();
                    }
                    case 2: {
                        return plata.getLate();
                    }
                    case 3: {
                        return plata.getOvertime();
                    }
                }
                return null;
            }
        });
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nume regula"), c);
        ++c.gridx;
        this.nume = new JTextField(5);
        result.add((Component)this.nume, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Inainte de program necontorizat (minute)"), c);
        ++c.gridx;
        this.early = new JTextField(5);
        result.add((Component)this.early, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Intarziere permisa (minute)"), c);
        ++c.gridx;
        this.late = new JTextField(5);
        result.add((Component)this.late, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Prag ore suplimentare (minute)"), c);
        ++c.gridx;
        this.overtime = new JTextField(5);
        result.add((Component)this.overtime, c);
        final PontajRuleList parent = this;
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String numeS = PontajRuleList.this.nume.getText();
                String earlyS = PontajRuleList.this.early.getText();
                String lateS = PontajRuleList.this.late.getText();
                String overS = PontajRuleList.this.overtime.getText();
                if (!Validators.correctString(numeS)) {
                    DialogUtils.errorDialog(parent, "Nume incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctInteger(earlyS)) {
                    DialogUtils.errorDialog(parent, "Camp Inainte de program incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctInteger(lateS)) {
                    DialogUtils.errorDialog(parent, "Camp Intarziere permisa incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctInteger(overS)) {
                    DialogUtils.errorDialog(parent, "Camp Ore suplimentare incorect", LangRoAll.nuPotContinua);
                    return;
                }
                int earlyI = Integer.parseInt(earlyS);
                int lateI = Integer.parseInt(lateS);
                int overI = Integer.parseInt(overS);
                if (PontajRuleList.this.toEdit != null) {
                    PontajLogic.getInstance().updateRule(numeS, earlyI, lateI, overI, PontajRuleList.this.toEdit.getId(), PontajRuleList.this.lucru.getShifts(), PontajRuleList.this.pauza.getShifts());
                    PontajRuleList.this.lucru.setShifts(new Vector());
                    PontajRuleList.this.pauza.setShifts(new Vector());
                    PontajRuleList.this.refreshTable();
                    PontajRuleList.this.setObjectToEdit(null);
                    PontajRuleList.this.nume.requestFocus();
                } else {
                    PontajLogic.getInstance().addRule(numeS, earlyI, lateI, overI, PontajRuleList.this.lucru.getShifts(), PontajRuleList.this.pauza.getShifts());
                    PontajRuleList.this.lucru.setShifts(new Vector());
                    PontajRuleList.this.pauza.setShifts(new Vector());
                    PontajRuleList.this.refreshTable();
                    PontajRuleList.this.setObjectToEdit(null);
                    PontajRuleList.this.nume.requestFocus();
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridy;
        c.gridx = 0;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PontajRuleList.this.toEdit != null) {
                    if (DialogUtils.confirmDialog(parent, "Stergem aceasta regula", LangRoAll.confirmare)) {
                        PontajLogic.getInstance().deleteRule(PontajRuleList.this.toEdit.getId());
                    }
                    PontajRuleList.this.refreshTable();
                    PontajRuleList.this.setObjectToEdit(null);
                    PontajRuleList.this.nume.requestFocus();
                }
            }
        });
        result.add((Component)sterge, c);
        c.gridx = 2;
        c.gridy = 0;
        JTabbedPane shifts = new JTabbedPane();
        this.lucru = new PontajShiftPanel(1);
        this.lucru.doStuff();
        shifts.add("Lucru", this.lucru);
        this.pauza = new PontajShiftPanel(2);
        this.pauza.doStuff();
        shifts.add("Pauza", this.pauza);
        c.gridwidth = 2;
        c.gridheight = 6;
        result.add((Component)shifts, c);
        result.setBorder(new TitledBorder("Salvare/stergere"));
        return result;
    }

    public void setObjectToEdit(PontajRule toEdit) {
        if (toEdit != null) {
            this.nume.setText(toEdit.getNume());
            this.early.setText(toEdit.getEarly() + "");
            this.late.setText(toEdit.getLate() + "");
            this.overtime.setText(toEdit.getOvertime() + "");
            Vector lucruShifts = PontajLogic.getInstance().getPontajShifts(toEdit.getId(), 1);
            this.lucru.setShifts(lucruShifts);
            this.lucru.refreshTable();
            Vector pauzaShifts = PontajLogic.getInstance().getPontajShifts(toEdit.getId(), 2);
            this.pauza.setShifts(pauzaShifts);
            this.pauza.refreshTable();
        } else {
            this.nume.setText("");
            this.early.setText("");
            this.late.setText("");
            this.overtime.setText("");
            this.lucru.setShifts(new Vector());
            this.pauza.setShifts(new Vector());
            this.lucru.refreshTable();
            this.pauza.refreshTable();
        }
        this.toEdit = toEdit;
    }

    @Override
    public Vector buildData() {
        return PontajLogic.getInstance().getAllRules();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Nume", "Inainte necontorizat", "Intarziere permisa", "Prag ore suplimentare"};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    PontajRule sc = (PontajRule)PontajRuleList.this.tm.getObjectAt(selRow);
                    PontajRuleList.this.setObjectToEdit(sc);
                }
            }
        });
    }
}

