/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.pontaj.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.pontaj.PontajShift;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PontajShiftPanel
extends AbstractListPanel {
    private JTextField startT;
    private JTextField stopT;
    private PontajShift toEdit;
    private int tip;
    private Vector shifts = new Vector();

    public PontajShiftPanel(int tip) {
        this.tip = tip;
    }

    public Vector getShifts() {
        return this.shifts;
    }

    public void setShifts(Vector shifts) {
        this.shifts = shifts;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PontajShift shift = (PontajShift)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return Formatters.TIME_FORMAT.format(shift.getOraStart());
                    }
                    case 1: {
                        return Formatters.TIME_FORMAT.format(shift.getOraStop());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Ora start"), c);
        ++c.gridx;
        this.startT = new JTextField(5);
        result.add((Component)this.startT, c);
        ++c.gridx;
        result.add((Component)new JLabel("Ora stop"), c);
        ++c.gridx;
        this.stopT = new JTextField(5);
        result.add((Component)this.stopT, c);
        final PontajShiftPanel parent = this;
        ++c.gridx;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String start = PontajShiftPanel.this.startT.getText();
                String stop = PontajShiftPanel.this.stopT.getText();
                if (!Validators.correctDate(start, Formatters.TIME_FORMAT)) {
                    DialogUtils.errorDialog(parent, "Camp Ora start incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctDate(stop, Formatters.TIME_FORMAT)) {
                    DialogUtils.errorDialog(parent, "Camp Ora stop incorect", LangRoAll.nuPotContinua);
                    return;
                }
                Date d1 = DateUtils.setTimeToDate2(new Date(), PontajShiftPanel.this.startT);
                Timestamp t1 = new Timestamp(d1.getTime());
                Date d2 = DateUtils.setTimeToDate2(new Date(), PontajShiftPanel.this.stopT);
                Timestamp t2 = new Timestamp(d2.getTime());
                if (PontajShiftPanel.this.toEdit != null) {
                    PontajShiftPanel.this.toEdit.setOraStart(t1);
                    PontajShiftPanel.this.toEdit.setOraStop(t2);
                    PontajShiftPanel.this.tm.fireTableDataChanged();
                    PontajShiftPanel.this.setObjectToEdit(null);
                    PontajShiftPanel.this.startT.requestFocus();
                } else {
                    PontajShift newObj = new PontajShift();
                    newObj.setOraStart(t1);
                    newObj.setOraStop(t2);
                    newObj.setTip(PontajShiftPanel.this.tip);
                    PontajShiftPanel.this.tm.getData().add(newObj);
                    PontajShiftPanel.this.tm.fireTableDataChanged();
                    PontajShiftPanel.this.setObjectToEdit(null);
                    PontajShiftPanel.this.startT.requestFocus();
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PontajShiftPanel.this.toEdit != null) {
                    if (DialogUtils.confirmDialog(parent, "Stergem", LangRoAll.confirmare)) {
                        PontajShiftPanel.this.shifts.remove(PontajShiftPanel.this.toEdit);
                    }
                    PontajShiftPanel.this.tm.fireTableDataChanged();
                    PontajShiftPanel.this.setObjectToEdit(null);
                    PontajShiftPanel.this.startT.requestFocus();
                }
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder("Salvare/stergere"));
        return result;
    }

    private void setObjectToEdit(PontajShift toEdit) {
        if (toEdit != null) {
            this.startT.setText(Formatters.TIME_FORMAT.format(toEdit.getOraStart()));
            this.stopT.setText(Formatters.TIME_FORMAT.format(toEdit.getOraStop()));
        } else {
            this.startT.setText("");
            this.stopT.setText("");
        }
        this.toEdit = toEdit;
    }

    @Override
    public Vector buildData() {
        return this.shifts;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Ora start", "Ora stop"};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    PontajShift sc = (PontajShift)PontajShiftPanel.this.tm.getObjectAt(selRow);
                    PontajShiftPanel.this.setObjectToEdit(sc);
                }
            }
        });
    }
}

