/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print;

import java.util.Map;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterSale;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ProguardKeepNames;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.multilang.LangRoAll;

public abstract class AbstractPrinter
extends LangRoAll
implements ProguardKeepNames {
    protected PrintService printService;
    protected DocFlavor flavor;
    protected PrintRequestAttributeSet attributeSet;
    protected Config config;
    protected String entity;
    protected String phone;
    protected String address;
    protected String societate;
    protected String cui;
    protected String iban;
    protected String banca;
    protected String j;
    protected boolean atreidesPromo;
    protected boolean notaSaleOnOneLine;
    protected int charsPerLine;
    protected Vector notaExemplare = new Vector();
    protected DocFlavor[] supportedFlavours;

    public AbstractPrinter() {
        this.config = Config.getInstance();
        this.entity = this.config.getString("entityName");
        this.phone = this.config.getString("phone");
        this.address = this.config.getString("address");
        this.atreidesPromo = this.config.getBoolean("atreidesPromo");
        this.charsPerLine = this.config.getInt("charsPerLine");
        String s = this.config.getString("notaExemplare");
        this.notaExemplare = Utils.splitString(s, ',');
        this.notaSaleOnOneLine = this.config.getBoolean("notaSaleOnOneLine");
    }

    public void setFlavor(DocFlavor flavor) {
        this.flavor = flavor;
    }

    public void setAttributeSet(PrintRequestAttributeSet attributeSet) {
        this.attributeSet = attributeSet;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public abstract boolean isPdfPrinter();

    public abstract void printPdf(String var1, int var2);

    public abstract void printBonLivrare(Vector<PrinterBonItem> var1, String var2, String var3, String var4, double var5);

    public abstract String printBon(Vector<PrinterBonItem> var1, String var2, boolean var3, String var4, String var5, String var6, int var7, String var8, String var9, boolean var10, String var11, String var12, String var13);

    public abstract void printText(Vector var1, boolean var2);

    public abstract void print2ColumnText(Vector var1, boolean var2);

    public abstract void printNota(Vector<PrinterSale> var1, String var2, String var3, String var4, String var5, String var6, boolean var7, String var8, Vector var9, String var10, int var11, String var12, String var13, String var14, String var15, String var16, String var17);

    public abstract void printFactura(String var1, int var2);

    public abstract void printPVCustodie(String var1, int var2);

    public String getName() {
        return this.printService.getName();
    }

    public abstract void printBarcodeLabel(String var1, String var2, String var3, String var4);

    public abstract void printBarcodeLot(Map<Constants.ETICHETA_LOT_FIELDS, String> var1, int var2);

    public DocFlavor[] getSupportedFlavours() {
        return this.supportedFlavours;
    }

    public void setSupportedFlavours(DocFlavor[] supportedFlavours) {
        this.supportedFlavours = supportedFlavours;
    }
}

