/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print;

import java.awt.Component;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.xml.transform.TransformerException;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateException;
import net.sf.jooreports.templates.DocumentTemplateFactory;
import org.apache.fop.apps.FOPException;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.FacturaEmitent;
import ro.atreides.print.PrintPreview;
import ro.atreides.print.PrintUtils;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterEntry;
import ro.atreides.print.PrinterInterface;
import ro.atreides.print.PrinterSale;
import ro.atreides.print.db.PrintersImpl;
import ro.atreides.print.gui.PrintSelectDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.Constants;
import ro.atreides.utils.FacturiAfterAddInterface;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.SectiiProvider;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;

public class PrintLogic {
    private static final String PRINTERS_BASE_PATH = "ro.atreides.print.printers.";
    private static final DocFlavor DOC_FLAVOR_FORMAT = DocFlavor.BYTE_ARRAY.AUTOSENSE;
    public static final String TEMPLATE_AVIZ_FILE = "template_aviz_openoffice.odt";
    public static final String TEMPLATE_CHITANTA_FILE = "template_chitanta_openoffice.odt";
    public static final String TEMPLATE_FACTURA_FILE = "template_factura_openoffice.odt";
    public static final String TEMPLATE_FACTURA_CU_CHITANTA_FILE = "template_factura_cu_chitanta_openoffice.odt";
    public static final String TEMPLATE_OFERTA_FILE = "template_oferta_openoffice.odt";
    public static final String TEMPLATE_BLOCHEAZA_CANTITATE_FILE = "template_blocheaza_openoffice.odt";
    private PrintRequestAttributeSet _aset = new HashPrintRequestAttributeSet();
    private Vector<PrinterEntry> printers;
    private SectiiProvider sectiiProvider;
    private PrinterInterface printerInterface;
    private static PrintLogic instance;
    private LanguageProvider languageProvider;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private PrintLogic() {
        Vector<String> errors = this.reloadPrinters();
        if (errors.size() > 0) {
            DialogUtils.bulletedWarningDialog(GuiUtils.currentFrame, errors, LangRoAll.atentie);
        }
    }

    public static synchronized PrintLogic getInstance() {
        if (instance == null) {
            instance = new PrintLogic();
        }
        return instance;
    }

    private synchronized PrintersImpl getPrintersImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        PrintersImpl dao = null;
        while (dao == null) {
            dao = (PrintersImpl)this.pool.getDao(PrintersImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(PrintersImpl.class.getName(), connection);
        }
        return dao;
    }

    public void setLanguageProvider(LanguageProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    public Vector getSectii() {
        return this.sectiiProvider.getSectii();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getItems() {
        try {
            Vector result;
            Vector vector = result = this.getPrintersImpl().getAllItems(this.languageProvider.getCurrentUserLanguage());
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void setSectiiProvider(SectiiProvider sectiiProvider) {
        this.sectiiProvider = sectiiProvider;
    }

    private String setServiceToPrinterEntry(PrintService ps, PrinterEntry printerEntry) {
        try {
            String result = null;
            AbstractPrinter ap = (AbstractPrinter)Class.forName(this.getFullClassname(printerEntry.getClassname())).newInstance();
            DocFlavor[] df = ps.getSupportedDocFlavors();
            ap.setSupportedFlavours(df);
            if (df == null) {
                result = "Imprimanta " + ps.getName() + " nu e pornita ! ";
            }
            ap.setFlavor(DOC_FLAVOR_FORMAT);
            ap.setAttributeSet(this._aset);
            ap.setPrintService(ps);
            printerEntry.setPrinterType(ap);
            return result;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            return e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Vector<String> readPrintersFromDB(HashMap<String, PrintService> uniquePrinters) {
        Vector<String> errors = new Vector<String>();
        Vector<PrinterEntry> newPrinters = new Vector<PrinterEntry>();
        try {
            Vector<PrinterEntry> dbPrinters = this.getPrintersImpl().getPrinters(Utils.getLocalComputerName());
            this.pool.commit();
            for (PrinterEntry element : dbPrinters) {
                String err;
                String printerName = element.getName();
                PrintService ps = uniquePrinters.get(printerName);
                if (ps != null) {
                    err = this.setServiceToPrinterEntry(ps, element);
                    newPrinters.add(element);
                    if (err == null || element.getItems().size() <= 0 && element.getCategories().size() <= 0) continue;
                    errors.add(err);
                    continue;
                }
                if (element.getItems().size() > 0 || element.getCategories().size() > 0) {
                    err = "Imprimanta " + printerName + " a fost dezinstalata din sistem, dar este folosita in program  !! ";
                    Logger.logWarning(this, err);
                    errors.add(err);
                    continue;
                }
                err = "Imprimanta " + printerName + " a fost dezinstalata din sistem, dar nu este folosita in program si pot s-o sterg !! ";
                Logger.logWarning(this, err);
                this.getPrintersImpl().deletePrinter(element.getId());
                this.pool.commit();
            }
            for (String newPrinterName : uniquePrinters.keySet()) {
                boolean found = false;
                for (int j = 0; j < dbPrinters.size() && !found; ++j) {
                    PrinterEntry printerEntry = dbPrinters.elementAt(j);
                    if (!printerEntry.getName().equalsIgnoreCase(newPrinterName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                PrinterEntry p = new PrinterEntry();
                p.setName(newPrinterName);
                p.setClassname("AsciiPrinter");
                this.getPrintersImpl().addPrinter(p, Utils.getLocalComputerName());
                int id = this.pool.getIdentityLocal();
                p.setId(id);
                this.pool.commit();
                this.setServiceToPrinterEntry(uniquePrinters.get(newPrinterName), p);
                newPrinters.add(p);
            }
            this.pool.commit();
            this.printers = newPrinters;
        }
        catch (SQLException e1) {
            Logger.logException(this, (Exception)e1);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            errors.add(e1.getMessage());
        }
        finally {
            this.pool.releaseConnection();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePrinters(Vector modified) {
        for (int i = 0; i < modified.size(); ++i) {
            PrinterEntry printerEntry = (PrinterEntry)modified.elementAt(i);
            try {
                this.getPrintersImpl().updatePrinter(printerEntry);
                this.pool.commit();
                continue;
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
                continue;
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    private String getFullClassname(String relativeClassName) {
        return PRINTERS_BASE_PATH + relativeClassName;
    }

    private Vector choosePrinters(int whatToPrint) {
        Vector<PrinterEntry> result = new Vector<PrinterEntry>();
        block0: for (PrinterEntry element : this.printers) {
            for (Integer item : element.getItems().keySet()) {
                if (item != whatToPrint) continue;
                result.add(element);
                continue block0;
            }
        }
        return result;
    }

    private Vector choosePrintersForNota(Location locatie) {
        Vector<PrinterEntry> result = new Vector<PrinterEntry>();
        for (PrinterEntry element : this.printers) {
            AbstractPrinter ap;
            if (!this.printerInterface.printsNota(locatie, element) || (ap = element.getPrinterType()) == null) continue;
            result.add(element);
        }
        return result;
    }

    public void printNota(Vector<PrinterSale> sales, String discount, String totalInainteDiscount, String totalDupaDiscount1, String waiter, String table, boolean protocol, String tva, Vector plati, String promoName, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, Location locatie, AbstractPrinter forcedPrinter, String notaValutaText, String cnpClient, String serieAct) {
        String total = totalInainteDiscount;
        String totalDupaDiscount = totalDupaDiscount1;
        if (Validators.correctString(notaValutaText)) {
            total = total + " " + notaValutaText;
            totalDupaDiscount = totalDupaDiscount + " " + notaValutaText;
        }
        if (forcedPrinter == null) {
            Vector printers = this.choosePrintersForNota(locatie);
            for (PrinterEntry element : printers) {
                AbstractPrinter ap = element.getPrinterType();
                if (ap != null) {
                    Logger.logDebugVerbose(this, "Printing on : " + ap.getClass().getName());
                    ap.printNota(sales, discount, total, totalDupaDiscount, waiter, table, protocol, tva, plati, promoName, nrNota, adresaClient, numeClient, telefonClient, detaliiNota, cnpClient, serieAct);
                    continue;
                }
                Logger.logWarning(this, "Invalid printing configuration, run printing config tool");
            }
        } else {
            forcedPrinter.printNota(sales, discount, total, totalDupaDiscount, waiter, table, protocol, tva, plati, promoName, nrNota, adresaClient, numeClient, telefonClient, detaliiNota, cnpClient, serieAct);
        }
    }

    public Vector getAllPrintersForPrintDialog() {
        Vector<AbstractPrinter> result = new Vector<AbstractPrinter>();
        for (PrinterEntry element : this.printers) {
            AbstractPrinter ap = element.getPrinterType();
            result.add(ap);
        }
        return result;
    }

    public AbstractPrinter printerSelectionDialog() {
        Vector availablePrintersForBon = this.getAllPrintersForPrintDialog();
        PrintSelectDialog dialog = new PrintSelectDialog(4, availablePrintersForBon);
        AbstractPrinter selected = dialog.getSelected();
        return selected;
    }

    public String printBon(Vector<PrinterBonItem> items, String ospatar, String cat, String table, String nrBon, boolean protocol, int copii, Object categoryObj, Object locatieObj, String total, AbstractPrinter forcedPrinter, String detaliiLivrare, boolean cutter, String adresaClient, String numeClient, String telefonClient) {
        String result = "";
        if (forcedPrinter == null) {
            for (PrinterEntry element : this.printers) {
                if (!this.printerInterface.printsBon(categoryObj, locatieObj, element)) continue;
                AbstractPrinter ap = element.getPrinterType();
                if (ap != null) {
                    result = ap.printBon(items, ospatar, protocol, nrBon, table, cat, copii, total, detaliiLivrare, cutter, adresaClient, numeClient, telefonClient);
                    continue;
                }
                Logger.logError((Object)this, "Printer for element " + element + " is NULL !!! ");
            }
        } else {
            result = forcedPrinter.printBon(items, ospatar, protocol, nrBon, table, cat, copii, total, detaliiLivrare, cutter, adresaClient, numeClient, telefonClient);
        }
        return result;
    }

    public String preparePrint2ColumnText(Vector data) {
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < data.size(); ++i) {
            String line = (String)data.elementAt(i);
            content.append(line);
            content.append('\n');
        }
        try {
            String foFile = PrintLogic.wrapText(content.toString(), "wrapper_2columns.txt");
            String outFile = FileUtils.getTempDir() + File.separator + "bon.txt";
            FileWriter fw = new FileWriter(outFile);
            fw.write(foFile);
            fw.close();
            return outFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public static String wrapText(String text, String wrapperTemplate) throws IOException {
        String inFile = "conf" + File.separator + wrapperTemplate;
        String foFile = FileUtils.readFileToString(inFile);
        text = TextUtils.escapeForXML(text);
        foFile = foFile.replaceAll("%%content%%", text);
        return foFile;
    }

    public void print2ColumnText(Vector data, int copii) {
        StringBuffer content = new StringBuffer();
        for (int i = 0; i < data.size(); ++i) {
            String line = (String)data.elementAt(i);
            content.append(line);
            content.append('\n');
        }
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_reports"));
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) continue;
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < copii; ++i) {
                v.add(content.toString());
            }
            ap.print2ColumnText(v, true);
        }
    }

    public void printBonLivrare(Vector<PrinterBonItem> livrareItems, String ospatar, String table, String data, double valoare) {
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_livrare"));
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) continue;
            ap.printBonLivrare(livrareItems, ospatar, table, data, valoare);
        }
    }

    public void printReport(Component parent, ReportInterface pdfInter, Vector data) {
        this.printReport(parent, pdfInter, null, data);
    }

    public Hashtable<String, String> printReport(Component parent, ReportInterface pdfInter, ReportInterface asciiInter, Vector data) {
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_reports"));
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) {
                DialogUtils.errorDialog(parent, "Va rugam reconfigurati imprimanta " + element.getName(), "Nu pot tipari");
                continue;
            }
            if (ap.isPdfPrinter()) {
                String pdfContent = this.buildReportPdfText(data, pdfInter);
                ap.printPdf(pdfContent, 1);
                result.put("pdf", pdfContent);
                continue;
            }
            if (asciiInter == null) continue;
            String asciiContent = this.buildReportAsciiText(data, asciiInter);
            Vector<String> v = new Vector<String>();
            v.add(asciiContent);
            ap.printText(v, true);
            result.put("txt", asciiContent);
        }
        return result;
    }

    public String buildReportAsciiText(Vector data, ReportInterface inter) {
        StringBuffer buf = new StringBuffer();
        buf.append(inter.getReportTitle());
        buf.append('\n');
        String criteria = "";
        Hashtable hs = inter.getCriteria();
        for (String key : hs.keySet()) {
            Object value = hs.get(key);
            criteria = criteria + key + ": " + value + "\n";
        }
        buf.append(criteria);
        buf.append('\n');
        for (int i = 0; i < data.size(); ++i) {
            Object row = data.elementAt(i);
            for (int j = 0; j < inter.getColumnCount(); ++j) {
                buf.append(inter.getCellContent(row, j));
                buf.append(" ");
            }
            buf.append('\n');
        }
        buf.append('\n');
        for (int j = 0; j < inter.getColumnCount(); ++j) {
            buf.append(inter.getTotal(j));
            buf.append('\n');
        }
        buf.append('\n');
        return buf.toString();
    }

    public String buildReportPdfText(Vector data, ReportInterface inter) {
        try {
            String templateFile = "conf/A4Report.txt";
            String fullFile = FileUtils.readFileToString(templateFile);
            String width = "21cm";
            String height = "29.7cm";
            int mms = 190;
            if (inter.isLandscape()) {
                width = "29.7cm";
                height = "21cm";
                mms = 277;
            }
            fullFile = fullFile.replaceAll("%%height%%", height);
            fullFile = fullFile.replaceAll("%%width%%", width);
            String title = inter.getReportTitle();
            fullFile = fullFile.replaceAll("%%title%%", title);
            String criteria = "";
            Hashtable hs = inter.getCriteria();
            Vector v = new Vector(hs.keySet());
            Collections.sort(v);
            for (int i = 0; i < v.size(); ++i) {
                String key = (String)v.elementAt(i);
                Object value = hs.get(key);
                criteria = criteria + key + ": " + value + "\n";
            }
            fullFile = fullFile.replaceAll("%%criteria%%", criteria);
            int fullWidth = 0;
            for (int j = 0; j < inter.getColumnCount(); ++j) {
                fullWidth += inter.getColumnSize(j);
            }
            double ratio = mms / fullWidth;
            String columns = "";
            for (int j = 0; j < inter.getColumnCount(); ++j) {
                int currentCol = (int)ratio * inter.getColumnSize(j);
                if (inter.getColumnSize(j) <= 0) continue;
                columns = columns + "<fo:table-column column-width=\"" + currentCol + "mm\" />" + "\n";
            }
            fullFile = fullFile.replaceAll("%%columns%%", columns);
            StringBuffer header = new StringBuffer();
            for (int j = 0; j < inter.getColumnCount(); ++j) {
                if (inter.getColumnSize(j) <= 0) continue;
                this.getPdfReportCell(1, inter.getColumnName(j), header, true);
                header.append('\n');
            }
            fullFile = fullFile.replaceAll("%%header%%", header.toString());
            StringBuffer content = new StringBuffer();
            for (int i = 0; i < data.size(); ++i) {
                Object row = data.elementAt(i);
                this.getPdfReportLine(row, inter, content);
                content.append('\n');
            }
            fullFile = fullFile.replaceAll("%%content%%", content.toString());
            StringBuffer total = new StringBuffer();
            for (int j = 0; j < inter.getColumnCount(); ++j) {
                this.getPdfReportCell(1, inter.getTotal(j), total, true);
                total.append('\n');
            }
            fullFile = fullFile.replaceAll("%%totals%%", total.toString());
            String filename = FileUtils.getTempDir() + File.separator + "A4report.fo";
            FileWriter fw = new FileWriter(filename);
            fw.write(fullFile);
            fw.close();
            return filename;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private void getPdfReportCell(int colsSpanned, String text, StringBuffer result, boolean bold) {
        String text1 = TextUtils.escapeForXML(text);
        result.append("<fo:table-cell border-width=\"0.02mm\" border-style=\"solid\" number-columns-spanned=\"");
        result.append(colsSpanned);
        result.append("\" display-align=\"center\"><fo:block white-space-collapse=\"false\" text-align=\"start\"");
        if (bold) {
            result.append(" font-weight=\"bold\"");
        }
        result.append(">");
        result.append(text1);
        result.append("</fo:block>");
        result.append("</fo:table-cell>");
    }

    private void getPdfReportLine(Object o, ReportInterface inter, StringBuffer line) {
        line.append("<fo:table-row>");
        for (int j = 0; j < inter.getColumnCount(); ++j) {
            if (inter.getColumnSize(j) <= 0) continue;
            this.getPdfReportCell(1, inter.getCellContent(o, j), line, false);
            line.append('\n');
        }
        line.append("</fo:table-row>");
    }

    public void printRaportInchidere(String title, String text, int copii) {
        this.printRaport(title, text, copii, "printer_items_zReports");
    }

    public void printRaport(String title, String text, int copii) {
        this.printRaport(title + " : " + Utils.getCurrentDateAndTimeForPrinter(), text, copii, "printer_items_reports");
    }

    private void printRaport(String title, String text, int copii, String documentType) {
        int charsPerLine = Config.getInstance().getInt("charsPerLine");
        String startOfLine = "\n" + VpConfig.getInstance().raportInchiderePreambul;
        if (Validators.correctString(VpConfig.getInstance().raportInchiderePreambul)) {
            title = title.replaceAll("(\r\n|\n)", startOfLine);
            text = text.replaceAll("(\r\n|\n)", startOfLine);
        }
        String s = VpConfig.getInstance().raportInchiderePreambul + Utils.getStringMaxSize(charsPerLine, "", Character.valueOf('-'), false) + startOfLine;
        s = s + Utils.arrange(title, "", charsPerLine, ' ') + startOfLine + startOfLine;
        s = s + text;
        s = s + startOfLine + Utils.getStringMaxSize(charsPerLine, "", Character.valueOf('-'), false) + "\n";
        Vector printers = this.choosePrinters(this.getPrinterItemByKey(documentType));
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) continue;
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < copii; ++i) {
                v.add(s);
            }
            ap.printText(v, true);
        }
    }

    public boolean printPdf(String pdfContent, int copii) throws UnsupportedOperationException {
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_reports"));
        boolean printed = false;
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (!ap.isPdfPrinter()) continue;
            ap.printPdf(pdfContent, copii);
            printed = true;
        }
        return printed;
    }

    public void setPrinterInterface(PrinterInterface printerInterface) {
        this.printerInterface = printerInterface;
    }

    private int getPrinterItemByKeyNoCommit(String key) throws SQLException {
        int result = this.getPrintersImpl().getPrinterItemIdByKey(key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPrinterItemByKey(String key) {
        try {
            int n = this.getPrinterItemByKeyNoCommit(key);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printFactura(String toPrint, int nrCopii) {
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_facturi"));
        for (PrinterEntry element : printers) {
            element.getPrinterType().printFactura(toPrint, nrCopii);
        }
    }

    public void printPVCustodie(String toPrint, int nrCopii) {
        Vector printers = this.choosePrinters(this.getPrinterItemByKey("printer_items_facturi"));
        for (PrinterEntry element : printers) {
            element.getPrinterType().printPVCustodie(toPrint, nrCopii);
        }
    }

    public void deleteAllPrinterMappings() throws SQLException {
        this.getPrintersImpl().deleteAllMappings();
    }

    public void printPreview(String foFile) {
        try {
            PrintPreview app = new PrintPreview();
            app.viewFO(new File(foFile));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (FOPException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (TransformerException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String prepareFacturaPdf(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String nrFactura, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral) throws IOException {
        return this.prepareFacturaPVCustodiePdf(titlu, cumparator, j, cui, sediu, judet, iban, banca, nrFactura, data, items, totalFaraTva, totalTva, totalGeneral, "factura.txt", "factura_line.txt");
    }

    public String preparePVCustodiePdf(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String nrFactura, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral) throws IOException {
        return this.prepareFacturaPVCustodiePdf(titlu, cumparator, j, cui, sediu, judet, iban, banca, nrFactura, data, items, totalFaraTva, totalTva, totalGeneral, "pvcustodie.txt", "pvcustodie_line.txt");
    }

    private String prepareFacturaPVCustodiePdf(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String nrFactura, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral, String bigFile, String lineFile) throws IOException {
        String inFile = "conf" + File.separator + bigFile;
        String inFacturaFile = "conf" + File.separator + lineFile;
        String foFile = FileUtils.readFileToString(inFile);
        foFile = foFile.replaceAll("%%titlu%%", titlu);
        foFile = foFile.replaceAll("%%data%%", data);
        foFile = foFile.replaceAll("%%nrFactura%%", nrFactura);
        Config conf = Config.getInstance();
        String adresaEmitent = conf.getString("sediu");
        String emitent = conf.getString("societate");
        String cui_emitent = conf.getString("cui");
        String jEmitent = conf.getString("j");
        String contEmitent = conf.getString("iban");
        String bancaEmitent = conf.getString("banca");
        foFile = foFile.replaceAll("%%adresa_emitent%%", TextUtils.escapeForXML(adresaEmitent));
        foFile = foFile.replaceAll("%%emitent%%", TextUtils.escapeForXML(emitent));
        foFile = foFile.replaceAll("%%cui_emitent%%", TextUtils.escapeForXML(cui_emitent));
        foFile = foFile.replaceAll("%%j_emitent%%", TextUtils.escapeForXML(jEmitent));
        foFile = foFile.replaceAll("%%cont_emitent%%", TextUtils.escapeForXML(contEmitent));
        foFile = foFile.replaceAll("%%banca_emitent%%", TextUtils.escapeForXML(bancaEmitent));
        foFile = foFile.replaceAll("%%beneficiar%%", TextUtils.escapeForXML(cumparator));
        foFile = foFile.replaceAll("%%cui_beneficiar%%", TextUtils.escapeForXML(cui));
        foFile = foFile.replaceAll("%%j_beneficiar%%", TextUtils.escapeForXML(j));
        foFile = foFile.replaceAll("%%adresa_beneficiar%%", TextUtils.escapeForXML(sediu + " " + judet));
        foFile = foFile.replaceAll("%%cont_beneficiar%%", TextUtils.escapeForXML(iban));
        foFile = foFile.replaceAll("%%banca_beneficiar%%", TextUtils.escapeForXML(banca));
        foFile = foFile.replaceAll("%%valoare%%", TextUtils.escapeForXML(totalFaraTva));
        foFile = foFile.replaceAll("%%valoare_tva%%", TextUtils.escapeForXML(totalTva));
        foFile = foFile.replaceAll("%%total_general%%", TextUtils.escapeForXML(totalGeneral));
        String productsText = "";
        for (int i = 0; i < items.size(); ++i) {
            FacturaItemView item = (FacturaItemView)items.elementAt(i);
            productsText = productsText + this.getFacturaLine(inFacturaFile, i + 1, item.getProdus(), item.getUm(), Utils.getString2Decimals(item.getPpuFaraTva()), Utils.getString2Decimals(item.getPpuCuTva()), Utils.getString3Decimals(item.getCantitate()), Utils.getString2Decimals(item.getValoare()), Utils.getString2Decimals(item.getValoareTva()), Utils.getString2Decimals(item.getValoareCuTva()), Utils.getString2Decimals(item.getCotaTva()));
        }
        foFile = foFile.replaceAll("%%products%%", productsText);
        String outFile = FileUtils.getTempDir() + File.separator + "factura.fo";
        FileWriter fw = new FileWriter(outFile);
        fw.write(foFile);
        fw.close();
        return outFile;
    }

    private String getFacturaLine(String inFile, int nrCrt, String product, String um, String ppu, String ppuCuTva, String quantity, String valoare, String valoareTva, String valoareCuTva, String cotaTva) throws IOException {
        String productEscaped = TextUtils.escapeForXML(product);
        String linie = FileUtils.readFileToString(inFile);
        linie = linie.replaceAll("%%nr%%", nrCrt + "");
        linie = linie.replaceAll("%%produs%%", productEscaped);
        linie = linie.replaceAll("%%um%%", um);
        linie = linie.replaceAll("%%cant%%", quantity);
        linie = linie.replaceAll("%%ppu%%", ppu);
        linie = linie.replaceAll("%%ppu_cu_tva%%", ppuCuTva);
        linie = linie.replaceAll("%%valoare%%", valoare);
        linie = linie.replaceAll("%%valoare_cu_tva%%", valoareCuTva);
        linie = linie.replaceAll("%%tva%%", valoareTva);
        linie = linie.replaceAll("%%cota_tva%%", cotaTva);
        return linie + "\n";
    }

    public String getPlatiString(Vector plati) {
        String result = "";
        for (int i = 0; i < plati.size(); ++i) {
            Plata plata = (Plata)plati.elementAt(i);
            String s = Utils.getString2Decimals(plata.getSuma());
            String line = plata.getTipPlata() + "=" + s;
            result = result + line;
            String detalii = plata.getComment();
            if (Validators.correctString(detalii)) {
                result = result + " " + detalii;
            }
            if (i >= plati.size() - 1) continue;
            result = result + "\n";
        }
        return result;
    }

    public void printComponent(Printable toPrint) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(toPrint);
        try {
            printJob.print();
        }
        catch (PrinterException pe) {
            System.out.println("Error printing: " + pe);
        }
    }

    public Vector getLocations() {
        return this.printerInterface.getLocations();
    }

    public Vector<PrinterEntry> getPrinters() {
        return this.printers;
    }

    public Vector<String> reloadPrinters() {
        PrintService[] _services = PrintServiceLookup.lookupPrintServices(null, null);
        HashMap<String, PrintService> uniquePrinters = new HashMap<String, PrintService>();
        for (PrintService service : _services) {
            if (service != null) {
                String printerName = service.getName();
                PrintService alreadyAdded = uniquePrinters.get(printerName);
                PrintService toKeep = service;
                if (alreadyAdded != null && service.getSupportedDocFlavors() == null && alreadyAdded.getSupportedDocFlavors() != null) {
                    toKeep = alreadyAdded;
                }
                uniquePrinters.put(printerName, toKeep);
                continue;
            }
            Logger.logWarning(this, "Printer service is NULL !!");
        }
        Vector<String> errors = this.readPrintersFromDB(uniquePrinters);
        return errors;
    }

    public static String buildCategoryKey(int idSectie, int idLocatie) {
        return idSectie + "-" + idLocatie;
    }

    public static String buildNotePrinterKey(int idLocatie) {
        return LangRoAll.note + "-" + idLocatie;
    }

    public static int getIdFromKey(String key, int position) {
        Vector v = Utils.splitString(key, '-');
        String s = (String)v.get(position);
        return Integer.parseInt(s);
    }

    public String generateOdtDocument(String templateFile, Hashtable mapping, String outputFile) {
        try {
            DocumentTemplateFactory documentTemplateFactory = new DocumentTemplateFactory();
            DocumentTemplate template = documentTemplateFactory.getTemplate(new File(templateFile));
            template.createDocument((Object)mapping, (OutputStream)new FileOutputStream(outputFile));
            return outputFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (DocumentTemplateException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        return null;
    }

    public String getOpenOfficeManualPrintCommand() {
        String os = Utils.getOperatingSystem();
        String name = "print.openoffice.manual." + os;
        String value = Config.getInstance().getLocalProperty(name);
        if (value != null) {
            value = value.replaceAll("\"", "");
            value = value.replace("%file%", "");
            value = value.trim();
        }
        return value;
    }

    public String getOpenOfficeAutomaticPrintCommand() {
        String os = Utils.getOperatingSystem();
        String name = "print.openoffice.automatic." + os;
        String value = Config.getInstance().getLocalProperty(name);
        if (value != null) {
            value = value.replaceAll("\"", "");
            value = value.replace("%file%", "");
            value = value.replace("%printer%", "");
            value = value.replace("-pt", "");
            value = value.trim();
        }
        return value;
    }

    public boolean printFacturaOpenOffice(String path, String printKey) {
        boolean okMare = true;
        String cmd = this.getOpenOfficeManualPrintCommand();
        if (Validators.correctString(cmd)) {
            String[] c = new String[]{cmd, path};
            cmd = "\"" + c[0] + "\" \"" + c[1] + "\"";
            Logger.logInfo(this, "Print command manual: " + cmd);
            System.out.println("Print command manual: " + cmd);
            okMare = Utils.executeExternalCommandWithSpaces(c, FileUtils.getCurrentDirAsFile(), cmd);
        } else {
            cmd = this.getOpenOfficeAutomaticPrintCommand();
            if (Validators.correctString(cmd)) {
                Vector printers = this.choosePrinters(this.getPrinterItemByKey(printKey));
                Iterator iter = printers.iterator();
                while (iter.hasNext()) {
                    boolean ok = false;
                    try {
                        Logger.logInfo(this, "Path: " + path);
                        PrinterEntry element = (PrinterEntry)iter.next();
                        String printName = element.getName();
                        String[] c = new String[]{cmd, "-pt", printName, path};
                        cmd = "\"" + c[0] + "\" \"" + c[1] + "\" \"" + c[2] + "\" \"" + c[3] + "\"";
                        Logger.logInfo(this, "Print command automatic: " + cmd);
                        System.out.println("Print command automatic: " + cmd);
                        ok = Utils.executeExternalCommandWithSpaces(c, FileUtils.getCurrentDirAsFile(), cmd);
                    }
                    catch (Exception e) {
                        Logger.logException(this, e);
                        ok = false;
                        break;
                    }
                    okMare = okMare && ok;
                }
            }
        }
        return okMare;
    }

    private String printFactura(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String nrFactura, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral, int nrCopii) {
        try {
            String tempFile = this.prepareFacturaPdf(titlu, cumparator, j, cui, sediu, judet, iban, banca, nrFactura, data, items, totalFaraTva, totalTva, totalGeneral);
            String outFile = FileUtils.getCurrentDir() + File.separator + "data" + File.separator + "Factura_" + nrFactura + "_" + data + ".pdf";
            PrintUtils.printPdf(tempFile, outFile);
            this.printFactura(tempFile, nrCopii);
            return outFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private boolean tiparesteFacturaOdtOld(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String numarIntern, String data, Vector items, String totalFaraTva, String totalTva, String totalGeneral, String scadenta, String modPlata, String contract, String numeDelegat, String numeEmitent, String cnpEmitent, String seria, String seriaBuletin, String nrBuletin, String eliberatDe, String auto, String ora, String templateOdtFile, int maxLines) {
        int i;
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + templateOdtFile;
        String outputFile = FileUtils.getTempDir() + File.separator + "factura.odt";
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        mapping.put("titlu", titlu);
        mapping.put("cumparator", cumparator);
        mapping.put("j", j);
        mapping.put("cui", cui);
        mapping.put("sediu", sediu);
        mapping.put("judet", judet);
        mapping.put("iban", iban);
        mapping.put("banca", banca);
        mapping.put("nrFactura", numarIntern);
        mapping.put("data", data);
        mapping.put("totalFaraTva", totalFaraTva);
        mapping.put("totalTva", totalTva);
        mapping.put("totalGeneral", totalGeneral);
        mapping.put("scadenta", scadenta);
        mapping.put("modPlata", modPlata);
        mapping.put("contract", contract);
        mapping.put("h1", numeDelegat);
        mapping.put("numeEmitent", numeEmitent);
        mapping.put("cnpEmitent", cnpEmitent);
        mapping.put("h2", seriaBuletin);
        mapping.put("h3", nrBuletin);
        mapping.put("h4", eliberatDe);
        mapping.put("h5", auto);
        mapping.put("ora", ora);
        for (i = 0; i < items.size(); ++i) {
            FacturaItemView item = (FacturaItemView)items.elementAt(i);
            mapping.put("a" + i, "" + (i + 1));
            mapping.put("b" + i, item.getProdus());
            mapping.put("c" + i, item.getUm());
            mapping.put("d" + i, Utils.getString3Decimals(item.getCantitate()));
            mapping.put("e" + i, Utils.getString2Decimals(item.getPpuFaraTva()));
            mapping.put("f" + i, Utils.getString2Decimals(item.getValoare()));
            mapping.put("g" + i, Utils.getString2Decimals(item.getValoareTva()));
        }
        for (i = items.size(); i < maxLines; ++i) {
            mapping.put("a" + i, " ");
            mapping.put("b" + i, " ");
            mapping.put("c" + i, " ");
            mapping.put("d" + i, " ");
            mapping.put("e" + i, " ");
            mapping.put("f" + i, " ");
            mapping.put("g" + i, " ");
        }
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        return ok;
    }

    public String getStringForFurnizor(Hashtable furnizorData, String property) {
        String value = (String)furnizorData.get(property);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String tiparesteFacturaOdtNew(String titlu, String cumparator, String j, String cui, String sediu, String judet, String iban, String banca, String numarIntern, String data, Vector<FacturaItemView> items, String totalFaraTva, String totalTva, String totalGeneral, String scadenta, String modPlata, String contract, String numeDelegat, String numeEmitent, String cnpEmitent, String seria, String seriaBuletin, String nrBuletin, String eliberatDe, String auto, String ora, boolean chitanta, String templateOdtFile, String platit, FacturiAfterAddInterface afterAddInterface, int idClient, FacturaEmitent emitent, String totalFaraTvaV2, String totalTvaV2, String totalGeneralV2, String seriaChitanta, String numarChitanta, Hashtable optionsHash) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + templateOdtFile;
        String cumparatorFs = cumparator.replaceAll(" ", "_");
        String t = FileUtils.getTempDir();
        File f = new File(t);
        f.mkdirs();
        numarChitanta = seriaChitanta + " " + numarChitanta;
        String outputFile = t + File.separator + "factura_" + seria + "_" + numarIntern + "_" + cumparatorFs + ".odt";
        Hashtable<String, Object> mapping = new Hashtable<String, Object>();
        if (emitent == null) {
            mapping.put("furnizor_societate", Config.getInstance().getString("societate", ""));
            mapping.put("furnizor_sediu", Config.getInstance().getString("sediu", ""));
            mapping.put("furnizor_j", Config.getInstance().getString("j", ""));
            mapping.put("furnizor_cui", Config.getInstance().getString("cui", ""));
            mapping.put("furnizor_banca", Config.getInstance().getString("banca", ""));
            mapping.put("furnizor_iban", Config.getInstance().getString("iban", ""));
            mapping.put("furnizor_cs", Config.getInstance().getString("capital", ""));
        } else {
            mapping.put("furnizor_societate", emitent.getSocietate());
            mapping.put("furnizor_sediu", emitent.getSediu());
            mapping.put("furnizor_j", emitent.getJ());
            mapping.put("furnizor_cui", emitent.getCui());
            mapping.put("furnizor_banca", emitent.getBanca());
            mapping.put("furnizor_iban", emitent.getIban());
            mapping.put("furnizor_cs", emitent.getCapital());
        }
        mapping.put("title", titlu);
        mapping.put("serie", seria);
        mapping.put("cumparator", cumparator);
        mapping.put("j", j);
        mapping.put("cui", cui);
        mapping.put("sediu", sediu);
        mapping.put("judet", judet);
        mapping.put("iban", iban);
        mapping.put("banca", banca);
        mapping.put("numar", numarIntern);
        mapping.put("numar_chitanta", numarChitanta);
        mapping.put("data", data);
        mapping.put("totalFaraTva", totalFaraTva);
        mapping.put("totalTva", totalTva);
        mapping.put("totalGeneral", totalGeneral);
        mapping.put("totalFaraTva_v2", totalFaraTvaV2);
        mapping.put("totalTva_v2", totalTvaV2);
        mapping.put("totalGeneral_v2", totalGeneralV2);
        mapping.put("scadenta", scadenta);
        mapping.put("modPlata", modPlata);
        mapping.put("contract", contract);
        mapping.put("h1", numeDelegat);
        mapping.put("numeEmitent", numeEmitent);
        mapping.put("cnpEmitent", cnpEmitent);
        mapping.put("h2", seriaBuletin);
        mapping.put("h3", nrBuletin);
        mapping.put("h4", eliberatDe);
        mapping.put("h5", auto);
        mapping.put("ora", ora);
        mapping.put("chitanta_anulata", chitanta ? "" : " ANULATA !!");
        mapping.put("totalChitanta", chitanta ? platit : "0");
        ArrayList tableItems = new ArrayList();
        for (int i = 0; i < items.size(); ++i) {
            FacturaItemView facturaItemView = items.elementAt(i);
            ArrayList<String> row = new ArrayList<String>();
            row.add("" + (i + 1));
            row.add(facturaItemView.getProdus());
            row.add(facturaItemView.getUm());
            row.add(Utils.getString3Decimals(facturaItemView.getCantitate()));
            row.add(Utils.getStringXDecimals(facturaItemView.getPpuFaraTva(), VpConfig.getInstance().facturareRoundDecimals));
            row.add(Utils.getString2Decimals(facturaItemView.getValoare()));
            row.add(Utils.getString2Decimals(facturaItemView.getValoareTva()));
            row.add(Utils.getStringXDecimals(facturaItemView.getPpuFaraTva2(), VpConfig.getInstance().facturareRoundDecimals));
            row.add(Utils.getString2Decimals(facturaItemView.getValoare2()));
            row.add(Utils.getString2Decimals(facturaItemView.getValoareTva2()));
            row.add(facturaItemView.getProdusLine2Full());
            row.add(Utils.getString2Decimals(facturaItemView.getCotaTva() - 1.0));
            tableItems.add(row);
        }
        mapping.put("rows", tableItems);
        Object o = optionsHash.get("Valuta");
        if (o != null) {
            String s = (String)o;
            mapping.put("valuta_text", "Preturile sunt listate in " + s);
        } else {
            mapping.put("valuta_text", "");
        }
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        if (ok) {
            Double tot = FloatUtils.roundDouble(new Double(totalGeneral), VpConfig.getInstance().facturareRoundDecimals);
            String nodeTitle = "Factura " + seria + " Nr " + numarIntern + " " + cumparator + " " + tot;
            String nodeDescription = "";
            nodeDescription = nodeDescription + "Numar factura : " + seria + " " + numarIntern + "<br/>";
            nodeDescription = nodeDescription + "Client : " + cumparator + "<br/>";
            nodeDescription = nodeDescription + "Total : " + tot + "<br/>";
            Hashtable<String, Object> toadd = new Hashtable<String, Object>(mapping);
            toadd.put("node_title", nodeTitle);
            toadd.put("node_description", nodeDescription);
            Vector<String> nodeFiles = new Vector<String>();
            String outputFilePdf = outputFile.replace(".odt", ".pdf");
            nodeFiles.add(outputFile);
            nodeFiles.add(outputFilePdf);
            toadd.put("node_files", nodeFiles);
            toadd.put("id_client_key", idClient);
            GenericListenersLogic.getInstance().notifyObjectListeners(99, toadd);
        }
        if (afterAddInterface != null) {
            afterAddInterface.afterAdd(outputFile, titlu + " " + seria + " " + numarIntern + " / " + data, idClient);
        }
        if (ok) {
            return outputFile;
        }
        return null;
    }

    public boolean tiparesteChitanta(String numarIntern, String data, String cumparator, String cui, String sediu, String judet, String explicatii, String platit, String templateOdtFile, FacturiAfterAddInterface afterAddInterface, int idClient, String titlu) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + templateOdtFile;
        String outputFile = FileUtils.getTempDir() + File.separator + "chitanta_" + numarIntern + "_" + cumparator + ".odt";
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        mapping.put("explicatii", explicatii);
        mapping.put("totalChitanta", platit);
        mapping.put("numar", numarIntern);
        mapping.put("data", data);
        mapping.put("cumparator", cumparator);
        mapping.put("cui", cui);
        mapping.put("sediu", sediu);
        mapping.put("judet", judet);
        mapping.put("furnizor_societate", Config.getInstance().getString("societate", ""));
        mapping.put("furnizor_sediu", Config.getInstance().getString("sediu", ""));
        mapping.put("furnizor_j", Config.getInstance().getString("j", ""));
        mapping.put("furnizor_cui", Config.getInstance().getString("cui", ""));
        mapping.put("furnizor_banca", Config.getInstance().getString("banca", ""));
        mapping.put("furnizor_iban", Config.getInstance().getString("iban", ""));
        mapping.put("furnizor_cs", Config.getInstance().getString("capital", ""));
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        if (afterAddInterface != null) {
            afterAddInterface.afterAdd(outputFile, titlu + " " + numarIntern + " / " + data, idClient);
        }
        Map o = ContaLogic.getInstance().buildIncasareClientMap(numarIntern, explicatii, data, platit, cumparator, path);
        o.put("id_client_key", idClient);
        GenericListenersLogic.getInstance().notifyObjectListeners(86, o);
        return ok;
    }

    public void printEtichetaBarcodeRaft(String nume, String barcode, double pretOrig, double pretRedus) throws SQLException {
        Vector printers = this.choosePrinters(this.getPrinterItemByKeyNoCommit("printer_items_etichete"));
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) continue;
            ap.printBarcodeLabel(barcode, nume, Utils.getString2Decimals(pretOrig), Utils.getString2Decimals(pretRedus));
        }
    }

    public void printEtichetaBarcodeLot(Map<Constants.ETICHETA_LOT_FIELDS, String> map, int copies) throws SQLException {
        Vector printers = this.choosePrinters(this.getPrinterItemByKeyNoCommit("printer_items_etichete_lot"));
        for (PrinterEntry element : printers) {
            AbstractPrinter ap = element.getPrinterType();
            if (ap == null) continue;
            ap.printBarcodeLot(map, copies);
        }
    }
}

