/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import ro.atreides.nomenclatura.SectieEntry;
import ro.atreides.print.Item;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrinterEntry;
import ro.atreides.print.gui.PrinterPanelBean;
import ro.atreides.utils.Location;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class PrintersPanel
extends ReflectedJPanel {
    private PrintLogic logic;
    private JTable tabel;
    private JButton salveazaButton;
    private JButton resetButton;
    private Vector<PrinterEntry> currentPrinters = new Vector();
    private Vector data = new Vector();
    private AbstractTM model;

    private String[] buildColumns() {
        String[] result = new String[this.currentPrinters.size() + 1];
        result[0] = "";
        for (int i = 0; i < this.currentPrinters.size(); ++i) {
            PrinterEntry printerEntry = this.currentPrinters.elementAt(i);
            result[i + 1] = printerEntry.getName();
        }
        return result;
    }

    private Class[] buildClasses() {
        Class[] result = new Class[this.currentPrinters.size() + 1];
        result[0] = String.class;
        for (int i = 1; i < result.length; ++i) {
            result[i] = Boolean.class;
        }
        return result;
    }

    private void init() {
        this.model = new AbstractTM(this.buildColumns(), this.buildClasses(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PrinterPanelBean pen = (PrinterPanelBean)data.elementAt(rowIndex);
                if (columnIndex == 0) {
                    return pen.getCapTabel();
                }
                int realColumn = columnIndex - 1;
                return new Boolean(pen.isChecked(realColumn));
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex > 0;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                PrinterPanelBean pen = (PrinterPanelBean)data.elementAt(rowIndex);
                pen.toggleChecked(columnIndex - 1);
            }
        });
        this.tabel = new JTable(this.model);
        this.tabel.setSelectionMode(0);
        this.tabel.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        String save = LangRoAll.salveaza;
        String reset = "Valori initiale";
        this.salveazaButton = new JButton(save);
        this.salveazaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintersPanel.this.logic.savePrinters(PrintersPanel.this.currentPrinters);
                PrintersPanel.this.reloadFromDb();
            }
        });
        this.resetButton = new JButton(reset);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintersPanel.this.reloadFromDb();
            }
        });
    }

    @Override
    public void doStuff() {
    }

    public PrintersPanel() {
        this.logic = PrintLogic.getInstance();
        this.reloadFromDb();
    }

    private JComboBox buildPrinterTypes() {
        JComboBox<String> knownPrinters = new JComboBox<String>();
        knownPrinters.addItem("AsciiPrinter");
        knownPrinters.addItem("SlipPrinter");
        knownPrinters.addItem("LaserPrinter");
        knownPrinters.addItem("InkjetPrinter");
        knownPrinters.addItem("star.TSP600");
        knownPrinters.addItem("star.SP212");
        knownPrinters.addItem("epson.TMU220");
        knownPrinters.addItem("epson.ChineseTMU220");
        knownPrinters.addItem("epson.NewTMU220");
        knownPrinters.addItem("epson.TMT70");
        knownPrinters.addItem("PdfPrinter");
        knownPrinters.addItem("NewAsciiPrinter");
        knownPrinters.addItem("GuiAsciiPrinter");
        knownPrinters.addItem("GenericLabelPrinter");
        knownPrinters.addItem("datecs.EP50");
        knownPrinters.addItem("datecs.LP50");
        return knownPrinters;
    }

    private void reloadFromDb() {
        int i;
        Vector<String> errors = PrintLogic.getInstance().reloadPrinters();
        if (errors.size() > 0) {
            DialogUtils.bulletedWarningDialog(this, errors, LangRoAll.atentie);
        }
        this.currentPrinters = PrintLogic.getInstance().getPrinters();
        this.data.clear();
        Vector locations = this.logic.getLocations();
        Vector sectii = this.logic.getSectii();
        for (i = 0; i < sectii.size(); ++i) {
            SectieEntry se = (SectieEntry)sectii.elementAt(i);
            for (int j = 0; j < locations.size(); ++j) {
                Location l = (Location)locations.elementAt(j);
                PrinterPanelBean pen = new PrinterPanelBean(this.currentPrinters.size());
                pen.setCapTabel(se.getName() + "-" + l.getName());
                for (int k = 0; k < this.currentPrinters.size(); ++k) {
                    PrinterEntry printerEntry = this.currentPrinters.elementAt(k);
                    pen.setChecked(printerEntry.printsBonForCategory(se.getId(), l.getId()), k);
                    pen.setPe(printerEntry, k);
                }
                pen.setIdLocatie(l.getId());
                pen.setIdSectie(se.getId());
                this.data.add(pen);
            }
        }
        for (i = 0; i < locations.size(); ++i) {
            Location location = (Location)locations.elementAt(i);
            PrinterPanelBean pen = new PrinterPanelBean(this.currentPrinters.size());
            pen.setCapTabel("Note-" + location.getName());
            for (int k = 0; k < this.currentPrinters.size(); ++k) {
                PrinterEntry printerEntry = this.currentPrinters.elementAt(k);
                boolean check = printerEntry.printsNotaForCategory(location.getId());
                pen.setChecked(check, k);
                pen.setPe(printerEntry, k);
            }
            pen.setIdLocatie(location.getId());
            this.data.add(pen);
        }
        Vector items = this.logic.getItems();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            PrinterPanelBean pen = new PrinterPanelBean(this.currentPrinters.size());
            Item item = (Item)items.elementAt(i2);
            pen.setCapTabel(item.getLabel());
            for (int k = 0; k < this.currentPrinters.size(); ++k) {
                PrinterEntry printerEntry = this.currentPrinters.elementAt(k);
                pen.setChecked(printerEntry.printsItem(item.getId()), k);
                pen.setPe(printerEntry, k);
            }
            pen.setIdItem(item.getId());
            this.data.add(pen);
        }
        this.init();
        this.display(this.currentPrinters);
        this.model.refresh(this.data);
    }

    private void display(Vector printers) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.gridx = 0;
        c.anchor = 11;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel titlePanel = this.getTitlePanel("Configurare imprimanta");
        this.add((Component)titlePanel, c);
        ++c.gridy;
        c.weighty = 0.0;
        JPanel tipPanel = this.getTipImprimantaPanel(printers);
        this.add((Component)tipPanel, c);
        ++c.gridy;
        c.anchor = 10;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel tablePanel = this.getTablePanel();
        tablePanel.setBorder(new TitledBorder("Imprimante"));
        this.add((Component)tablePanel, c);
        c.anchor = 15;
        ++c.gridy;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel buttonsPanel = this.getButtonsPanel();
        buttonsPanel.setBorder(new TitledBorder(LangRoAll.actiuni));
        this.add((Component)buttonsPanel, c);
    }

    private JPanel getTitlePanel(String title) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(title), c);
        return p;
    }

    private JPanel getTablePanel() {
        JPanel tablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(5, 5, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        tablePanel.add((Component)new JScrollPane(this.tabel), c);
        return tablePanel;
    }

    private JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 10;
        buttonsPanel.add((Component)this.salveazaButton, c);
        ++c.gridx;
        c.anchor = 10;
        buttonsPanel.add((Component)this.resetButton, c);
        return buttonsPanel;
    }

    private JPanel getTipImprimantaPanel(Vector printers) {
        JPanel pricePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        for (int i = 0; i < printers.size(); ++i) {
            final PrinterEntry printerEntry = (PrinterEntry)printers.elementAt(i);
            JLabel label = new JLabel(printerEntry.getName());
            pricePanel.add((Component)label, c);
            ++c.gridx;
            final JComboBox tipes = this.buildPrinterTypes();
            tipes.setSelectedItem(printerEntry.getClassname());
            pricePanel.add((Component)tipes, c);
            tipes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selected = (String)tipes.getSelectedItem();
                    printerEntry.setClassname(selected);
                }
            });
            ++c.gridy;
            c.gridx = 0;
        }
        pricePanel.setBorder(new TitledBorder("Tip imprimanta"));
        return pricePanel;
    }
}

