/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class GenericSerialPrinter
extends Thread {
    Vector queue = new Vector();

    public String getModuleName() {
        return "GenericSerialPrinter";
    }

    public Collection getViews() {
        return null;
    }

    public void addToQueue(String job) {
        this.queue.add(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String portName = "/dev/ttyUSB4";
        SerialPort serialPort = null;
        if (Validators.correctString("/dev/ttyUSB4")) {
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Logger.logDebug(this, "initializing port: /dev/ttyUSB4");
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = "/dev/ttyUSB4".replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase("/dev/ttyUSB4") && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: /dev/ttyUSB4");
                portFound = true;
                break;
            }
            if (!portFound) {
                Logger.logDebug(this, "Port incorect: /dev/ttyUSB4");
                DialogUtils.errorDialog(GuiUtils.currentFrame, "GenericSerialPrinter: port incorect : \"/dev/ttyUSB4\"", LangRoAll.nuPotContinua);
                return;
            }
            try {
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: /dev/ttyUSB4");
                serialPort = (SerialPort)portId.open("GenericSerialPrinter", 2000);
                OutputStream out = serialPort.getOutputStream();
                InputStream in = serialPort.getInputStream();
                serialPort.setSerialPortParams(9600, 8, 1, 0);
                Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + serialPort.getBaudRate() + " dataBits=" + serialPort.getDataBits() + " stopBits=" + serialPort.getStopBits() + " parity=" + serialPort.getParity());
                while (true) {
                    if (this.queue.size() > 0) {
                        String job = (String)this.queue.remove(0);
                        byte[] buf = job.getBytes("ISO-8859-1");
                        String s = Utils.hexArrayAsString(buf);
                        System.out.println("s: " + s);
                        out.write(buf);
                        out.flush();
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "GenericSerialPrinter: port ocupat : \"/dev/ttyUSB4\"", LangRoAll.nuPotContinua);
                serialPort.close();
                Logger.logDebug(this, "Am inchis portul: /dev/ttyUSB4");
            }
            catch (Exception e) {
                try {
                    Logger.logException(this, e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    serialPort.close();
                    Logger.logDebug(this, "Am inchis portul: /dev/ttyUSB4");
                }
            }
            System.out.println("Thread exiting");
        }
    }
}

