/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.print.printers;

import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.print.PrintService;
import org.apache.fop.layout.Page;
import org.apache.fop.render.awt.AWTRenderer;

public class PrintRenderer
extends AWTRenderer {
    private static final int EVEN_AND_ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private int startNumber;
    private int endNumber;
    private int mode = 0;
    private PrinterJob printerJob;

    PrintRenderer(PrinterJob printerJob, PrintService printService) throws PrinterException {
        super(null);
        this.printerJob = printerJob;
        this.startNumber = 0;
        this.endNumber = -1;
        printerJob.setPageable((Pageable)((Object)this));
        printerJob.setPrintService(printService);
        this.mode = 0;
        String str = System.getProperty("even");
        if (str != null) {
            try {
                this.mode = Boolean.valueOf(str) != false ? 1 : 2;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        super.stopRenderer(outputStream);
        if (this.endNumber == -1) {
            this.endNumber = this.getPageCount();
        }
        Vector numbers = this.getInvalidPageNumbers();
        for (int i = numbers.size() - 1; i > -1; --i) {
            this.removePage(Integer.parseInt((String)numbers.elementAt(i)));
        }
        try {
            this.printerJob.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
            throw new IOException("Unable to print: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void renderPage(Page page) {
        this.pageWidth = (int)((double)page.getWidth() / 1000.0);
        this.pageHeight = (int)((double)page.getHeight() / 1000.0);
        super.renderPage(page);
    }

    private Vector getInvalidPageNumbers() {
        Vector<String> vec = new Vector<String>();
        int max = this.getPageCount();
        for (int i = 0; i < max; ++i) {
            boolean isValid = true;
            if (i < this.startNumber || i > this.endNumber) {
                isValid = false;
            } else if (this.mode != 0) {
                if (this.mode == 1 && (i + 1) % 2 != 0) {
                    isValid = false;
                } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                    isValid = false;
                }
            }
            if (isValid) continue;
            vec.add(i + "");
        }
        return vec;
    }
}

