/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie;

import com.google.code.gsonrmi.annotations.RMI;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.productie.ProductieInterface;
import ro.atreides.productie.db.NewProductieDao;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.Messenger;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;
import ro.deversoft.android.kitchendroid.ColorConfig;
import ro.deversoft.android.kitchendroid.KitchenDroidConfiguration;
import ro.deversoft.android.kitchendroid.KitchenDroidStatus;
import ro.deversoft.android.kitchendroid.KitchenDroidTimeStatus;
import ro.deversoft.android.kitchendroid.KitchenOrderBean;
import ro.deversoft.android.kitchendroid.KitchenSaleBean;

public class NewProductieLogic
extends GSONEntity {
    private static NewProductieLogic instance;
    private static Hashtable<String, KitchenDroidConfiguration> devices;
    private Hashtable<String, Integer> sectiiIdMapping = new Hashtable();
    private Hashtable<String, Integer> locatiiIdMapping = new Hashtable();
    private ProductieInterface productieInterface;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private NewProductieLogic(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
    }

    public static synchronized NewProductieLogic getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            instance = new NewProductieLogic(url, serverName, clientName, listeningPort);
        }
        catch (InvocationTargetException e) {
            Logger.logException(NewProductieLogic.class.getName(), (Exception)e);
        }
        catch (URISyntaxException e) {
            Logger.logException(NewProductieLogic.class.getName(), (Exception)e);
        }
        return instance;
    }

    public static synchronized NewProductieLogic getInstance() {
        return instance;
    }

    private synchronized NewProductieDao getProductieDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        NewProductieDao dao = null;
        while (dao == null) {
            dao = (NewProductieDao)this.pool.getDao(NewProductieDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(NewProductieDao.class.getName(), connection);
        }
        return dao;
    }

    public void setProductieInterface(ProductieInterface productieInterface) {
        this.productieInterface = productieInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(final String name, String configFile) {
        try {
            Utils.importXml(new DefaultHandler(){
                KitchenDroidConfiguration deviceConf = null;
                ColorConfig currentColorConfig = null;
                KitchenDroidStatus currentColorStatus = null;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("device")) {
                        this.deviceConf = new KitchenDroidConfiguration();
                        this.deviceConf.setByProduct(Boolean.valueOf(attributes.getValue("byProduct")));
                        this.deviceConf.setConfirmAction(Boolean.valueOf(attributes.getValue("confirmAction")));
                        this.deviceConf.setShowHeader(Boolean.valueOf(attributes.getValue("showHeader")));
                        this.deviceConf.setShowOptions(Boolean.valueOf(attributes.getValue("showOptions")));
                        this.deviceConf.setShowOperator(Boolean.valueOf(attributes.getValue("showOperator")));
                        this.deviceConf.setShowNrBon(Boolean.valueOf(attributes.getValue("showNrBon")));
                        this.deviceConf.setShowTable(Boolean.valueOf(attributes.getValue("showTable")));
                        this.deviceConf.setHeaderFontSize(Integer.valueOf(attributes.getValue("headerFontSize")));
                        this.deviceConf.setOptionsFontSize(Integer.valueOf(attributes.getValue("optionsFontSize")));
                        this.deviceConf.setProductLineFontSize(Integer.valueOf(attributes.getValue("productFontSize")));
                        this.deviceConf.setPollingSeconds(Integer.valueOf(attributes.getValue("refreshSeconds")));
                        this.deviceConf.setAlertMinutes(Integer.valueOf(attributes.getValue("alertMinutes")));
                        this.deviceConf.setCriticalMinutes(Integer.valueOf(attributes.getValue("criticalMinutes")));
                        this.deviceConf.setColumns(Integer.valueOf(attributes.getValue("columns")));
                        this.deviceConf.setMinutesToAutoModify(Integer.valueOf(attributes.getValue("autoModifyMinutes")));
                        this.deviceConf.setOldestFirst(Boolean.valueOf(attributes.getValue("oldestFirst")));
                        this.deviceConf.setCriticalColor(attributes.getValue("criticalColor"));
                        this.deviceConf.setAlertColor(attributes.getValue("alertColor"));
                        this.deviceConf.setProductLineHeight(Integer.valueOf(attributes.getValue("productLineHeight")));
                        this.deviceConf.setOptionsLineHeight(Integer.valueOf(attributes.getValue("optionsLineHeight")));
                        this.deviceConf.setHeaderTextColor(attributes.getValue("headerTextColor"));
                        this.deviceConf.setHeaderBgColor(attributes.getValue("headerBgColor"));
                        this.deviceConf.setHeaderFormat(attributes.getValue("headerFormat"));
                        String sectiiNames = attributes.getValue("sections");
                        Vector sectiiList = Utils.splitString(sectiiNames, ',');
                        for (String sectie : sectiiList) {
                            this.deviceConf.addSectie(sectie);
                        }
                        String locatiiNames = attributes.getValue("locations");
                        Vector locatiiList = Utils.splitString(locatiiNames, ',');
                        for (String locatie : locatiiList) {
                            this.deviceConf.addLocatie(locatie);
                        }
                        String writeStatusList = attributes.getValue("writeStatusList");
                        Vector statusList = Utils.splitString(writeStatusList, ',');
                        for (String status : statusList) {
                            this.deviceConf.addWriteStatus(KitchenDroidStatus.valueOf(status));
                        }
                        String readStatusList = attributes.getValue("readStatusList");
                        statusList = Utils.splitString(readStatusList, ',');
                        for (String status : statusList) {
                            this.deviceConf.addReadStatus(KitchenDroidStatus.valueOf(status));
                        }
                    }
                    if (qName.equalsIgnoreCase("color")) {
                        this.currentColorStatus = KitchenDroidStatus.valueOf(attributes.getValue("status"));
                        this.currentColorConfig = new ColorConfig(attributes.getValue("headerBgColor"), attributes.getValue("headerFgColor"), attributes.getValue("hourBgColor"), attributes.getValue("hourFgColor"), attributes.getValue("optionsBgColor"), attributes.getValue("optionsFgColor"), attributes.getValue("productBgColor"), attributes.getValue("productFgColor"), attributes.getValue("quantityBgColor"), attributes.getValue("quantityFgColor"));
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("device")) {
                        NewProductieLogic.this.addConfiguration(name, this.deviceConf);
                    }
                    if (qName.equalsIgnoreCase("color")) {
                        this.deviceConf.setColorConf(this.currentColorStatus, this.currentColorConfig);
                    }
                }
            }, configFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void addConfiguration(String name, KitchenDroidConfiguration configuration) {
        devices.put(name, configuration);
    }

    @RMI
    public KitchenDroidConfiguration getKitchenConfiguration(String name) {
        return devices.get(name);
    }

    @RMI
    public List<KitchenSaleBean> getKitchenBeans(String devicename) {
        KitchenDroidConfiguration configuration = devices.get(devicename);
        Logger.logDebug(this, "getKitchenBeans for device " + devicename + " : sectii : " + configuration.getSectii());
        return this.getSalesBean(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public Boolean setStatusToBean(KitchenSaleBean bean) {
        try {
            this.setStatusToBeanNoCommit(bean);
            this.pool.commit();
            Boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void setStatusToBeanNoCommit(KitchenSaleBean bean) throws SQLException {
        if (bean.getStatus() == KitchenDroidStatus.RETUR) {
            int idMessage = bean.getIdProductie();
            Messenger.getInstance().deleteMessageByIdNoCommit(idMessage);
        } else {
            KitchenDroidStatus nextStatus = this.getNextStatus(bean.getStatus());
            this.getProductieDao().setStatus(bean.getIdProductie(), nextStatus);
        }
    }

    private KitchenDroidStatus getNextStatus(KitchenDroidStatus currentStatus) {
        if (currentStatus.equals((Object)KitchenDroidStatus.NEW)) {
            return KitchenDroidStatus.DELIVERED;
        }
        return KitchenDroidStatus.NEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public Collection<KitchenOrderBean> getKitchenOrders(String devicename) {
        KitchenDroidConfiguration configuration = devices.get(devicename);
        Logger.logDebug(this, "getKitchenOrders for device " + devicename + " : sectii : " + configuration.getSectii());
        Collection<KitchenOrderBean> resultOrders = null;
        Vector<KitchenSaleBean> toAutoModify = new Vector<KitchenSaleBean>();
        do {
            toAutoModify.clear();
            List<KitchenSaleBean> allSales = this.getSalesBean(configuration);
            Map<Integer, KitchenOrderBean> map = Collections.synchronizedMap(new LinkedHashMap());
            Vector<KitchenSaleBean> returBeans = this.getReturSaleBeans(devicename);
            for (KitchenSaleBean saleBean : returBeans) {
                this.prepareSaleBeanForDevice(map, saleBean, configuration);
            }
            for (KitchenSaleBean saleBean : allSales) {
                this.prepareSaleBeanForDevice(map, saleBean, configuration);
            }
            resultOrders = map.values();
            for (KitchenOrderBean orderBean : resultOrders) {
                for (KitchenSaleBean saleBean : orderBean.getSales()) {
                    if (!NewProductieLogic.mustAutoModifySale(saleBean, new Date(), configuration)) continue;
                    toAutoModify.add(saleBean);
                }
            }
            if (toAutoModify.size() <= 0) continue;
            try {
                for (KitchenSaleBean saleBean : toAutoModify) {
                    this.setStatusToBeanNoCommit(saleBean);
                }
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } while (toAutoModify.size() > 0);
        return resultOrders;
    }

    private static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    private static boolean mustAutoModifySale(KitchenSaleBean saleBean, Date serverTime, KitchenDroidConfiguration config) {
        int nrMin = config.getMinutesToAutoModify();
        Date opendate = saleBean.getSaleDate();
        long dateDiff = NewProductieLogic.getDateDiff(opendate, serverTime, TimeUnit.MINUTES);
        return dateDiff >= (long)nrMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSaleBeanForDevice(Map<Integer, KitchenOrderBean> map, KitchenSaleBean saleBean, KitchenDroidConfiguration config) {
        int idOrder = saleBean.getIdOrder();
        KitchenOrderBean orderBean = map.get(idOrder);
        if (orderBean == null) {
            orderBean = new KitchenOrderBean();
            orderBean.setSales(new Vector<KitchenSaleBean>());
            orderBean.setIdOrder(idOrder);
            Order order = null;
            Table table = null;
            Location location = null;
            User user = null;
            Client client = null;
            try {
                order = RestLogic.getInstance().getOrderByIdNoCommit(idOrder);
                if (order == null) {
                    return;
                }
                int idTable = order.getTable();
                table = RestLogic.getInstance().getTableByIdNoCommit(idTable);
                int idLocation = table.getIdLocatie();
                location = RestLogic.getInstance().getLocationByIdNoCommit(idLocation);
                int idWaiter = order.getUser();
                user = UsersLogic.getInstance().getUserByIdNoCommit(idWaiter);
                client = ClientLogic.getInstance().getClientByIdNoCommit(order.getIdClient());
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            String headerLine = config.getHeaderFormat();
            String dataComanda = Formatters.TIME_FORMAT.format(saleBean.getOrderDate());
            if (!DateUtils.sameDay(new Timestamp(saleBean.getOrderDate().getTime()), DateUtils.getCurrentTimestamp())) {
                dataComanda = Formatters.DATE_AND_TIME_FORMAT.format(saleBean.getOrderDate());
            }
            headerLine = headerLine.replace("%%date%%", dataComanda);
            headerLine = headerLine.replace("%%table%%", table.getLabel());
            headerLine = headerLine.replace("%%location%%", location.getName());
            headerLine = headerLine.replace("%%waiter%%", user.getLogin());
            headerLine = headerLine.replace("%%details%%", order.getDetalii());
            headerLine = headerLine.replace("%%delivery%%", order.getAdresaLivrare());
            headerLine = headerLine.replace("%%client_name%%", client != null ? client.toString() : "");
            headerLine = headerLine.replace("%%client_phone%%", client != null ? client.getTelefoane(", ") : "");
            headerLine = headerLine.replace("%%order_no%%", order.getId() + "");
            headerLine = headerLine.replace("%%protocol%%", order.isProtocol() ? "Protocol" : "");
            headerLine = headerLine.replaceAll("\\s+", " ");
            headerLine = headerLine.trim();
            orderBean.setDetaliiLivrare(headerLine);
            map.put(idOrder, orderBean);
        }
        orderBean.getSales().add(saleBean);
    }

    public void addSaleBeanNoCommit(int idSale) throws SQLException {
        this.getProductieDao().add(idSale, KitchenDroidStatus.NEW.getCode());
    }

    public void addMessageOnChannel(int idSectie, int idLocatie, String productName, double quantityRemoved, int idOrder, String optiuni, long orderDate, long saleDate, String servire) throws SQLException {
        for (String deviceName : devices.keySet()) {
            KitchenDroidConfiguration configuration = devices.get(deviceName);
            boolean addForSectie = false;
            Vector<String> sectiiNames = configuration.getSectii();
            Vector<Integer> sectiiIds = this.buildSectiiIdsSqlIn(sectiiNames);
            if (sectiiIds.size() > 0) {
                for (Integer sectiiId : sectiiIds) {
                    if (sectiiId != idSectie) continue;
                    addForSectie = true;
                    break;
                }
            } else {
                addForSectie = true;
            }
            boolean addForLocatie = false;
            Vector<String> locatiiNames = configuration.getLocatii();
            Vector<Integer> locatiiIds = this.buildLocatiiIdsSqlIn(locatiiNames);
            if (locatiiIds.size() > 0) {
                for (Integer locatieId : locatiiIds) {
                    if (locatieId != idLocatie) continue;
                    addForLocatie = true;
                    break;
                }
            } else {
                addForLocatie = true;
            }
            if (!addForSectie || !addForLocatie) continue;
            String channel = deviceName;
            String payload = Messenger.codeInfosInMessageText(this.buildReturHash(productName, quantityRemoved, idOrder, optiuni, orderDate, saleDate, servire));
            Messenger.getInstance().addMessage(channel, payload, System.currentTimeMillis() + 3600000L);
        }
    }

    private Map<String, String> buildReturHash(String productName, double quantityRemoved, int idOrder, String optiuni, long orderDate, long saleDate, String servire) {
        Map<String, String> result = Collections.synchronizedMap(new LinkedHashMap());
        result.put(RETUR_KEYS.RETUR_HEADER.toString(), "true");
        result.put(RETUR_KEYS.ID_ORDER.toString(), idOrder + "");
        result.put(RETUR_KEYS.PRODUCT_QTY.toString(), quantityRemoved + "");
        result.put(RETUR_KEYS.PRODUCT_NAME.toString(), productName);
        result.put(RETUR_KEYS.OPTIUNI_PREPARARE.toString(), optiuni);
        result.put(RETUR_KEYS.ORDER_DATE.toString(), orderDate + "");
        result.put(RETUR_KEYS.SALE_DATE.toString(), saleDate + "");
        result.put(RETUR_KEYS.SERVIRE.toString(), servire);
        return result;
    }

    private Vector<KitchenSaleBean> getReturSaleBeans(String deviceName) {
        Vector<KitchenSaleBean> result = new Vector<KitchenSaleBean>();
        Vector<Message> allMess = Messenger.getInstance().getMessages(deviceName);
        for (Message mess : allMess) {
            String text = mess.getText();
            if (!text.contains(RETUR_KEYS.RETUR_HEADER.toString())) continue;
            Hashtable<String, String> messengerPayload = Messenger.getInfosCodedInMessageText(text);
            KitchenSaleBean toadd = new KitchenSaleBean();
            toadd.setIdProductie(mess.getId());
            Integer idOrder = Integer.valueOf(messengerPayload.get(RETUR_KEYS.ID_ORDER.toString()));
            toadd.setIdOrder(idOrder);
            toadd.setQuantity(-Utils.parseDouble(messengerPayload.get(RETUR_KEYS.PRODUCT_QTY.toString())));
            toadd.setProduct(messengerPayload.get(RETUR_KEYS.PRODUCT_NAME.toString()));
            toadd.setOptions(messengerPayload.get(RETUR_KEYS.OPTIUNI_PREPARARE.toString()));
            long orderDate = Long.parseLong(messengerPayload.get(RETUR_KEYS.ORDER_DATE.toString()));
            toadd.setOrderDate(new Date(orderDate));
            long saleDate = Long.parseLong(messengerPayload.get(RETUR_KEYS.SALE_DATE.toString()));
            toadd.setSaleDate(new Date(saleDate));
            toadd.setStatus(KitchenDroidStatus.RETUR);
            result.add(toadd);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KitchenSaleBean> getSalesBean(KitchenDroidConfiguration configuration) {
        Vector<String> locatiiNames;
        Vector<Integer> locatiiIds;
        List<KitchenSaleBean> result = null;
        Hashtable searchCriteria = new Hashtable();
        Vector<String> sectiiNames = configuration.getSectii();
        Vector<Integer> sectiiIds = this.buildSectiiIdsSqlIn(sectiiNames);
        if (sectiiIds.size() > 0) {
            searchCriteria.put(Constants.SECTIE_KEY, sectiiIds);
        }
        if ((locatiiIds = this.buildLocatiiIdsSqlIn(locatiiNames = configuration.getLocatii())).size() > 0) {
            searchCriteria.put(Constants.LOCATIE_KEY, locatiiIds);
        }
        Vector<Integer> readStatInt = new Vector<Integer>();
        Vector<KitchenDroidStatus> readStatuses = configuration.getReadStatuses();
        for (KitchenDroidStatus status : readStatuses) {
            readStatInt.add(status.getCode());
        }
        searchCriteria.put(Constants.STATUS, readStatInt);
        try {
            result = this.getProductieDao().getBeansSimple(this.pool.requestConnection().getConnection(), searchCriteria, configuration.isByProduct(), configuration.isOldestFirst());
        }
        catch (SQLException e) {
            KitchenDroidStatus status;
            Logger.logException(this, (Exception)e);
            status = null;
            return status;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Iterator<Object> i$ = result.iterator();
        while (i$.hasNext()) {
            Date now = new Date();
            KitchenSaleBean saleBean = (KitchenSaleBean)i$.next();
            Date saleDate = saleBean.getSaleDate();
            if (now.after(DateUtils.addMinutesToDate(saleDate, configuration.getAlertMinutes()))) {
                saleBean.setTimeStatus(KitchenDroidTimeStatus.ALERT);
            }
            if (now.after(DateUtils.addMinutesToDate(saleDate, configuration.getCriticalMinutes()))) {
                saleBean.setTimeStatus(KitchenDroidTimeStatus.CRITICAL);
            }
            saleBean.setMillisSinceCreation(now.getTime() - saleDate.getTime());
        }
        return result;
    }

    private synchronized Vector<Integer> buildSectiiIdsSqlIn(Vector<String> sectiiNames) {
        Vector<Integer> result = new Vector<Integer>();
        for (String sectie : sectiiNames) {
            Integer idFromHash = this.sectiiIdMapping.get(sectie);
            if (idFromHash == null) {
                Sectie s = NomeclaturaLogic.getInstance().getSectieByName(sectie);
                if (s != null) {
                    idFromHash = s.getId();
                    this.sectiiIdMapping.put(sectie, idFromHash);
                } else {
                    Logger.logDebug(this, "sectie negasita : " + sectie);
                    continue;
                }
            }
            result.add(idFromHash);
        }
        return result;
    }

    private synchronized Vector<Integer> buildLocatiiIdsSqlIn(Vector<String> locatiiNames) {
        Vector<Integer> result = new Vector<Integer>();
        for (String locatie : locatiiNames) {
            Integer idFromHash = this.locatiiIdMapping.get(locatie);
            if (idFromHash == null) {
                Location loc = RestLogic.getInstance().getLocationByName(locatie);
                if (loc != null) {
                    idFromHash = loc.getId();
                    this.locatiiIdMapping.put(locatie, idFromHash);
                } else {
                    Logger.logDebug(this, "locatie negasita : " + locatie);
                    continue;
                }
            }
            result.add(idFromHash);
        }
        return result;
    }

    static {
        devices = new Hashtable();
    }

    private static enum RETUR_KEYS {
        PRODUCT_NAME,
        PRODUCT_QTY,
        ID_ORDER,
        RETUR_HEADER,
        SALE_DATE,
        ORDER_DATE,
        OPTIUNI_PREPARARE,
        SERVIRE;

    }
}

