/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;
import ro.deversoft.android.kitchendroid.KitchenDroidStatus;
import ro.deversoft.android.kitchendroid.KitchenSaleBean;

public class NewProductieDao
implements DaoInterface {
    private PreparedStatement add;
    private PreparedStatement updateStatus;
    private Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public NewProductieDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.add = this.connection.prepareStatement("insert into productie_new ( status, id_sale ) values ( ?, ? )");
        this.updateStatus = this.connection.prepareStatement("update productie_new set status = ? where id = ?");
    }

    public void add(int idSale, int status) throws SQLException {
        this.add.setInt(1, status);
        this.add.setInt(2, idSale);
        this.add.execute();
    }

    public void setStatus(int idProductie, KitchenDroidStatus newStatus) throws SQLException {
        this.updateStatus.setInt(1, newStatus.getCode());
        this.updateStatus.setInt(2, idProductie);
        this.updateStatus.execute();
    }

    public List<KitchenSaleBean> getBeansSimple(Connection connection, Hashtable searchCriteria, boolean byProduct, boolean oldestFirst) throws SQLException {
        Vector readStatusList;
        Vector idLocatii;
        ArrayList<KitchenSaleBean> result = new ArrayList<KitchenSaleBean>();
        String s = "select productie_new.id as id_productie, sales.mod_preparare as optiuni_preparare, products.label as nume_produs, sales.quantity_float as cantitate, sales.id_order as id_order, productie_new.status as status_productie,  sales.saledate as sale_date, orders.opendate as order_date from productie_new inner join sales on productie_new.id_sale = sales.id inner join orders on sales.id_order = orders.id inner join products on sales.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id inner join tables on orders.id_table = tables.id where 1=1";
        Vector idSectii = (Vector)searchCriteria.get(Constants.SECTIE_KEY);
        if (idSectii != null && idSectii.size() > 0) {
            s = s + " and (subcategories.id_category in " + Utils.getSqlInSequence(idSectii) + " )";
        }
        if ((idLocatii = (Vector)searchCriteria.get(Constants.LOCATIE_KEY)) != null && idLocatii.size() > 0) {
            s = s + " and (tables.id_locatie in " + Utils.getSqlInSequence(idLocatii) + " )";
        }
        if ((readStatusList = (Vector)searchCriteria.get(Constants.STATUS)) != null && readStatusList.size() > 0) {
            s = s + " and (productie_new.status in " + Utils.getSqlInSequence(readStatusList) + " )";
        }
        String desc = oldestFirst ? "" : "desc";
        s = byProduct ? s + " order by sale_date " + desc : s + " order by order_date " + desc + ", sale_date " + desc;
        Logger.logDebug(this, "getBeansSimpleQuery: " + s);
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        while (rs.next()) {
            KitchenSaleBean toadd = new KitchenSaleBean();
            toadd.setOrderDate(rs.getTimestamp("order_date"));
            toadd.setSaleDate(rs.getTimestamp("sale_date"));
            toadd.setIdProductie(rs.getInt("id_productie"));
            toadd.setOptions(rs.getString("optiuni_preparare"));
            toadd.setQuantity(rs.getDouble("cantitate"));
            toadd.setProduct(rs.getString("nume_produs"));
            toadd.setIdOrder(rs.getInt("id_order"));
            KitchenDroidStatus status_productie = KitchenDroidStatus.getByCode(rs.getInt("status_productie"));
            toadd.setStatus(status_productie);
            result.add(toadd);
        }
        rs.close();
        return result;
    }
}

