/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.productie.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.productie.ProductieEntry;
import ro.atreides.utils.gui.table.AbstractTM;

public class ProductieCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;
    private int FONT_SIZE = 24;

    public ProductieCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this.model.getData() != null && row < this.model.getData().size()) {
            Object o = this.model.getData().elementAt(row);
            if (o instanceof String) {
                this.setBackground(Color.GRAY);
            } else {
                ProductieEntry se = (ProductieEntry)o;
                if (se.isSelected()) {
                    table.setFont(new Font(null, 1, this.FONT_SIZE));
                } else {
                    this.setFont(new Font(null, 0, this.FONT_SIZE));
                }
                int status = se.getStatus();
                switch (status) {
                    case 1: {
                        this.setBackground(Color.CYAN);
                        break;
                    }
                    case 6: {
                        this.setBackground(Color.YELLOW);
                        break;
                    }
                    case 5: {
                        this.setBackground(Color.RED);
                        break;
                    }
                    case 7: {
                        this.setBackground(Color.WHITE);
                    }
                }
            }
        }
        return this;
    }
}

